/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_Container_MultiMachineEM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_GUIContainer_MultiMachineEM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.blocks.HETieredTileEntity;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class HEHydroTurbineTileEntity
extends HETieredTileEntity {
    private static Textures.BlockIcons.CustomIcon textureScreenTurbineON;
    private static Textures.BlockIcons.CustomIcon textureScreenTurbineOFF;
    private static Textures.BlockIcons.CustomIcon textureScreenArrowDownAnimated;
    private final int blockTextureIndex = this.getCasingTextureId();

    public HEHydroTurbineTileEntity(int tierId) {
        super("he_turbine_" + GT_Values.VN[tierId].toLowerCase());
    }

    public HEHydroTurbineTileEntity(int blockId, int tierId) {
        super(blockId + tierId, "he_turbine_" + GT_Values.VN[tierId].toLowerCase(), "Hydro Turbine (" + GT_Values.VN[tierId] + ")");
    }

    @Override
    public void onTick() {
        int consumableWaterPerTick = (int)((float)this.getVoltage() * HEConfig.milliBucketPerEU);
        int consumedWater = 0;
        for (FluidStack fluidStack : this.getStoredFluids()) {
            if (fluidStack.getFluidID() != HE.pressurizedWater.getID()) continue;
            int consumableWater = Math.max(0, consumableWaterPerTick - consumedWater);
            int processedWater = Math.min(fluidStack.amount, consumableWater);
            fluidStack.amount -= processedWater;
            consumedWater += processedWater;
        }
        float producedEU = (float)consumedWater * HEConfig.euPerMilliBucket;
        producedEU *= this.getEfficiencyModifier();
        this.addEnergyOutput_EM((int)(producedEU *= (float)this.getCurrentEfficiency(null) / 10000.0f), 1L);
        this.addOutput(new FluidStack(FluidRegistry.WATER, consumedWater));
    }

    public Object getServerGUI(int id, InventoryPlayer playerInventory, IGregTechTileEntity baseMetaTileEntity) {
        return new GT_Container_MultiMachineEM(playerInventory, baseMetaTileEntity, false, false, false);
    }

    public Object getClientGUI(int id, InventoryPlayer playerInventory, IGregTechTileEntity baseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachineEM(playerInventory, baseMetaTileEntity, this.getLocalName(), "EMDisplay.png", false, false, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister blockIconRegister) {
        textureScreenTurbineOFF = new Textures.BlockIcons.CustomIcon("iconsets/he_turbine");
        textureScreenTurbineON = new Textures.BlockIcons.CustomIcon("iconsets/he_turbine_active");
        textureScreenArrowDownAnimated = new Textures.BlockIcons.CustomIcon("iconsets/he_arrow_down_animated");
        super.registerIcons(blockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, byte side, byte facing, byte colorIndex, boolean isActive, boolean hasRedstoneSignal) {
        if (side == facing) {
            if (isActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.blockTextureIndex >> 6][this.blockTextureIndex & 0x3F], new TT_RenderedExtendedFacingTexture((IIconContainer)textureScreenTurbineON), new TT_RenderedExtendedFacingTexture((IIconContainer)textureScreenArrowDownAnimated)};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.blockTextureIndex >> 6][this.blockTextureIndex & 0x3F], new TT_RenderedExtendedFacingTexture((IIconContainer)textureScreenTurbineOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.blockTextureIndex >> 6][this.blockTextureIndex & 0x3F]};
    }

    public String[] getDescription() {
        return new String[]{"Hydro Turbine Controller", "Controller Block for the Hydro Turbine", "Consumes pressurize water to produce EU", "Input is pressurized water from Hydro Dams", "Requires a Dynamo, Input, Output and Maintenance Hatch anywhere!", "Produces up to " + this.getMilliBucketsPerTick() + "mB Water per Tick", "Efficiency: " + this.getEfficiencyModifierInPercent(), HE.blueprintHintTecTech, "Use Redstone to automate!"};
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[]{"1 Dynamo Hatch", "1 Fluid Input Hatch", "1 Fluid Output Hatch", "1 Maintenance Hatch", "Fill the rest with " + this.getCasingName()};
    }

    @Override
    protected long getEnergyConsumption() {
        return this.getVoltage();
    }

    public static class MAX
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 14;

        public MAX() {
            super(14);
        }

        public MAX(int id) {
            super(id, 14);
        }

        @Override
        protected int getTier() {
            return 14;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new MAX();
        }
    }

    public static class UXV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 13;

        public UXV() {
            super(13);
        }

        public UXV(int id) {
            super(id, 13);
        }

        @Override
        protected int getTier() {
            return 13;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UXV();
        }
    }

    public static class UMV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 12;

        public UMV() {
            super(12);
        }

        public UMV(int id) {
            super(id, 12);
        }

        @Override
        protected int getTier() {
            return 12;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UMV();
        }
    }

    public static class UIV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 11;

        public UIV() {
            super(11);
        }

        public UIV(int id) {
            super(id, 11);
        }

        @Override
        protected int getTier() {
            return 11;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UIV();
        }
    }

    public static class UEV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 10;

        public UEV() {
            super(10);
        }

        public UEV(int id) {
            super(id, 10);
        }

        @Override
        protected int getTier() {
            return 10;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UEV();
        }
    }

    public static class UHV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 9;

        public UHV() {
            super(9);
        }

        public UHV(int id) {
            super(id, 9);
        }

        @Override
        protected int getTier() {
            return 9;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UHV();
        }
    }

    public static class UV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 8;

        public UV() {
            super(8);
        }

        public UV(int id) {
            super(id, 8);
        }

        @Override
        protected int getTier() {
            return 8;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UV();
        }
    }

    public static class ZPM
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 7;

        public ZPM() {
            super(7);
        }

        public ZPM(int id) {
            super(id, 7);
        }

        @Override
        protected int getTier() {
            return 7;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new ZPM();
        }
    }

    public static class LuV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 6;

        public LuV() {
            super(6);
        }

        public LuV(int id) {
            super(id, 6);
        }

        @Override
        protected int getTier() {
            return 6;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new LuV();
        }
    }

    public static class IV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 5;

        public IV() {
            super(5);
        }

        public IV(int id) {
            super(id, 5);
        }

        @Override
        protected int getTier() {
            return 5;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new IV();
        }
    }

    public static class EV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 4;

        public EV() {
            super(4);
        }

        public EV(int id) {
            super(id, 4);
        }

        @Override
        protected int getTier() {
            return 4;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new EV();
        }
    }

    public static class HV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 3;

        public HV() {
            super(3);
        }

        public HV(int id) {
            super(id, 3);
        }

        @Override
        protected int getTier() {
            return 3;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new HV();
        }
    }

    public static class MV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 2;

        public MV() {
            super(2);
        }

        public MV(int id) {
            super(id, 2);
        }

        @Override
        protected int getTier() {
            return 2;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new MV();
        }
    }

    public static class LV
    extends HEHydroTurbineTileEntity {
        private static final int tierId = 1;

        public LV() {
            super(1);
        }

        public LV(int id) {
            super(id, 1);
        }

        @Override
        protected int getTier() {
            return 1;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new LV();
        }
    }
}

