/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.client.gui.HEHydroDamEuGuiContainer;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.network.container.HEHydroDamEuContainer;
import com.sinthoras.hydroenergy.server.HEServer;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HEHydroDamTileEntity
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon Screen;
    private static final int steelTextureIndex = 16;
    private static final int concreteBlockMeta = 8;
    private int waterId = -1;
    private long euStored = 0L;
    private long euCapacity = 0L;
    private long euCapacityGui = 0L;
    private int euPerTickIn = 0;
    private int euPerTickOut = 0;
    private final HEUtil.AveragedRingBuffer euPerTickOutAverage = new HEUtil.AveragedRingBuffer(64);
    private final HEUtil.AveragedRingBuffer euPerTickInAverage = new HEUtil.AveragedRingBuffer(64);
    private static final IStructureDefinition<HEHydroDamTileEntity> multiblockDefinition;
    private static final String[] mouseOverDescription;
    private static final String[] chatDescription;

    public HEHydroDamTileEntity(String name) {
        super(name);
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    public HEHydroDamTileEntity(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new HEHydroDamTileEntity(this.mName);
    }

    protected boolean checkMachine_EM(IGregTechTileEntity gregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM("main", 2, 3, 0);
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM("main", 2, 3, 0, hintsOnly, itemStack);
    }

    public IStructureDefinition<HEHydroDamTileEntity> getStructure_EM() {
        return multiblockDefinition;
    }

    public boolean checkRecipe_EM(ItemStack stack) {
        this.mMaxProgresstime = 1;
        return true;
    }

    private float getMaxGuiPressure() {
        boolean configCircuitIsPresent = this.mInventory != null && this.mInventory[1] != null && this.mInventory[1].func_77973_b() == GT_Utility.getIntegratedCircuit((int)0).func_77973_b();
        int voltageTier = configCircuitIsPresent ? HEUtil.clamp(this.mInventory[1].func_77960_j(), 1, GT_Values.V.length - 1) : 1;
        return HEConfig.pressureIncreasePerTier * (float)voltageTier;
    }

    public boolean onRunningTick(ItemStack stack) {
        this.mProgresstime = 0;
        this.euPerTickIn = 0;
        this.euPerTickOut = 0;
        this.euCapacity = HEServer.instance.getEuCapacity(this.waterId);
        this.euStored = HEUtil.clamp(this.euStored, 0L, this.euCapacity);
        this.euCapacityGui = HEServer.instance.getEuCapacityAt(this.waterId, (int)((float)this.getBaseMetaTileEntity().getYCoord() + this.getMaxGuiPressure()));
        int waterLevelOverController = (int)(HEServer.instance.getWaterLevel(this.waterId) - (float)this.getBaseMetaTileEntity().getYCoord());
        this.getStoredFluids().forEach(fluidStack -> {
            if (fluidStack.getFluidID() == HE.pressurizedWater.getID() && HE.pressurizedWater.getPressure((FluidStack)fluidStack) >= (float)waterLevelOverController) {
                long avaiableEnergy = (long)((float)fluidStack.amount * HEConfig.euPerMilliBucket);
                long storableEnergy = Math.min(this.euCapacity - this.euStored, avaiableEnergy);
                fluidStack.amount = (int)((long)fluidStack.amount - storableEnergy);
                this.euStored += storableEnergy;
                this.euPerTickIn = (int)((long)this.euPerTickIn + storableEnergy);
            }
        });
        int availableOutput = (int)Math.min((long)HEConfig.damDrainPerSecond, this.euStored);
        int availableOutputAsWater = (int)((float)availableOutput * HEConfig.milliBucketPerEU);
        if (availableOutput > 0) {
            int distributedFluid = this.distributeFluid(new FluidStack((Fluid)HE.pressurizedWater, availableOutputAsWater));
            long distributedEu = (long)((float)distributedFluid * HEConfig.euPerMilliBucket);
            this.euStored -= distributedEu;
            this.euPerTickOut = (int)((long)this.euPerTickOut + distributedEu);
        }
        if (this.getBaseMetaTileEntity().getWorld().func_72896_J()) {
            long raingEuGeneration = (long)((float)HEServer.instance.getRainedOnBlocks(this.waterId) * HEConfig.waterBonusPerSurfaceBlockPerRainTick);
            long addedEu = Math.min(this.euCapacity - this.euStored, raingEuGeneration);
            this.euStored += addedEu;
            this.euPerTickIn = (int)((long)this.euPerTickIn + addedEu);
        }
        this.euPerTickInAverage.addValue(this.euPerTickIn);
        this.euPerTickOutAverage.addValue(this.euPerTickOut);
        HEServer.instance.setWaterLevel(this.waterId, this.euStored);
        return true;
    }

    private int distributeFluid(FluidStack fluidStack) {
        int availableFluid = fluidStack.amount;
        for (GT_MetaTileEntity_Hatch_Output hatch : this.mOutputHatches) {
            if (!HEHydroDamTileEntity.isValidMetaTileEntity((MetaTileEntity)hatch) || !hatch.outputsLiquids() || hatch.isFluidLocked() && hatch.getLockedFluidName() != null && !hatch.getLockedFluidName().equals(fluidStack.getUnlocalizedName())) continue;
            FluidStack currentFluid = hatch.getFillableStack();
            if (currentFluid == null || currentFluid.getFluid().getID() <= 0) {
                currentFluid = new FluidStack((Fluid)HE.pressurizedWater, 0);
            }
            if (currentFluid.getFluid().getID() != HE.pressurizedWater.getID()) continue;
            int availableSpace = hatch.getCapacity() - currentFluid.amount;
            int placedFluid = Math.min(availableSpace, fluidStack.amount);
            fluidStack.amount -= placedFluid;
            currentFluid.amount += placedFluid;
            hatch.setFillableStack(currentFluid);
        }
        return availableFluid - fluidStack.amount;
    }

    public Object getServerGUI(int id, InventoryPlayer playerInventory, IGregTechTileEntity baseMetaTileEntity) {
        return new HEHydroDamEuContainer(playerInventory, baseMetaTileEntity);
    }

    public Object getClientGUI(int id, InventoryPlayer playerInventory, IGregTechTileEntity baseMetaTileEntity) {
        return new HEHydroDamEuGuiContainer(playerInventory, baseMetaTileEntity, this.getLocalName(), "EMDisplay.png");
    }

    public void onScrewdriverRightClick(byte side, EntityPlayer player, float blockX, float blockY, float blockZ) {
        if (!player.func_70093_af() && this.getBaseMetaTileEntity().isServerSide()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)"hydroenergy", (int)0, (World)this.getBaseMetaTileEntity().getWorld(), (int)this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), (int)this.getBaseMetaTileEntity().getZCoord());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister blockIconRegister) {
        Screen = new Textures.BlockIcons.CustomIcon("iconsets/he_dam");
        super.registerIcons(blockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, byte side, byte facing, byte colorIndex, boolean isActive, boolean hasRedstoneSignal) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), new TT_RenderedExtendedFacingTexture((IIconContainer)Screen)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public void onFirstTick_EM(IGregTechTileEntity baseMetaTileEntity) {
        if (this.waterId == -1 && this.getBaseMetaTileEntity().isServerSide()) {
            int offsetZ;
            int offsetX;
            ForgeDirection direction = this.getExtendedFacing().getDirection();
            boolean offsetY = true;
            if (direction == ForgeDirection.WEST) {
                offsetX = 2;
                offsetZ = 0;
            } else if (direction == ForgeDirection.NORTH) {
                offsetX = 0;
                offsetZ = 2;
            } else if (direction == ForgeDirection.EAST) {
                offsetX = -2;
                offsetZ = 0;
            } else {
                offsetX = 0;
                offsetZ = -2;
            }
            this.waterId = HEServer.instance.onPlacecontroller(this.getBaseMetaTileEntity().getOwnerName(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getXCoord() + offsetX, this.getBaseMetaTileEntity().getYCoord() + 1, this.getBaseMetaTileEntity().getZCoord() + offsetZ);
            this.func_70296_d();
        }
        super.onFirstTick_EM(baseMetaTileEntity);
    }

    public void onRemoval() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            HEServer.instance.onBreakController(this.waterId);
        }
        super.onRemoval();
    }

    public void saveNBTData(NBTTagCompound compound) {
        super.saveNBTData(compound);
        compound.func_74768_a("waId", this.waterId);
        compound.func_74772_a("wSto", this.euStored);
        compound.func_74772_a("wCap", this.euCapacity);
    }

    public void loadNBTData(NBTTagCompound compound) {
        super.loadNBTData(compound);
        this.waterId = compound.func_74762_e("waId");
        this.euStored = compound.func_74763_f("wSto");
        this.euCapacity = compound.func_74763_f("wCap");
    }

    public String[] getDescription() {
        return mouseOverDescription;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return chatDescription;
    }

    public long getEuStored() {
        return this.euStored;
    }

    public long getEuCapacity() {
        return this.euCapacityGui;
    }

    public int getEuPerTickIn() {
        return (int)this.euPerTickInAverage.getAverage();
    }

    public int getEuPerTickOut() {
        return (int)this.euPerTickOutAverage.getAverage();
    }

    public int getWaterId() {
        return this.waterId;
    }

    static {
        multiblockDefinition = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"HHHHH", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"HHHHH", "C   C", "C   C", "C   C", "C   C"}, {"HHHHH", "C   C", "C   C", "C   C", "C   C"}, {"HH~HH", "C   C", "C   C", "C   C", "C   C"}, {"HHHHH", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement(Character.valueOf('H'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, (int)16, (Block)GregTech_API.sBlockConcretes, (int)8), StructureUtility.ofBlockAnyMeta((Block)GregTech_API.sBlockConcretes, (int)8)})).addElement(Character.valueOf('C'), StructureUtility.ofBlockAnyMeta((Block)GregTech_API.sBlockConcretes, (int)8)).build();
        mouseOverDescription = new String[]{"Hydro Dam Controller", "Controller Block for the Hydro Dam", "Input is pressurized water from Hydro Pumps", "Output is pressurized water for Hydro Turbines", "Requires an Input and Output Hatch on the front!", HE.blueprintHintTecTech};
        chatDescription = new String[]{"1 Fluid Input Hatch", "1 Fluid Output Hatch", "Fill the rest with Light Concrete", "No Maintenance Hatch required!"};
    }
}

