package mods.immibis.microblocks;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.immibis.core.api.multipart.IMultipartSystem;
import mods.immibis.core.api.multipart.util.BlockMultipartBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class BlockMicroblockContainer extends BlockMultipartBase {
	protected BlockMicroblockContainer(Material mat) {
		super(mat);
		setBlockName("immibis_microblocks.container");
		setHardness(1);
	}
	
	static int renderType;
	
	@Override
	public int getRenderType() {
		return renderType;
	}

	@Override
	public TileEntity createNewTileEntity(World world, int metadata) {
		return new TileMicroblockContainer();
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerBlockIcons(IIconRegister par1IconRegister) {
	}
	
	@Override
	public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4)
    {
        Block block = par1World.getBlock(par2, par3, par4);
        return block == null || block == this || block.isReplaceable(par1World, par2, par3, par4);
    }
	
	@Override
	public void dropBlockAsItem(World p_149642_1_, int p_149642_2_, int p_149642_3_, int p_149642_4_, ItemStack p_149642_5_) {
		super.dropBlockAsItem(p_149642_1_, p_149642_2_, p_149642_3_, p_149642_4_, p_149642_5_);
	}
	
	@Override
	public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
		IMultipartSystem.instance.hook_addCollisionBoxesToList(world, x, y, z, mask, list, entity);
	}
	
	@Override
	public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 src, Vec3 dst) {
		return IMultipartSystem.instance.hook_collisionRayTrace(null, world, x, y, z, src, dst);
	}
}
