package mods.immibis.microblocks;




import mods.immibis.microblocks.api.EnumPosition;
import mods.immibis.microblocks.api.IMicroblockCoverSystem;
import mods.immibis.microblocks.api.IMicroblockSupporterTile;
import mods.immibis.microblocks.api.PartType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

/**
 * A tile that contains only microblocks.
 */
public class TileMicroblockContainer extends TileEntity implements IMicroblockSupporterTile {
	public MicroblockCoverSystem cover;
	
	public TileMicroblockContainer() {
		cover = new MicroblockCoverSystem(this);
		//System.out.println("tile created "+System.currentTimeMillis());
	}
	
	@Override
	public final Packet getDescriptionPacket() {
		NBTTagCompound tag = new NBTTagCompound();
		tag.setByteArray("C", cover.writeDescriptionBytes());
		return new S35PacketUpdateTileEntity(xCoord, yCoord, zCoord, 0, tag);
	}
	
	@Override
	public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
		cover.readDescriptionBytes(pkt.func_148857_g().getByteArray("C"), 0);
		//System.out.println("got data packet "+System.currentTimeMillis()+" "+cover.parts.size()+" "+xCoord+" "+yCoord+" "+zCoord);
	}

	@Override
	public IMicroblockCoverSystem getCoverSystem() {
		return cover;
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		cover.writeToNBT(tag);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		cover.readFromNBT(tag);
	}

	@Override
	public boolean isPlacementBlocked(PartType<?> type, EnumPosition pos) {
		return false;
	}
	
	@Override
	public void updateEntity() {
		if(!worldObj.isRemote && getClass() == TileMicroblockContainer.class && cover.parts.size() == 0) {
			worldObj.setBlock(xCoord, yCoord, zCoord, Blocks.air, 0, 2);
			return;
		}
	}
	
	@Override
	public boolean canUpdate() {
		return false;
	}

	@Override
	public void onMicroblocksChanged() {
		if(getCoverSystem().getAllParts().size() == 0) {
			worldObj.setBlockToAir(xCoord, yCoord, zCoord);
		} else {
			worldObj.notifyBlocksOfNeighborChange(xCoord, yCoord, zCoord, getBlockType());
			worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
		}
	}
}
