package mods.immibis.microblocks.coremod;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import mods.immibis.core.api.multipart.IMultipartSystem;

public abstract class MSTHooks {
	private MSTHooks() {}
	
	private static IMultipartSystem ims2 = new IMultipartSystem();
	
	public static void init() {
		ims2 = IMultipartSystem.instance;
	}
	
	public static MovingObjectPosition hook_collisionRayTrace(MovingObjectPosition normalResult, World world, int x, int y, int z, Vec3 src, Vec3 dst) {
		return ims2.hook_collisionRayTrace(normalResult, world, x, y, z, src, dst);
	}
	
	public static ItemStack hook_getPickBlock(MovingObjectPosition trace, World world, int x, int y, int z, EntityPlayer player) {
		return ims2.hook_getPickBlock(trace, world, x, y, z, player);
	}
	
	public static void hook_addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
		ims2.hook_addCollisionBoxesToList(world, x, y, z, mask, list, entity);
	}
	
	public static boolean hook_isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
		return ims2.hook_isSideSolid(world, x, y, z, side);
	}
	
	@SideOnly(Side.CLIENT)
	public static boolean hook_addHitEffects(World w, MovingObjectPosition ray, EffectRenderer er) {
		return ims2.hook_addHitEffects(w, ray, er);
	}
	
	public static void onMicroblocksChanged(TileEntity te) {
		te.getWorldObj().markBlockForUpdate(te.xCoord, te.yCoord, te.zCoord);
		te.getWorldObj().notifyBlocksOfNeighborChange(te.xCoord, te.yCoord, te.zCoord, te.getBlockType());
	}
}
