package mods.immibis.microblocks.crossmod;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

import net.minecraft.launchwrapper.IClassTransformer;

public class MicroblocksComputerCraftCompatHack implements IClassTransformer {
	@Override
	public byte[] transform(String arg0, String arg1, byte[] arg2) {
		if(arg2 == null || !arg0.startsWith("dan200.computercraft.shared."))
			return arg2;
		
		// un-finalize all methods
		
		ClassWriter cw = new ClassWriter(0);
		new ClassReader(arg2).accept(new ClassVisitor(Opcodes.ASM5, cw) {
			@Override
			public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
				access &= ~Opcodes.ACC_FINAL;
				return super.visitMethod(access, name, desc, signature, exceptions);
			}
		}, 0);
		return cw.toByteArray();
	}
}
