package mods.immibis.microblocks.crossmod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.ItemFilter;
import mods.immibis.microblocks.ItemMicroblock;
import mods.immibis.microblocks.MicroblockSystem;
import mods.immibis.microblocks.ModProperties;
import mods.immibis.microblocks.coremod.CoreModOptions;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIMicroblocksConfig implements IConfigureNEI {
	@Override
	public void loadConfig() {
		if(MicroblockSystem.instance != null) {
			try {
				if(CoreModOptions.enableNEI) {
					List<ItemStack> stacks = new ArrayList<>();
					for(int i : MicroblockSystem.neiPartIDs)
						stacks.add(ItemMicroblock.getStackWithPartID(i));
					
					if(stacks.size() > 0) {
						final Item item = stacks.get(0).getItem();
						API.setItemListEntries(item, stacks);
						API.addSubset(I18n.format("immibis_microblocks.nei.subset"), new ItemFilter() {
							@Override
							public boolean matches(ItemStack testStack) {
								return item == testStack.getItem();
							}
						});
					
						// Not possible as subset API ignores NBT (TODO: the above comment is outdated, it might now be possible)
						/*ArrayList<Integer> sortedIDs = new ArrayList<Integer>(MicroblockSystem.parts.keySet());
						Collections.sort(sortedIDs);
						
						MultiItemRange panels = new MultiItemRange();
						MultiItemRange hpanels = new MultiItemRange();
						MultiItemRange corners = new MultiItemRange();
						MultiItemRange strips = new MultiItemRange();
						
						for(int id : sortedIDs) {
							PartType<?> type = MicroblockSystem.parts.get(id);
							ItemStack stack = MicroblockSystem.instance.partTypeIDToItemStack(id, 1);
							
							switch(type.getPartClass()) {
							case Centre: break;
							case Panel: panels.add(stack); break;
							case HollowPanel: hpanels.add(stack); break;
							case Strip: strips.add(stack); break;
							case Corner: corners.add(stack); break;
							}
						}
						
						API.addSetRange("Microblocks.Panels", panels);
						API.addSetRange("Microblocks.Hollow Panels", hpanels);
						API.addSetRange("Microblocks.Corners", corners);
						API.addSetRange("Microblocks.Strips", strips);*/
					}
					
				} else {
					API.setItemListEntries(Item.getItemFromBlock(MicroblockSystem.microblockContainerBlock), Collections.<ItemStack>emptyList());
				}
			} catch(Throwable e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public String getName() {
		return "Immibis's Microblocks";
	}

	@Override
	public String getVersion() {
		return ModProperties.MOD_VERSION;
	}
}
