/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.concurrent.atomic.AtomicLong;
import journeymap.client.cartography.RGB;
import journeymap.common.Journeymap;

public class ChunkPainter {
    public static final AlphaComposite ALPHA_OPAQUE = AlphaComposite.getInstance(3, 1.0f);
    public static final int COLOR_BLACK = Color.black.getRGB();
    public static final int COLOR_VOID = RGB.toInteger(17, 12, 25);
    protected static volatile AtomicLong badBlockCount = new AtomicLong(0L);
    Integer[][] colors = new Integer[16][16];
    Graphics2D g2D;

    public ChunkPainter(Graphics2D g2D) {
        this.g2D = g2D;
        g2D.setComposite(ALPHA_OPAQUE);
    }

    public void paintDimOverlay(int x, int z, float alpha) {
        Integer color = this.colors[x][z];
        if (color != null) {
            this.paintBlock(x, z, RGB.adjustBrightness(color, alpha));
        }
    }

    public void paintBlock(int x, int z, int color) {
        this.colors[x][z] = color;
    }

    public void paintVoidBlock(int x, int z) {
        this.paintBlock(x, z, COLOR_VOID);
    }

    public void paintBlackBlock(int x, int z) {
        this.paintBlock(x, z, COLOR_BLACK);
    }

    public void paintBadBlock(int x, int y, int z) {
        long count = badBlockCount.incrementAndGet();
        if (count == 1L || count % 10240L == 0L) {
            Journeymap.getLogger().warn("Bad block at " + x + "," + y + "," + z + ". Total bad blocks: " + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishPainting() {
        int lastColor = -1;
        try {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Integer color = this.colors[x][z];
                    if (color == null) continue;
                    if (color != lastColor) {
                        lastColor = color;
                        this.g2D.setPaint(RGB.paintOf(color));
                    }
                    this.g2D.fillRect(x, z, 1, 1);
                }
            }
        }
        finally {
            this.g2D.dispose();
            this.g2D = null;
            this.colors = null;
        }
    }
}

