/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.List;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.ui.component.Button;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.world.WorldProvider;

class DimensionsButton
extends Button {
    static boolean needInit = true;
    static WorldProvider currentWorldProvider;
    final List<WorldProvider> worldProviders = WorldData.getDimensionProviders(WaypointStore.instance().getLoadedDimensions());

    public DimensionsButton() {
        super(0, 0, "");
        if (needInit || currentWorldProvider != null) {
            currentWorldProvider = ForgeHelper.INSTANCE.getClient().field_71439_g.field_70170_p.field_73011_w;
            needInit = false;
        }
        this.updateLabel();
        this.fitWidth(ForgeHelper.INSTANCE.getFontRenderer());
    }

    @Override
    protected void updateLabel() {
        String dimName = currentWorldProvider != null ? WorldData.getSafeDimensionName(currentWorldProvider) : Constants.getString("jm.waypoint.dimension_all");
        this.field_146126_j = Constants.getString("jm.waypoint.dimension", dimName);
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int maxWidth = 0;
        for (WorldProvider worldProvider : this.worldProviders) {
            String name = Constants.getString("jm.waypoint.dimension", WorldData.getSafeDimensionName(worldProvider));
            maxWidth = Math.max(maxWidth, ForgeHelper.INSTANCE.getFontRenderer().func_78256_a(name));
        }
        return maxWidth + 12;
    }

    public void nextValue() {
        int index;
        if (currentWorldProvider == null) {
            index = 0;
        } else {
            index = -1;
            int currentDimension = ForgeHelper.INSTANCE.getDimension(currentWorldProvider);
            for (WorldProvider worldProvider : this.worldProviders) {
                if (currentDimension != ForgeHelper.INSTANCE.getDimension(worldProvider)) continue;
                index = this.worldProviders.indexOf(worldProvider) + 1;
                break;
            }
        }
        currentWorldProvider = index >= this.worldProviders.size() || index < 0 ? null : this.worldProviders.get(index);
        this.updateLabel();
    }
}

