/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;

public class ImageLineHelper {
    private static final double BIG_VALUE = 8.988465674311579E307;
    private static final double BIG_VALUE_NEG = -8.988465674311579E307;

    public static int[] palette2rgb(ImageLine line, PngChunkPLTE pal, PngChunkTRNS trns, int[] buf) {
        boolean isalpha = trns != null;
        int channels = isalpha ? 4 : 3;
        int nsamples = line.imgInfo.cols * channels;
        if (buf == null || buf.length < nsamples) {
            buf = new int[nsamples];
        }
        if (!line.samplesUnpacked) {
            line = line.unpackToNewImageLine();
        }
        boolean isbyte = line.sampleType == ImageLine.SampleType.BYTE;
        int nindexesWithAlpha = trns != null ? trns.getPalletteAlpha().length : 0;
        for (int c = 0; c < line.imgInfo.cols; ++c) {
            int alpha;
            int index = isbyte ? line.scanlineb[c] & 0xFF : line.scanline[c];
            pal.getEntryRgb(index, buf, c * channels);
            if (!isalpha) continue;
            buf[c * channels + 3] = alpha = index < nindexesWithAlpha ? trns.getPalletteAlpha()[index] : 255;
        }
        return buf;
    }

    public static int[] palette2rgb(ImageLine line, PngChunkPLTE pal, int[] buf) {
        return ImageLineHelper.palette2rgb(line, pal, null, buf);
    }

    public static String infoFirstLastPixels(ImageLine line) {
        return line.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", line.scanline[0], line.scanline[line.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", line.scanline[0], line.scanline[1], line.scanline[2], line.scanline[line.scanline.length - line.imgInfo.channels], line.scanline[line.scanline.length - line.imgInfo.channels + 1], line.scanline[line.scanline.length - line.imgInfo.channels + 2]);
    }

    public static String infoFull(ImageLine line) {
        ImageLineStats stats = new ImageLineStats(line);
        return "row=" + line.getRown() + " " + stats.toString() + "\n  " + ImageLineHelper.infoFirstLastPixels(line);
    }

    public static int getPixelRGB8(ImageLine line, int column) {
        int offset = column * line.channels;
        return (line.scanline[offset] << 16) + (line.scanline[offset + 1] << 8) + line.scanline[offset + 2];
    }

    public static int getPixelARGB8(ImageLine line, int column) {
        int offset = column * line.channels;
        return (line.scanline[offset + 3] << 24) + (line.scanline[offset] << 16) + (line.scanline[offset + 1] << 8) + line.scanline[offset + 2];
    }

    public static void setPixelsRGB8(ImageLine line, int[] rgb) {
        int j = 0;
        for (int i = 0; i < line.imgInfo.cols; ++i) {
            line.scanline[j++] = rgb[i] >> 16 & 0xFF;
            line.scanline[j++] = rgb[i] >> 8 & 0xFF;
            line.scanline[j++] = rgb[i] & 0xFF;
        }
    }

    public static void setPixelRGB8(ImageLine line, int col, int r, int g, int b) {
        col *= line.channels;
        line.scanline[col++] = r;
        line.scanline[col++] = g;
        line.scanline[col] = b;
    }

    public static void setPixelRGB8(ImageLine line, int col, int rgb) {
        ImageLineHelper.setPixelRGB8(line, col, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static void setPixelsRGBA8(ImageLine line, int[] rgb) {
        int j = 0;
        for (int i = 0; i < line.imgInfo.cols; ++i) {
            line.scanline[j++] = rgb[i] >> 16 & 0xFF;
            line.scanline[j++] = rgb[i] >> 8 & 0xFF;
            line.scanline[j++] = rgb[i] & 0xFF;
            line.scanline[j++] = rgb[i] >> 24 & 0xFF;
        }
    }

    public static void setPixelRGBA8(ImageLine line, int col, int r, int g, int b, int a) {
        col *= line.channels;
        line.scanline[col++] = r;
        line.scanline[col++] = g;
        line.scanline[col++] = b;
        line.scanline[col] = a;
    }

    public static void setPixelRGBA8(ImageLine line, int col, int rgb) {
        ImageLineHelper.setPixelRGBA8(line, col, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgb >> 24 & 0xFF);
    }

    public static void setValD(ImageLine line, int i, double d) {
        line.scanline[i] = ImageLineHelper.double2int(line, d);
    }

    public static int interpol(int a, int b, int c, int d, double dx, double dy) {
        double e = (double)a * (1.0 - dx) + (double)b * dx;
        double f = (double)c * (1.0 - dx) + (double)d * dx;
        return (int)(e * (1.0 - dy) + f * dy + 0.5);
    }

    public static double int2double(ImageLine line, int p) {
        return line.bitDepth == 16 ? (double)p / 65535.0 : (double)p / 255.0;
    }

    public static double int2doubleClamped(ImageLine line, int p) {
        double d;
        double d2 = d = line.bitDepth == 16 ? (double)p / 65535.0 : (double)p / 255.0;
        return d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
    }

    public static int double2int(ImageLine line, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return line.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLine line, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return line.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int clampTo_0_255(int i) {
        return i > 255 ? 255 : (i < 0 ? 0 : i);
    }

    public static int clampTo_0_65535(int i) {
        return i > 65535 ? 65535 : (i < 0 ? 0 : i);
    }

    public static int clampTo_128_127(int x) {
        return x > 127 ? 127 : (x < -128 ? -128 : x);
    }

    public static int[] unpack(ImageInfo imgInfo, int[] src, int[] dst, boolean scale) {
        int len1 = imgInfo.samplesPerRow;
        int len0 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < len1) {
            dst = new int[len1];
        }
        if (imgInfo.packed) {
            ImageLine.unpackInplaceInt(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, len0);
        }
        return dst;
    }

    public static byte[] unpack(ImageInfo imgInfo, byte[] src, byte[] dst, boolean scale) {
        int len1 = imgInfo.samplesPerRow;
        int len0 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < len1) {
            dst = new byte[len1];
        }
        if (imgInfo.packed) {
            ImageLine.unpackInplaceByte(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, len0);
        }
        return dst;
    }

    public static int[] pack(ImageInfo imgInfo, int[] src, int[] dst, boolean scale) {
        int len0 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < len0) {
            dst = new int[len0];
        }
        if (imgInfo.packed) {
            ImageLine.packInplaceInt(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, len0);
        }
        return dst;
    }

    public static byte[] pack(ImageInfo imgInfo, byte[] src, byte[] dst, boolean scale) {
        int len0 = imgInfo.samplesPerRowPacked;
        if (dst == null || dst.length < len0) {
            dst = new byte[len0];
        }
        if (imgInfo.packed) {
            ImageLine.packInplaceByte(imgInfo, src, dst, scale);
        } else {
            System.arraycopy(src, 0, dst, 0, len0);
        }
        return dst;
    }

    static int getMaskForPackedFormats(int bitDepth) {
        if (bitDepth == 4) {
            return 240;
        }
        if (bitDepth == 2) {
            return 192;
        }
        return 128;
    }

    static int getMaskForPackedFormatsLs(int bitDepth) {
        if (bitDepth == 4) {
            return 15;
        }
        if (bitDepth == 2) {
            return 3;
        }
        return 1;
    }

    static class ImageLineStats {
        public double[] prom = new double[]{0.0, 0.0, 0.0, 0.0};
        public double[] maxv = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307};
        public double[] minv = new double[]{8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307};
        public double promlum = 0.0;
        public double maxlum = -8.988465674311579E307;
        public double minlum = 8.988465674311579E307;
        public double[] maxdif = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307};
        public final int channels;

        public String toString() {
            return this.channels == 3 ? String.format("prom=%.1f (%.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.minlum, this.minv[0], this.minv[1], this.minv[2]) + String.format(" maxdif=(%.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2]) : String.format("prom=%.1f (%.1f %.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.prom[3], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.maxv[3], this.minlum, this.minv[0], this.minv[1], this.minv[2], this.minv[3]) + String.format(" maxdif=(%.1f %.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2], this.maxdif[3]);
        }

        public ImageLineStats(ImageLine line) {
            this.channels = line.channels;
            if (line.channels < 3) {
                throw new PngjException("ImageLineStats only works for RGB - RGBA");
            }
            int ch = 0;
            for (int i = 0; i < line.imgInfo.cols; ++i) {
                double lum = 0.0;
                for (ch = this.channels - 1; ch >= 0; --ch) {
                    double d;
                    double x = ImageLineHelper.int2double(line, line.scanline[i * this.channels]);
                    if (ch < 3) {
                        lum += x;
                    }
                    int n = ch;
                    this.prom[n] = this.prom[n] + x;
                    if (x > this.maxv[ch]) {
                        this.maxv[ch] = x;
                    }
                    if (x < this.minv[ch]) {
                        this.minv[ch] = x;
                    }
                    if (i < this.channels || !((d = Math.abs(x - ImageLineHelper.int2double(line, line.scanline[i - this.channels]))) > this.maxdif[ch])) continue;
                    this.maxdif[ch] = d;
                }
                this.promlum += lum;
                if (lum > this.maxlum) {
                    this.maxlum = lum;
                }
                if (!(lum < this.minlum)) continue;
                this.minlum = lum;
            }
            ch = 0;
            while (ch < this.channels) {
                int n = ch++;
                this.prom[n] = this.prom[n] / (double)line.imgInfo.cols;
            }
            this.promlum /= (double)line.imgInfo.cols * 3.0;
            this.maxlum /= 3.0;
            this.minlum /= 3.0;
        }
    }
}

