/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import journeymap.client.Constants;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IPropertyHolder;
import net.minecraft.client.gui.FontRenderer;

public class IconSetButton
extends Button
implements IPropertyHolder<AtomicReference<String>, String> {
    final String messageKey;
    final PropertiesBase baseProperties;
    final AtomicReference<String> valueHolder;
    final ArrayList<Object> validNames;

    public IconSetButton(PropertiesBase baseProperties, AtomicReference<String> valueHolder, List validNames, String messageKey) {
        super(0, 0, Constants.getString(messageKey, ""));
        this.baseProperties = baseProperties;
        this.valueHolder = valueHolder;
        this.validNames = new ArrayList(validNames);
        this.messageKey = messageKey;
        this.updateLabel();
        this.fitWidth(this.fontRenderer);
    }

    @Override
    protected void updateLabel() {
        if (!this.validNames.contains(this.valueHolder.get())) {
            this.valueHolder.set(this.validNames.get(0).toString());
            this.baseProperties.save();
        }
        this.field_146126_j = this.getSafeLabel(this.valueHolder.get());
    }

    protected String getSafeLabel(String label) {
        int maxLength = 13;
        if (label.length() > maxLength) {
            label = label.substring(0, maxLength - 3).concat("...");
        }
        return Constants.getString(this.messageKey, label);
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int maxWidth = 0;
        for (Object iconSetName : this.validNames) {
            String name = this.getSafeLabel(iconSetName.toString());
            maxWidth = Math.max(maxWidth, this.fontRenderer.func_78256_a(name));
        }
        return maxWidth + 12;
    }

    public void nextValue() {
        int index = this.validNames.indexOf(this.valueHolder.get()) + 1;
        if (index == this.validNames.size() || index < 0) {
            index = 0;
        }
        this.valueHolder.set(this.validNames.get(index).toString());
        this.baseProperties.save();
        this.updateLabel();
    }

    @Override
    public AtomicReference<String> getProperty() {
        return this.valueHolder;
    }

    @Override
    public String getPropertyValue() {
        return this.valueHolder.get();
    }

    @Override
    public void setPropertyValue(String value) {
        if (this.valueHolder == null) {
            return;
        }
        this.valueHolder.set(value);
        this.baseProperties.save();
    }
}

