/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.org.eclipse.jetty.websocket.server;

import java.io.IOException;
import journeymap.shadow.javax.servlet.ServletContext;
import journeymap.shadow.javax.servlet.ServletException;
import journeymap.shadow.javax.servlet.http.HttpServletRequest;
import journeymap.shadow.javax.servlet.http.HttpServletResponse;
import journeymap.shadow.org.eclipse.jetty.http.pathmap.MatchedResource;
import journeymap.shadow.org.eclipse.jetty.io.ByteBufferPool;
import journeymap.shadow.org.eclipse.jetty.io.MappedByteBufferPool;
import journeymap.shadow.org.eclipse.jetty.server.Request;
import journeymap.shadow.org.eclipse.jetty.server.handler.HandlerWrapper;
import journeymap.shadow.org.eclipse.jetty.servlet.ServletContextHandler;
import journeymap.shadow.org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import journeymap.shadow.org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import journeymap.shadow.org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import journeymap.shadow.org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import journeymap.shadow.org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private NativeWebSocketConfiguration configuration;

    public WebSocketUpgradeHandlerWrapper(ServletContextHandler context) {
        this(context, new MappedByteBufferPool());
    }

    public WebSocketUpgradeHandlerWrapper(ServletContextHandler context, ByteBufferPool bufferPool) {
        this.configuration = new NativeWebSocketConfiguration(new WebSocketServerFactory((ServletContext)context.getServletContext(), bufferPool));
    }

    @Override
    public void addMapping(journeymap.shadow.org.eclipse.jetty.http.pathmap.PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    @Deprecated
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public void addMapping(String spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public boolean removeMapping(String spec) {
        return this.configuration.removeMapping(spec);
    }

    @Override
    public WebSocketCreator getMapping(String target) {
        return this.configuration.getMapping(target);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.configuration.getFactory().isUpgradeRequest(request, response)) {
            MatchedResource<WebSocketCreator> resource = this.configuration.getMatched(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = resource.getResource();
            request.setAttribute(journeymap.shadow.org.eclipse.jetty.http.pathmap.PathSpec.class.getName(), resource);
            if (this.configuration.getFactory().acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

