/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import common.Blocks;
import common.blocks.Block_TFFTStorageFieldBlockT1;
import common.blocks.Block_TFFTStorageFieldBlockT2;
import common.blocks.Block_TFFTStorageFieldBlockT3;
import common.blocks.Block_TFFTStorageFieldBlockT4;
import common.blocks.Block_TFFTStorageFieldBlockT5;
import common.tileentities.TE_TFFTMultiHatch;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.ArrayList;
import java.util.HashSet;
import kekztech.MultiFluidHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import util.MultiBlockTooltipBuilder;
import util.Vector3i;
import util.Vector3ic;

public class GTMTE_FluidMultiStorage
extends GT_MetaTileEntity_MultiBlockBase {
    private static final String glassNameIC2Reinforced = "blockAlloyGlass";
    private static final Block CASING = Blocks.tfftCasing;
    private static final Block_TFFTStorageFieldBlockT1 STORAGE_FIELD1 = (Block_TFFTStorageFieldBlockT1)Blocks.tfftStorageField1;
    private static final Block_TFFTStorageFieldBlockT2 STORAGE_FIELD2 = (Block_TFFTStorageFieldBlockT2)Blocks.tfftStorageField2;
    private static final Block_TFFTStorageFieldBlockT3 STORAGE_FIELD3 = (Block_TFFTStorageFieldBlockT3)Blocks.tfftStorageField3;
    private static final Block_TFFTStorageFieldBlockT4 STORAGE_FIELD4 = (Block_TFFTStorageFieldBlockT4)Blocks.tfftStorageField4;
    private static final Block_TFFTStorageFieldBlockT5 STORAGE_FIELD5 = (Block_TFFTStorageFieldBlockT5)Blocks.tfftStorageField5;
    private static final Block MULTI_HATCH = Blocks.tfftMultiHatch;
    private static final int CASING_TEXTURE_ID = 176;
    private MultiFluidHandler mfh;
    private HashSet<TE_TFFTMultiHatch> multiHatches = new HashSet();
    private int runningCost = 0;
    private boolean doVoidExcess = false;
    private byte fluidSelector = 0;

    public GTMTE_FluidMultiStorage(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_FluidMultiStorage(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_FluidMultiStorage(this.mName);
    }

    public String[] getDescription() {
        MultiBlockTooltipBuilder b = new MultiBlockTooltipBuilder();
        b.addInfo("High-Tech fluid tank that can hold up to 25 different fluids!").addInfo("Has 1/25th of the total capacity as capacity for each fluid.").addInfo("Right clicking the controller with a screwdriver will turn on excess voiding.").addInfo("Fluid storage amount and running cost depends on the storage field blocks used.").addSeparator().addInfo("Note on hatch locking:").addInfo("Use an Integrated Circuit in the GUI slot to limit which fluid is output.").addInfo("The index of a stored fluid can be obtained through the Tricorder.").addSeparator().beginStructureBlock(5, 9, 5).addController("Top Center").addEnergyHatch("Any top or bottom casing").addOtherStructurePart("Inner 3x7x3 solid pillar", "Storage Field Blocks").addOtherStructurePart("Outer 5x7x5 glass shell", "IC2 Reinforced Glass").addMaintenanceHatch("Any top or bottom casing").addIOHatches("Instead of any casing or glass, have to touch storage field.").signAndFinalize("Kekzdealer");
        if (!Keyboard.isKeyDown((int)42)) {
            return b.getInformation();
        }
        return b.getStructureInformation();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.casingTexturePages[1][48];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.casingTexturePages[1][48];
        }
        return iTextureArray;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack var1) {
        return true;
    }

    public boolean checkRecipe(ItemStack guiSlotItem) {
        this.mEfficiency = 10000 - (super.getIdealStatus() - super.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.runningCost;
        this.mMaxProgresstime = 10;
        if (guiSlotItem != null && guiSlotItem.func_77977_a().equals("gt.integrated_circuit")) {
            this.fluidSelector = (byte)guiSlotItem.func_77960_j();
        }
        if (this.multiHatches.size() > 0 && this.mInputHatches.size() == 0 && this.mOutputHatches.size() == 0) {
            return true;
        }
        ArrayList inputHatchFluids = super.getStoredFluids();
        if (inputHatchFluids.size() > 0) {
            for (FluidStack fluidStack : inputHatchFluids) {
                int pushed = this.mfh.pushFluid(fluidStack, true);
                FluidStack toDeplete = fluidStack.copy();
                toDeplete.amount = pushed;
                super.depleteInput(toDeplete);
            }
        }
        if (guiSlotItem != null && guiSlotItem.func_77977_a().equals("gt.integrated_circuit")) {
            FluidStack storedFluid = this.mfh.getFluid(this.fluidSelector);
            int possibleOutput = 0;
            for (GT_MetaTileEntity_Hatch_Output outputHatch : this.mOutputHatches) {
                if (outputHatch.isFluidLocked() && outputHatch.getLockedFluidName().equals(storedFluid.getUnlocalizedName())) {
                    possibleOutput += outputHatch.getCapacity() - outputHatch.getFluidAmount();
                    continue;
                }
                if (outputHatch.getFluid() != null && outputHatch.getFluid().getUnlocalizedName().equals(storedFluid.getUnlocalizedName())) {
                    possibleOutput += outputHatch.getCapacity() - outputHatch.getFluidAmount();
                    continue;
                }
                if (outputHatch.getFluid() != null) continue;
                possibleOutput += outputHatch.getCapacity() - outputHatch.getFluidAmount();
            }
            FluidStack tempStack = storedFluid.copy();
            tempStack.amount = possibleOutput;
            tempStack.amount = this.mfh.pullFluid(tempStack, this.fluidSelector, true);
            super.addOutput(tempStack);
        } else {
            for (FluidStack storedFluid : this.mfh.getFluids()) {
                int possibleOutput = 0;
                for (GT_MetaTileEntity_Hatch_Output outputHatch : this.mOutputHatches) {
                    if (outputHatch.isFluidLocked() && outputHatch.getLockedFluidName().equals(storedFluid.getUnlocalizedName())) {
                        possibleOutput += outputHatch.getCapacity() - outputHatch.getFluidAmount();
                        continue;
                    }
                    if (outputHatch.getFluid() != null && outputHatch.getFluid().getUnlocalizedName().equals(storedFluid.getUnlocalizedName())) {
                        possibleOutput += outputHatch.getCapacity() - outputHatch.getFluidAmount();
                        continue;
                    }
                    if (outputHatch.getFluid() != null) continue;
                    possibleOutput += outputHatch.getCapacity() - outputHatch.getFluidAmount();
                }
                FluidStack tempStack = storedFluid.copy();
                tempStack.amount = possibleOutput;
                tempStack.amount = this.mfh.pullFluid(tempStack, true);
                super.addOutput(tempStack);
            }
        }
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mfh != null) {
            this.mfh.setLock(!super.getBaseMetaTileEntity().isActive());
            this.mfh.setFluidSelector(this.fluidSelector);
            this.mfh.setDoVoidExcess(this.doVoidExcess);
        }
    }

    public Vector3ic rotateOffsetVector(Vector3ic forgeDirection, int x, int y, int z) {
        Vector3i offset = new Vector3i();
        if (forgeDirection.x() == 0 && forgeDirection.z() == -1) {
            offset.x = x;
            offset.y = y;
            offset.z = z;
        }
        if (forgeDirection.x() == 0 && forgeDirection.z() == 1) {
            offset.x = -x;
            offset.y = y;
            offset.z = -z;
        }
        if (forgeDirection.x() == -1 && forgeDirection.z() == 0) {
            offset.x = z;
            offset.y = y;
            offset.z = -x;
        }
        if (forgeDirection.x() == 1 && forgeDirection.z() == 0) {
            offset.x = -z;
            offset.y = y;
            offset.z = x;
        }
        if (forgeDirection.y() == -1) {
            offset.x = x;
            offset.y = z;
            offset.z = y;
        }
        return offset;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        TE_TFFTMultiHatch mh;
        IGregTechTileEntity currentTE;
        int Y;
        int X;
        Vector3i forgeDirection = new Vector3i(ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetX, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetY, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetZ);
        int minCasingAmount = 20;
        boolean formationChecklist = true;
        float runningCostAcc = 0.0f;
        double fluidCapacityAcc = 0.0;
        this.multiHatches.clear();
        for (X = -2; X <= 2; ++X) {
            for (Y = -2; Y <= 2; ++Y) {
                if (X == 0 && Y == 0) continue;
                Vector3ic offset = this.rotateOffsetVector(forgeDirection, X, Y, 0);
                currentTE = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                if (X > -2 && X < 2 && Y > -2 && Y < 2) {
                    if (super.addMaintenanceToMachineList(currentTE, 176) || super.addInputToMachineList(currentTE, 176) || super.addOutputToMachineList(currentTE, 176) || super.addEnergyInputToMachineList(currentTE, 176)) continue;
                    Block b = thisController.getBlockOffset(offset.x(), offset.y(), offset.z());
                    if (b == CASING) {
                        --minCasingAmount;
                        continue;
                    }
                    if (b == MULTI_HATCH) {
                        mh = (TE_TFFTMultiHatch)thisController.getWorld().func_147438_o(thisController.getXCoord() + offset.x(), thisController.getYCoord() + offset.y(), thisController.getZCoord() + offset.z());
                        this.multiHatches.add(mh);
                        continue;
                    }
                    formationChecklist = false;
                    continue;
                }
                if (super.addMaintenanceToMachineList(currentTE, 176) || super.addEnergyInputToMachineList(currentTE, 176)) continue;
                if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == CASING) {
                    --minCasingAmount;
                    continue;
                }
                formationChecklist = false;
            }
        }
        for (X = -2; X <= 2; ++X) {
            for (Y = -2; Y <= 2; ++Y) {
                for (int Z = -1; Z >= -7; --Z) {
                    Vector3ic offset = this.rotateOffsetVector(forgeDirection, X, Y, Z);
                    if (X > -2 && X < 2 && Y > -2 && Y < 2) {
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(STORAGE_FIELD1.func_149739_a())) {
                            runningCostAcc += 0.5f;
                            fluidCapacityAcc += (double)Block_TFFTStorageFieldBlockT1.getCapacity();
                            continue;
                        }
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(STORAGE_FIELD2.func_149739_a())) {
                            runningCostAcc += 1.0f;
                            fluidCapacityAcc += (double)Block_TFFTStorageFieldBlockT2.getCapacity();
                            continue;
                        }
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(STORAGE_FIELD3.func_149739_a())) {
                            runningCostAcc += 2.0f;
                            fluidCapacityAcc += (double)Block_TFFTStorageFieldBlockT3.getCapacity();
                            continue;
                        }
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(STORAGE_FIELD4.func_149739_a())) {
                            runningCostAcc += 4.0f;
                            fluidCapacityAcc += (double)Block_TFFTStorageFieldBlockT4.getCapacity();
                            continue;
                        }
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(STORAGE_FIELD5.func_149739_a())) {
                            runningCostAcc += 8.0f;
                            fluidCapacityAcc += (double)Block_TFFTStorageFieldBlockT5.getCapacity();
                            continue;
                        }
                        formationChecklist = false;
                        continue;
                    }
                    IGregTechTileEntity currentTE2 = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                    if (X == -2 && Y == -2 || X == 2 && Y == 2 || X == -2 && Y == 2 || X == 2 && Y == -2) {
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(glassNameIC2Reinforced)) continue;
                        formationChecklist = false;
                        continue;
                    }
                    if (super.addInputToMachineList(currentTE2, 176) || super.addOutputToMachineList(currentTE2, 176)) continue;
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == CASING) {
                        --minCasingAmount;
                        continue;
                    }
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == MULTI_HATCH) {
                        mh = (TE_TFFTMultiHatch)thisController.getWorld().func_147438_o(thisController.getXCoord() + offset.x(), thisController.getYCoord() + offset.y(), thisController.getZCoord() + offset.z());
                        this.multiHatches.add(mh);
                        continue;
                    }
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(glassNameIC2Reinforced)) continue;
                    formationChecklist = false;
                }
            }
        }
        for (X = -2; X <= 2; ++X) {
            for (Y = -2; Y <= 2; ++Y) {
                Vector3ic offset = this.rotateOffsetVector(forgeDirection, X, Y, -8);
                currentTE = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                if (X > -2 && X < 2 && Y > -2 && Y < 2) {
                    if (super.addMaintenanceToMachineList(currentTE, 176) || super.addInputToMachineList(currentTE, 176) || super.addOutputToMachineList(currentTE, 176) || super.addEnergyInputToMachineList(currentTE, 176)) continue;
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == CASING) {
                        --minCasingAmount;
                        continue;
                    }
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == MULTI_HATCH) {
                        TE_TFFTMultiHatch mh2 = (TE_TFFTMultiHatch)thisController.getWorld().func_147438_o(thisController.getXCoord() + offset.x(), thisController.getYCoord() + offset.y(), thisController.getZCoord() + offset.z());
                        this.multiHatches.add(mh2);
                        continue;
                    }
                    formationChecklist = false;
                    continue;
                }
                if (super.addMaintenanceToMachineList(currentTE, 176) || super.addEnergyInputToMachineList(currentTE, 176)) continue;
                if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == CASING) {
                    --minCasingAmount;
                    continue;
                }
                formationChecklist = false;
            }
        }
        if (this.mEnergyHatches.size() < 1) {
            formationChecklist = false;
        }
        if (this.mMaintenanceHatches.size() < 1) {
            formationChecklist = false;
        }
        if (minCasingAmount > 0) {
            formationChecklist = false;
        }
        if (formationChecklist) {
            this.runningCost = Math.round(-runningCostAcc);
            int capacityPerFluid = (int)Math.round(fluidCapacityAcc / 25.0);
            if (this.mfh == null) {
                this.mfh = new MultiFluidHandler(capacityPerFluid);
            } else if (this.mfh.getCapacity() != capacityPerFluid) {
                this.mfh = new MultiFluidHandler(capacityPerFluid, this.mfh.getFluids());
            }
            for (TE_TFFTMultiHatch mh3 : this.multiHatches) {
                mh3.setMultiFluidHandler(this.mfh);
            }
        }
        return formationChecklist;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.doVoidExcess) {
            this.doVoidExcess = false;
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText("Auto-voiding turned off"));
        } else {
            this.doVoidExcess = true;
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText("Auto-voiding turned on"));
        }
    }

    public String[] getInfoData() {
        ArrayList<String> ll = this.mfh.getInfoData();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("Auto-voiding: " + this.doVoidExcess);
        ll.add("Per-Fluid Capacity: " + this.mfh.getCapacity() + "L");
        ll.add("Running Cost: " + -this.mEUt * 10000 / Math.max(1000, this.mEfficiency) + "EU/t");
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("---------------------------------------------");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74768_a("runningCost", this.runningCost);
        nbt.func_74757_a("doVoidExcess", this.doVoidExcess);
        nbt.func_74768_a("capacityPerFluid", this.mfh.getCapacity());
        nbt.func_74782_a("fluids", (NBTBase)this.mfh.saveNBTData(new NBTTagCompound()));
        super.saveNBTData(nbt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.runningCost = nbt.func_74762_e("runningCost");
        this.doVoidExcess = nbt.func_74767_n("doVoidExcess");
        this.mfh = new MultiFluidHandler();
        this.mfh.loadNBTData(nbt);
        for (TE_TFFTMultiHatch mh : this.multiHatches) {
            mh.setMultiFluidHandler(this.mfh);
        }
        super.loadNBTData(nbt);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack var1) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack var1) {
        return 0;
    }

    public int getDamageToComponent(ItemStack var1) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack var1) {
        return false;
    }
}

