/*
 * Decompiled with CFR 0.152.
 */
package kekztech;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MultiItemHandler {
    private int perTypeCapacity = 0;
    private boolean locked = true;
    private ItemStack[] items;

    public List<String> debugPrint() {
        if (this.items == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> slots = new ArrayList<String>();
        for (int i = 0; i < this.items.length; ++i) {
            slots.add("Slot " + i + " contains " + this.items[i].field_77994_a + " " + this.items[i].func_82833_r());
        }
        return slots;
    }

    public void setItemTypeCapacity(int itemTypeCapacity) {
        System.out.println("Configuring type capacity");
        if (this.items.length > itemTypeCapacity) {
            ItemStack[] newItems = new ItemStack[itemTypeCapacity];
            for (int i = 0; i < newItems.length; ++i) {
                newItems[i] = this.items[i];
            }
            ItemStack[] toDrop = new ItemStack[this.items.length - itemTypeCapacity];
            for (int i = 0; i < toDrop.length; ++i) {
                toDrop[i] = this.items[i + newItems.length - 1];
            }
            this.items = newItems;
        } else {
            ItemStack[] newItems = new ItemStack[itemTypeCapacity];
            for (int i = 0; i < this.items.length; ++i) {
                newItems[i] = this.items[i];
            }
            this.items = newItems;
        }
    }

    public void setPerTypeCapacity(int perTypeCapacity) {
        this.perTypeCapacity = perTypeCapacity;
    }

    public void setLock(boolean state) {
        this.locked = state;
    }

    public int getItemTypeCapacity() {
        return this.items != null ? this.items.length : 0;
    }

    public int getPerTypeCapacity() {
        return this.perTypeCapacity;
    }

    public ItemStack getStackInSlot(int slot) {
        System.out.println("Stack in slot " + slot + " requested");
        if (this.locked || slot >= this.items.length) {
            return null;
        }
        return this.items[slot];
    }

    public boolean insertStackInSlot(int slot, ItemStack itemStack) {
        System.out.println("Inserting " + itemStack.func_82833_r() + " into " + slot);
        if (itemStack == null || this.items[slot] != null || this.locked || slot >= this.items.length) {
            return false;
        }
        this.items[slot] = itemStack;
        return true;
    }

    public int increaseStackInSlot(int slot, int amount) {
        System.out.println("Increasing item in slot " + slot + " by " + amount);
        if (slot >= this.items.length || this.locked || amount <= 0) {
            return 0;
        }
        int space = this.perTypeCapacity - this.items[slot].field_77994_a;
        int fit = Math.min(space, amount);
        this.items[slot].field_77994_a += fit;
        return fit;
    }

    public int reduceStackInSlot(int slot, int amount) {
        System.out.println("Reducing item in slot " + slot + " by " + amount);
        if (slot >= this.items.length || this.locked || amount <= 0) {
            return 0;
        }
        int available = this.items[slot].field_77994_a;
        int take = Math.min(available, amount);
        this.items[slot].field_77994_a -= take;
        if (take == available) {
            this.items[slot] = null;
        }
        return take;
    }
}

