/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import common.Blocks;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import util.Vector3i;
import util.Vector3ic;

public class GTMTE_SOFuelCellMK1
extends GT_MetaTileEntity_MultiBlockBase {
    private final Block CASING = GregTech_API.sBlockCasings4;
    private final int CASING_META = 1;
    private final int CASING_TEXTURE_ID = 49;
    private final int OXYGEN_PER_SEC = 400;
    private final int EU_PER_TICK = 1024;
    private final int STEAM_PER_SEC = 18000;

    public GTMTE_SOFuelCellMK1(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_SOFuelCellMK1(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_SOFuelCellMK1(this.mName);
    }

    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Gas Turbine").addInfo("Oxidizes gas fuels to generate electricity without polluting the environment").addInfo("Consumes 29,480EU worth of fuel with up to 97% efficiency each second").addInfo("Steam production requires the SOFC to heat up completely first").addInfo("Outputs 1024EU/t and 18000L/s Steam").addInfo("Additionally, requires 400L/s Oxygen gas").addSeparator().beginStructureBlock(3, 3, 5, false).addController("Front center").addCasingInfo("Clean Stainless Steel Casing", 12).addOtherStructurePart("YSZ Ceramic Electrolyte Unit", "3x, Center 1x1x3").addOtherStructurePart("Reinforced Glass", "6x, touching the electrolyte units on the horizontal sides").addDynamoHatch("Back center").addMaintenanceHatch("Any casing").addInputHatch("Fuel, any casing").addInputHatch("Oxygen, any casing").addOutputHatch("Steam, any casing").toolTipFinisher("KekzTech");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.CASING_BLOCKS[49];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.CASING_BLOCKS[49];
        }
        return iTextureArray;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        ArrayList storedFluids = super.getStoredFluids();
        Collection recipeList = GT_Recipe.GT_Recipe_Map.sTurbineFuels.mRecipeList;
        if (storedFluids.size() > 0 && recipeList != null) {
            for (FluidStack hatchFluid : storedFluids) {
                for (GT_Recipe aFuel : recipeList) {
                    FluidStack liquid = GT_Utility.getFluidForFilledItem((ItemStack)aFuel.getRepresentativeInput(0), (boolean)true);
                    if (liquid == null || !hatchFluid.isFluidEqual(liquid)) continue;
                    liquid.amount = Math.round(20480 / aFuel.mSpecialValue);
                    if (!super.depleteInput(liquid)) continue;
                    if (!super.depleteInput(Materials.Oxygen.getGas(400L))) {
                        this.mEUt = 0;
                        this.mEfficiency = 0;
                        return false;
                    }
                    this.mEUt = 1024;
                    this.mMaxProgresstime = 20;
                    this.mEfficiencyIncrease = 40;
                    if (this.mEfficiency == this.getMaxEfficiency(null)) {
                        super.addOutput(GT_ModHandler.getSteam((long)18000L));
                    }
                    return true;
                }
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return false;
    }

    public Vector3ic rotateOffsetVector(Vector3ic forgeDirection, int x, int y, int z) {
        Vector3i offset = new Vector3i();
        if (forgeDirection.x() == 0 && forgeDirection.z() == -1) {
            offset.x = x;
            offset.y = y;
            offset.z = z;
        }
        if (forgeDirection.x() == 0 && forgeDirection.z() == 1) {
            offset.x = -x;
            offset.y = y;
            offset.z = -z;
        }
        if (forgeDirection.x() == -1 && forgeDirection.z() == 0) {
            offset.x = z;
            offset.y = y;
            offset.z = -x;
        }
        if (forgeDirection.x() == 1 && forgeDirection.z() == 0) {
            offset.x = -z;
            offset.y = y;
            offset.z = x;
        }
        if (forgeDirection.y() == -1) {
            offset.x = x;
            offset.y = z;
            offset.z = y;
        }
        return offset;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        IGregTechTileEntity currentTE;
        int Y;
        int X;
        Vector3i forgeDirection = new Vector3i(ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetX, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetY, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetZ);
        int minCasingAmount = 12;
        boolean formationChecklist = true;
        for (X = -1; X <= 1; ++X) {
            for (Y = -1; Y <= 1; ++Y) {
                Vector3ic offset;
                if (X == 0 && Y == 0 || super.addMaintenanceToMachineList(currentTE = thisController.getIGregTechTileEntityOffset((offset = this.rotateOffsetVector(forgeDirection, X, Y, 0)).x(), offset.y(), offset.z()), 49) || super.addInputToMachineList(currentTE, 49) || super.addOutputToMachineList(currentTE, 49)) continue;
                if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.CASING && thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z()) == 1) {
                    --minCasingAmount;
                    continue;
                }
                formationChecklist = false;
            }
        }
        for (X = -1; X <= 1; ++X) {
            for (Y = -1; Y <= 1; ++Y) {
                for (int Z = -1; Z >= -3; --Z) {
                    Vector3ic offset = this.rotateOffsetVector(forgeDirection, X, Y, Z);
                    if (X == 0 && Y == 0) {
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(Blocks.yszUnit.func_149739_a())) continue;
                        formationChecklist = false;
                        continue;
                    }
                    if (Y == 0 && (X == -1 || X == 1)) {
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals("blockAlloyGlass")) continue;
                        formationChecklist = false;
                        continue;
                    }
                    IGregTechTileEntity currentTE2 = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                    if (super.addMaintenanceToMachineList(currentTE2, 49) || super.addInputToMachineList(currentTE2, 49) || super.addOutputToMachineList(currentTE2, 49)) continue;
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.CASING && thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z()) == 1) {
                        --minCasingAmount;
                        continue;
                    }
                    formationChecklist = false;
                }
            }
        }
        for (X = -1; X <= 1; ++X) {
            for (Y = -1; Y <= 1; ++Y) {
                Vector3ic offset = this.rotateOffsetVector(forgeDirection, X, Y, -4);
                currentTE = thisController.getIGregTechTileEntityOffset(offset.x(), offset.y(), offset.z());
                if (super.addMaintenanceToMachineList(currentTE, 49) || super.addInputToMachineList(currentTE, 49) || super.addOutputToMachineList(currentTE, 49) || super.addDynamoToMachineList(currentTE, 49)) continue;
                if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == this.CASING && thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z()) == 1) {
                    --minCasingAmount;
                    continue;
                }
                formationChecklist = false;
            }
        }
        if (minCasingAmount > 0) {
            formationChecklist = false;
        }
        if (this.mDynamoHatches.size() != 1) {
            System.out.println("Exactly one dynamo hatch is required!");
            formationChecklist = false;
        }
        if (this.mInputHatches.size() < 2) {
            System.out.println("At least two input hatches are required!");
            formationChecklist = false;
        }
        if (this.mMaintenanceHatches.size() < 1) {
            System.out.println("You need a maintenance hatch to do maintenance.");
        }
        return formationChecklist;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }
}

