/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import common.Blocks;
import common.tileentities.TE_SpaceElevatorCapacitor;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import util.Vector3i;
import util.Vector3ic;

public class GTMTE_SpaceElevator
extends GT_MetaTileEntity_MultiBlockBase {
    private static final Block BASE_BLOCK = Blocks.spaceElevatorStructure;
    private static final Block CAP_BLOCK = Blocks.spaceElevatorCapacitor;
    private static final Block TETHER_BLOCK = Blocks.spaceElevatorTether;
    private static final int BASE_META = 0;
    private static final int COIL_HOLDER_META = 1;
    private static final String glassNameBorosilicate = "BW_GlasBlocks";
    private static final int HATCH_OVERLAY_ID = 16;
    private static final int[] bankOffsetsX = new int[]{-7, 5, 5, -7};
    private static final int[] bankOffsetsY = new int[]{-7, -7, 5, 5};
    private static final int[] scanOffsetsX = new int[]{1, 2, 1, 0, 1};
    private static final int[] scanOffsetsY = new int[]{0, 1, 2, 1, 1};
    private final HashSet<TE_SpaceElevatorCapacitor> capacitors = new HashSet();
    private long lastLaunchEUCost = 0L;

    public GTMTE_SpaceElevator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_SpaceElevator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_SpaceElevator(this.mName);
    }

    public String[] getDescription() {
        return new String[]{"Disabled"};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        if (aSide == aFacing && aActive) {
            sTexture = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        }
        return sTexture;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        this.mProgresstime = 1;
        this.mMaxProgresstime = 1;
        this.mEUt = 0;
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    public Vector3ic rotateOffsetVector(Vector3ic forgeDirection, int x, int y, int z) {
        Vector3i offset = new Vector3i(0, 0, 0);
        if (forgeDirection.y() == -1) {
            offset.x = x;
            offset.y = z;
            offset.z = y;
        }
        return offset;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        if (thisController.getFrontFacing() > 1) {
            return false;
        }
        Vector3i forgeDirection = new Vector3i(ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetX, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetY, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetZ);
        boolean formationChecklist = true;
        int minCasingAmount = 320;
        int firstCoilMeta = -1;
        this.capacitors.clear();
        for (int X = -7; X <= 7; ++X) {
            for (int Y = -7; Y <= 7; ++Y) {
                Vector3ic offset;
                IGregTechTileEntity currentTE;
                if (X == 0 && Y == 0 || super.addMaintenanceToMachineList(currentTE = thisController.getIGregTechTileEntityOffset((offset = this.rotateOffsetVector(forgeDirection, X, Y, 0)).x(), offset.y(), offset.z()), 16) || this.addEnergyInputToMachineList(currentTE, 16)) continue;
                if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == BASE_BLOCK && thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z()) == 0) {
                    --minCasingAmount;
                    continue;
                }
                formationChecklist = false;
            }
        }
        System.out.println("");
        for (int bank = 0; bank < 4; ++bank) {
            for (int Z = 1; Z <= 5; ++Z) {
                for (int scan = 0; scan < 5; ++scan) {
                    Vector3ic offset = this.rotateOffsetVector(forgeDirection, bankOffsetsX[bank] + scanOffsetsX[scan], bankOffsetsY[bank] + scanOffsetsY[scan], Z);
                    if (Z == 1 || Z == 5) {
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == BASE_BLOCK && thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z()) == 0) {
                            --minCasingAmount;
                            continue;
                        }
                        formationChecklist = false;
                        continue;
                    }
                    if (scan == 4) {
                        TileEntity te = thisController.getTileEntityOffset(offset.x(), offset.y(), offset.z());
                        if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == CAP_BLOCK && te instanceof TE_SpaceElevatorCapacitor) {
                            this.capacitors.add((TE_SpaceElevatorCapacitor)te);
                            continue;
                        }
                        formationChecklist = false;
                        continue;
                    }
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(glassNameBorosilicate)) continue;
                    formationChecklist = false;
                }
            }
        }
        if (minCasingAmount > 0) {
            formationChecklist = false;
        }
        for (TE_SpaceElevatorCapacitor cap : this.capacitors) {
            cap.setIsDamaged(false);
        }
        return formationChecklist;
    }

    public String[] getInfoData() {
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("---------------------------------------------");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }
}

