/*
 * Decompiled with CFR 0.152.
 */
package kekztech;

import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class MultiFluidHandler {
    private final FluidStack[] fluids;
    private final int maxDistinctFluids;
    private final int capacityPerFluid;
    private boolean locked = true;
    private boolean doVoidExcess = false;
    private byte fluidSelector = (byte)-1;

    public MultiFluidHandler(int maxDistinctFluids, int capacityPerFluid, FluidStack[] fluidsToAdd) {
        this.maxDistinctFluids = maxDistinctFluids;
        this.fluids = new FluidStack[maxDistinctFluids];
        if (fluidsToAdd != null) {
            int tFluidLengt = maxDistinctFluids < fluidsToAdd.length ? maxDistinctFluids : fluidsToAdd.length;
            for (int i = 0; i < tFluidLengt; ++i) {
                this.fluids[i] = fluidsToAdd[i];
            }
        }
        this.capacityPerFluid = capacityPerFluid;
    }

    public static MultiFluidHandler newInstance(int maxDistinctFluids, int capacityPerFluid, FluidStack ... fluidsToAdd) {
        return new MultiFluidHandler(maxDistinctFluids, capacityPerFluid, fluidsToAdd);
    }

    public static MultiFluidHandler newAdjustedInstance(MultiFluidHandler toCopy, int capacityPerFluid) {
        return new MultiFluidHandler(toCopy.maxDistinctFluids, capacityPerFluid, toCopy.fluids);
    }

    public void setLock(boolean state) {
        this.locked = state;
    }

    public void setDoVoidExcess(boolean doVoidExcess) {
        this.doVoidExcess = doVoidExcess;
    }

    public void setFluidSelector(byte fluidSelector) {
        this.fluidSelector = (byte)(fluidSelector < this.fluids.length ? fluidSelector : -1);
    }

    public byte getSelectedFluid() {
        return this.fluidSelector;
    }

    public FluidStack[] getAllFluids() {
        return this.fluids;
    }

    public int getFluidPosistion(FluidStack aFluid) {
        for (int i = 0; i < this.fluids.length; ++i) {
            FluidStack tFluid = this.fluids[i];
            if (tFluid == null || !tFluid.isFluidEqual(aFluid)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(FluidStack aFluid) {
        if (this.locked) {
            return false;
        }
        return this.getFluidPosistion(aFluid) >= 0;
    }

    public int countFluids() {
        int tCount = 0;
        for (int i = 0; i < this.fluids.length; ++i) {
            if (this.fluids[i] == null) continue;
            ++tCount;
        }
        return tCount;
    }

    public int getCapacity() {
        return this.capacityPerFluid;
    }

    public int getMaxDistinctFluids() {
        return this.maxDistinctFluids;
    }

    public FluidStack getFluidCopy(int slot) {
        FluidStack tFluid;
        if (slot >= this.fluids.length) {
            return null;
        }
        if (!this.locked && this.fluids.length > 0 && slot >= 0 && slot < this.maxDistinctFluids && (tFluid = this.fluids[slot]) != null) {
            return tFluid.copy();
        }
        return null;
    }

    public int getDistinctFluids() {
        int distinctFluids = 0;
        for (FluidStack f : this.fluids) {
            if (f == null) continue;
            ++distinctFluids;
        }
        return distinctFluids;
    }

    public NBTTagCompound saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74768_a("capacityPerFluid", this.getCapacity());
        nbt.func_74768_a("maxDistinctFluids", this.maxDistinctFluids);
        int c = 0;
        for (FluidStack f : this.fluids) {
            if (f == null) {
                ++c;
                continue;
            }
            nbt.func_74782_a(String.valueOf(c), (NBTBase)f.writeToNBT(new NBTTagCompound()));
            ++c;
        }
        return nbt;
    }

    public static MultiFluidHandler loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        int capacityPerFluid = nbt.func_74762_e("capacityPerFluid");
        NBTTagCompound fluidsTag = (NBTTagCompound)nbt.func_74781_a("fluids");
        int distinctFluids = nbt.func_74762_e("maxDistinctFluids");
        if (!nbt.func_74764_b("maxDistinctFluids")) {
            distinctFluids = 25;
        }
        FluidStack[] loadedFluids = new FluidStack[distinctFluids];
        if (fluidsTag != null) {
            for (int i = 0; i < distinctFluids; ++i) {
                NBTTagCompound fluidNBT = (NBTTagCompound)fluidsTag.func_74781_a("" + i);
                loadedFluids[i] = fluidNBT == null ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNBT);
            }
        }
        return new MultiFluidHandler(distinctFluids, capacityPerFluid, loadedFluids);
    }

    public ArrayList<String> getInfoData() {
        ArrayList<String> lines = new ArrayList<String>(this.fluids.length);
        lines.add(EnumChatFormatting.YELLOW + "Stored Fluids:" + EnumChatFormatting.RESET);
        for (int i = 0; i < this.fluids.length; ++i) {
            FluidStack tFluid = this.fluids[i];
            if (tFluid == null) {
                lines.add(i + " - null: 0L (0%)");
                continue;
            }
            lines.add(i + " - " + tFluid.getLocalizedName() + ": " + tFluid.amount + "L (" + Math.round(100.0f * (float)tFluid.amount / (float)this.getCapacity()) + "%)");
        }
        return lines;
    }

    public int pushFluid(FluidStack push, boolean doPush) {
        if (this.locked) {
            return 0;
        }
        int empty = this.getNullSlot();
        int fluidCount = this.countFluids();
        if (fluidCount >= this.maxDistinctFluids && !this.contains(push)) {
            return 0;
        }
        if (empty < this.maxDistinctFluids && !this.contains(push)) {
            int fit = Math.min(this.getCapacity(), push.amount);
            if (doPush) {
                if (empty == -1) {
                    return 0;
                }
                this.fluids[empty] = new FluidStack(push.getFluid(), fit);
            }
            return this.doVoidExcess ? push.amount : fit;
        }
        int index = this.getFluidPosistion(push);
        if (index < 0) {
            return 0;
        }
        FluidStack existing = this.fluids[index];
        int fit = Math.min(this.getCapacity() - existing.amount, push.amount);
        if (doPush) {
            existing.amount += fit;
        }
        return this.doVoidExcess ? push.amount : fit;
    }

    public int getNullSlot() {
        for (int i = 0; i < this.fluids.length; ++i) {
            if (this.fluids[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int pushFluid(FluidStack push, int slot, boolean doPush) {
        if (this.locked) {
            return 0;
        }
        FluidStack tFluid = this.fluids[slot];
        if (slot < 0 || slot >= this.maxDistinctFluids) {
            return 0;
        }
        if (tFluid != null && !tFluid.equals((Object)push)) {
            return 0;
        }
        int fit = 0;
        if (tFluid == null) {
            fit = Math.min(this.getCapacity(), push.amount);
            this.fluids[slot] = new FluidStack(push.getFluid(), fit);
        } else {
            fit = Math.min(this.getCapacity() - tFluid.amount, push.amount);
            if (doPush) {
                tFluid.amount += fit;
            }
        }
        return this.doVoidExcess ? push.amount : fit;
    }

    public int pullFluid(FluidStack pull, boolean doPull) {
        if (this.locked) {
            return 0;
        }
        int tIndex = this.getFluidPosistion(pull);
        if (tIndex < 0) {
            return 0;
        }
        FluidStack src = this.fluids[tIndex];
        int rec = Math.min(pull.amount, src.amount);
        if (doPull) {
            src.amount -= rec;
        }
        if (src.amount == 0) {
            this.fluids[tIndex] = null;
        }
        return rec;
    }

    public int pullFluid(FluidStack pull, int slot, boolean doPull) {
        if (this.locked || slot >= this.fluids.length) {
            return 0;
        }
        if (slot < 0 || slot >= this.maxDistinctFluids) {
            return 0;
        }
        FluidStack tFluid = this.fluids[slot];
        if (tFluid == null && tFluid.equals((Object)pull)) {
            return 0;
        }
        int rec = Math.min(pull.amount, tFluid.amount);
        if (doPull) {
            tFluid.amount -= rec;
        }
        if (tFluid.amount == 0) {
            this.fluids[slot] = null;
        }
        return rec;
    }

    public boolean couldPush(FluidStack push) {
        if (this.locked) {
            return false;
        }
        int tFluidIndex = this.getFluidPosistion(push);
        int fluidCount = this.countFluids();
        if (fluidCount >= this.maxDistinctFluids && !this.contains(push)) {
            return false;
        }
        if (fluidCount < this.maxDistinctFluids && !this.contains(push)) {
            return Math.min(this.getCapacity(), push.amount) > 0;
        }
        int remcap = this.getCapacity() - this.fluids[tFluidIndex].amount;
        return this.doVoidExcess || Math.min(remcap, push.amount) > 0;
    }
}

