/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import java.util.HashMap;
import kekztech.MultiFluidHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GTMTE_TFFTMultiHatch
extends GT_MetaTileEntity_Hatch {
    private static final HashMap<Integer, Integer> vals = new HashMap();
    private static final int INV_SLOT_COUNT = 2;
    private MultiFluidHandler mfh;
    private boolean outputting = false;

    public GTMTE_TFFTMultiHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 2, new String[]{"All-in-one access for the T.F.F.T", "Right-click with a screwdriver to toggle auto-output", "Throughput: " + vals.get(aTier) + "L/s per fluid"}, new ITexture[0]);
    }

    public GTMTE_TFFTMultiHatch(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 2, aDescription, aTextures);
    }

    public GTMTE_TFFTMultiHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 2, aDescription, aTextures);
    }

    public void setMultiFluidHandler(MultiFluidHandler mfh) {
        this.mfh = mfh;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("outputting", this.outputting);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.outputting = aNBT.func_74767_n("outputting");
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_PIPE_STEEL)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_PIPE_POLYTETRAFLUOROETHYLENE)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GTMTE_TFFTMultiHatch(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean isMachineBlockUpdateRecursive() {
        return false;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.outputting = !this.outputting;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.outputting ? "Auto-output enabled" : "Auto-output disabled"));
    }

    public int getCapacity() {
        return this.mfh != null ? this.mfh.getCapacity() : 0;
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mfh != null && this.outputting && aTick % 20L == 0L) {
            this.doAutoOutputPerSecond(aBaseMetaTileEntity);
        }
    }

    private void doAutoOutputPerSecond(IGregTechTileEntity aBaseMetaTileEntity) {
        ForgeDirection outSide = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing());
        TileEntity adjacentTE = aBaseMetaTileEntity.getTileEntityOffset(outSide.offsetX, outSide.offsetY, outSide.offsetZ);
        if (adjacentTE instanceof IFluidHandler) {
            IFluidHandler adjFH = (IFluidHandler)adjacentTE;
            for (int i = 0; i < this.mfh.getDistinctFluids(); ++i) {
                FluidStack fluidCopy = this.mfh.getFluidCopy(i);
                if (!adjFH.canFill(outSide.getOpposite(), fluidCopy.getFluid())) continue;
                fluidCopy.amount = Math.min(fluidCopy.amount, vals.get(this.mTier));
                fluidCopy.amount = this.mfh.pullFluid(fluidCopy, false);
                fluidCopy.amount = adjFH.fill(outSide.getOpposite(), fluidCopy, true);
                this.mfh.pullFluid(fluidCopy, true);
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.mfh != null ? this.mfh.pushFluid(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.mfh != null ? new FluidStack(resource.getFluid(), this.mfh.pullFluid(resource, doDrain)) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drain;
        if (this.mfh != null && (drain = this.mfh.getFluidCopy(0)) != null) {
            byte selectedSlot = this.mfh.getSelectedFluid() == -1 ? (byte)0 : this.mfh.getSelectedFluid();
            return new FluidStack(drain.getFluid(), this.mfh.pullFluid(new FluidStack(drain.getFluid(), maxDrain), selectedSlot, doDrain));
        }
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.mfh == null) {
            return null;
        }
        FluidStack[] fluids = this.mfh.getAllFluids();
        int length = fluids.length;
        int maxCapcity = this.mfh.getCapacity();
        FluidTankInfo[] tankInfo = new FluidTankInfo[length];
        for (int i = 0; i < length; ++i) {
            tankInfo[i] = new FluidTankInfo(fluids[i], maxCapcity);
        }
        return tankInfo;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    static {
        vals.put(3, 2000);
        vals.put(5, 20000);
        vals.put(7, 200000);
    }
}

