/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoTunnel;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import common.Blocks;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class GTMTE_LapotronicSuperCapacitor
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GTMTE_LapotronicSuperCapacitor> {
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_LAYER = "slice";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_MID = "mid";
    private static final Block LSC_PART = Blocks.lscLapotronicEnergyUnit;
    private static final int CASING_META = 0;
    private static final int CASING_TEXTURE_ID = 5503;
    private static final IStructureDefinition<GTMTE_LapotronicSuperCapacitor> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"bbbbb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}, {"bb~bb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}})).addShape("slice", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gcccg", "gcccg", "gcccg", "ggggg"}})).addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "ggggg", "ggggg", "ggggg", "ggggg"}})).addShape("mid", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gCCCg", "gCCCg", "gCCCg", "ggggg"}})).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GTMTE_LapotronicSuperCapacitor::addBottomHatches, (int)5503, (int)1), StructureUtility.onElementPass(te -> ++te.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)LSC_PART, (int)0))})).addElement(Character.valueOf('g'), BorosilicateGlass.ofBoroGlass((byte)-1, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier)).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onlyIf(te -> te.topState != TopState.NotTop, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.Top;
    }, (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)-1, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier))), StructureUtility.onlyIf(te -> te.topState != TopState.Top, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.NotTop;
    }, (IStructureElement)StructureUtility.ofBlockAdder(GTMTE_LapotronicSuperCapacitor::addStorageCell, (Block)LSC_PART, (int)1)))})).addElement(Character.valueOf('C'), StructureUtility.ofBlock((Block)LSC_PART, (int)1)).build();
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigDecimal PASSIVE_DISCHARGE_FACTOR_PER_TICK = BigDecimal.valueOf(5.787037037037037E-9);
    private final Set<GT_MetaTileEntity_Hatch_EnergyMulti> mEnergyHatchesTT = new HashSet<GT_MetaTileEntity_Hatch_EnergyMulti>();
    private final Set<GT_MetaTileEntity_Hatch_DynamoMulti> mDynamoHatchesTT = new HashSet<GT_MetaTileEntity_Hatch_DynamoMulti>();
    private final Set<GT_MetaTileEntity_Hatch_EnergyTunnel> mEnergyTunnelsTT = new HashSet<GT_MetaTileEntity_Hatch_EnergyTunnel>();
    private final Set<GT_MetaTileEntity_Hatch_DynamoTunnel> mDynamoTunnelsTT = new HashSet<GT_MetaTileEntity_Hatch_DynamoTunnel>();
    private final int[] capacitors = new int[7];
    private BigInteger capacity = BigInteger.ZERO;
    private BigInteger stored = BigInteger.ZERO;
    private BigInteger passiveDischargeAmount = BigInteger.ZERO;
    private BigInteger inputLastTick = BigInteger.ZERO;
    private BigInteger outputLastTick = BigInteger.ZERO;
    private int repairStatusCache = 0;
    private byte glasTier = (byte)-1;
    private int casingAmount = 0;
    private TopState topState = TopState.MayBeTop;
    private long mMaxEUIn = 0L;
    private long mMaxEUOut = 0L;

    public GTMTE_LapotronicSuperCapacitor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_LapotronicSuperCapacitor(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_LapotronicSuperCapacitor(this.mName);
    }

    public IStructureDefinition<GTMTE_LapotronicSuperCapacitor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    private void processInputHatch(GT_MetaTileEntity_Hatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUIn += aHatch.maxEUInput() * aHatch.maxAmperesIn();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private void processOutputHatch(GT_MetaTileEntity_Hatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUOut += aHatch.maxEUOutput() * aHatch.maxAmperesOut();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private boolean addBottomHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead()) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity;
            this.processInputHatch((GT_MetaTileEntity_Hatch)tHatch, aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyTunnel) {
            GT_MetaTileEntity_Hatch_EnergyTunnel tHatch = (GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity;
            this.processInputHatch((GT_MetaTileEntity_Hatch)tHatch, aBaseCasingIndex);
            return this.mEnergyTunnelsTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            GT_MetaTileEntity_Hatch_EnergyMulti tHatch = (GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity;
            this.processInputHatch((GT_MetaTileEntity_Hatch)tHatch, aBaseCasingIndex);
            return this.mEnergyHatchesTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            GT_MetaTileEntity_Hatch_Dynamo tDynamo = (GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity;
            this.processOutputHatch((GT_MetaTileEntity_Hatch)tDynamo, aBaseCasingIndex);
            return this.mDynamoHatches.add(tDynamo);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoTunnel) {
            GT_MetaTileEntity_Hatch_DynamoTunnel tDynamo = (GT_MetaTileEntity_Hatch_DynamoTunnel)aMetaTileEntity;
            this.processOutputHatch((GT_MetaTileEntity_Hatch)tDynamo, aBaseCasingIndex);
            return this.mDynamoTunnelsTT.add(tDynamo);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            GT_MetaTileEntity_Hatch_DynamoMulti tDynamo = (GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity;
            this.processOutputHatch((GT_MetaTileEntity_Hatch)tDynamo, aBaseCasingIndex);
            return this.mDynamoHatchesTT.add(tDynamo);
        }
        return false;
    }

    private boolean addStorageCell(Block block, int meta) {
        if (block != LSC_PART || meta == 0) {
            return false;
        }
        int n = meta - 1;
        this.capacitors[n] = this.capacitors[n] + 1;
        return true;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Battery Buffer").addInfo("Power storage structure. Does not charge batteries or tools, however.").addInfo("Loses energy equal to 1% of the total capacity every 24 hours.").addInfo("Exception: Ultimate Capacitors only count as Lapotronic Capacitors (UV) for the").addInfo("purposes of passive loss calculation. The full capacity is counted towards the actual power capacity.").addSeparator().addInfo("Glass shell has to be Tier - 2 of the highest capacitor tier").addInfo("UV-tier glass required for TecTech Laser Hatches").addInfo("Add more or better capacitors to increase capacity").addSeparator().beginVariableStructureBlock(5, 5, 4, 18, 5, 5, false).addStructureInfo("Modular height of 4-18 blocks.").addController("Front center bottom").addOtherStructurePart("Lapotronic Super Capacitor Casing", "5x2x5 base (at least 17x)").addOtherStructurePart("Lapotronic Capacitor (EV-UV), Ultimate Capacitor (UHV)", "Center 3x(1-15)x3 above base (9-135 blocks)").addStructureInfo("You can also use the Empty Capacitor to save materials if you use it for less than half the blocks").addOtherStructurePart("Borosilicate Glass (any)", "41-265x, Encase capacitor pillar").addEnergyHatch("Any casing").addDynamoHatch("Any casing").addOtherStructurePart("Laser Target/Source Hatches", "Any casing, must be using UV-tier glass").addStructureInfo("You can have several I/O Hatches").addMaintenanceHatch("Any casing").toolTipFinisher("KekzTech");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, (short[])Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        if (aSide == aFacing && aActive) {
            sTexture = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, (short[])Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        }
        return sTexture;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        this.mProgresstime = 1;
        this.mMaxProgresstime = 1;
        this.mEUt = 0;
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        block7: {
            Arrays.fill(this.capacitors, 0);
            this.mEnergyHatchesTT.clear();
            this.mDynamoHatchesTT.clear();
            this.mEnergyTunnelsTT.clear();
            this.mDynamoTunnelsTT.clear();
            this.mMaxEUIn = 0L;
            this.mMaxEUOut = 0L;
            if (!this.checkPiece(STRUCTURE_PIECE_BASE, 2, 1, 0)) {
                return false;
            }
            this.topState = TopState.NotTop;
            int layer = 2;
            do {
                if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 2, layer, 0)) {
                    return false;
                }
                ++layer;
                if (this.topState == TopState.Top) break block7;
                this.topState = TopState.MayBeTop;
            } while (layer <= 18);
            return false;
        }
        for (int highestCapacitor = this.capacitors.length - 1; highestCapacitor >= 0; --highestCapacitor) {
            if (this.capacitors[highestCapacitor] <= 0) continue;
            if (Capacitor.VALUES[highestCapacitor].getMinimalGlassTier() <= this.glasTier) break;
            return false;
        }
        if (this.glasTier < 8 && (this.mEnergyTunnelsTT.size() > 0 || this.mDynamoTunnelsTT.size() > 0)) {
            return false;
        }
        if (this.capacitors[5] > this.capacitors[0] + this.capacitors[1] + this.capacitors[2] + this.capacitors[3] + this.capacitors[4] + this.capacitors[6]) {
            return false;
        }
        this.passiveDischargeAmount = this.capacity = BigInteger.ZERO;
        for (int i = 0; i < this.capacitors.length; ++i) {
            int count = this.capacitors[i];
            this.capacity = this.capacity.add(Capacitor.VALUES[i].getProvidedCapacity().multiply(BigInteger.valueOf(count)));
            this.passiveDischargeAmount = this.passiveDischargeAmount.add(Capacitor.VALUES[i].getPassiveDischargeValue().multiply(BigInteger.valueOf(count)));
        }
        this.passiveDischargeAmount = new BigDecimal(this.passiveDischargeAmount).multiply(PASSIVE_DISCHARGE_FACTOR_PER_TICK).toBigInteger();
        this.passiveDischargeAmount = this.recalculateLossWithMaintenance(this.getRepairStatus());
        return this.mMaintenanceHatches.size() == 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = Math.min(stackSize.field_77994_a + 3, 18);
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 2, 1, 0);
        for (int i = 2; i < layer - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MID, stackSize, hintsOnly, 2, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 2, layer - 1, 0);
    }

    public boolean onRunningTick(ItemStack stack) {
        long power;
        long ttLaserWattage;
        long power2;
        this.inputLastTick = BigInteger.ZERO;
        this.outputLastTick = BigInteger.ZERO;
        for (GT_MetaTileEntity_Hatch_Energy gT_MetaTileEntity_Hatch_Energy : this.mEnergyHatches) {
            if (gT_MetaTileEntity_Hatch_Energy == null || gT_MetaTileEntity_Hatch_Energy.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
            long power22 = this.getPowerToDraw(gT_MetaTileEntity_Hatch_Energy.maxEUInput() * gT_MetaTileEntity_Hatch_Energy.maxAmperesIn());
            if (gT_MetaTileEntity_Hatch_Energy.getEUVar() < power22) continue;
            gT_MetaTileEntity_Hatch_Energy.setEUVar(gT_MetaTileEntity_Hatch_Energy.getEUVar() - power22);
            this.stored = this.stored.add(BigInteger.valueOf(power22));
            this.inputLastTick = this.inputLastTick.add(BigInteger.valueOf(power22));
        }
        for (GT_MetaTileEntity_Hatch_Dynamo gT_MetaTileEntity_Hatch_Dynamo : this.mDynamoHatches) {
            if (gT_MetaTileEntity_Hatch_Dynamo == null || gT_MetaTileEntity_Hatch_Dynamo.getBaseMetaTileEntity().isInvalidTileEntity() || (power2 = this.getPowerToPush(gT_MetaTileEntity_Hatch_Dynamo.maxEUOutput() * gT_MetaTileEntity_Hatch_Dynamo.maxAmperesOut())) > gT_MetaTileEntity_Hatch_Dynamo.maxEUStore() - gT_MetaTileEntity_Hatch_Dynamo.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_Dynamo.setEUVar(gT_MetaTileEntity_Hatch_Dynamo.getEUVar() + power2);
            this.stored = this.stored.subtract(BigInteger.valueOf(power2));
            this.outputLastTick = this.outputLastTick.add(BigInteger.valueOf(power2));
        }
        for (GT_MetaTileEntity_Hatch_EnergyMulti gT_MetaTileEntity_Hatch_EnergyMulti : this.mEnergyHatchesTT) {
            if (gT_MetaTileEntity_Hatch_EnergyMulti == null || gT_MetaTileEntity_Hatch_EnergyMulti.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
            power2 = this.getPowerToDraw(gT_MetaTileEntity_Hatch_EnergyMulti.maxEUInput() * gT_MetaTileEntity_Hatch_EnergyMulti.maxAmperesIn());
            if (gT_MetaTileEntity_Hatch_EnergyMulti.getEUVar() < power2) continue;
            gT_MetaTileEntity_Hatch_EnergyMulti.setEUVar(gT_MetaTileEntity_Hatch_EnergyMulti.getEUVar() - power2);
            this.stored = this.stored.add(BigInteger.valueOf(power2));
            this.inputLastTick = this.inputLastTick.add(BigInteger.valueOf(power2));
        }
        for (GT_MetaTileEntity_Hatch_DynamoMulti gT_MetaTileEntity_Hatch_DynamoMulti : this.mDynamoHatchesTT) {
            if (gT_MetaTileEntity_Hatch_DynamoMulti == null || gT_MetaTileEntity_Hatch_DynamoMulti.getBaseMetaTileEntity().isInvalidTileEntity() || (power2 = this.getPowerToPush(gT_MetaTileEntity_Hatch_DynamoMulti.maxEUOutput() * gT_MetaTileEntity_Hatch_DynamoMulti.maxAmperesOut())) > gT_MetaTileEntity_Hatch_DynamoMulti.maxEUStore() - gT_MetaTileEntity_Hatch_DynamoMulti.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_DynamoMulti.setEUVar(gT_MetaTileEntity_Hatch_DynamoMulti.getEUVar() + power2);
            this.stored = this.stored.subtract(BigInteger.valueOf(power2));
            this.outputLastTick = this.outputLastTick.add(BigInteger.valueOf(power2));
        }
        for (GT_MetaTileEntity_Hatch_EnergyTunnel gT_MetaTileEntity_Hatch_EnergyTunnel : this.mEnergyTunnelsTT) {
            if (gT_MetaTileEntity_Hatch_EnergyTunnel == null || gT_MetaTileEntity_Hatch_EnergyTunnel.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
            ttLaserWattage = gT_MetaTileEntity_Hatch_EnergyTunnel.maxEUInput() * (long)gT_MetaTileEntity_Hatch_EnergyTunnel.Amperes - (long)(gT_MetaTileEntity_Hatch_EnergyTunnel.Amperes / 20);
            power = this.getPowerToDraw(ttLaserWattage);
            if (gT_MetaTileEntity_Hatch_EnergyTunnel.getEUVar() < power) continue;
            gT_MetaTileEntity_Hatch_EnergyTunnel.setEUVar(gT_MetaTileEntity_Hatch_EnergyTunnel.getEUVar() - power);
            this.stored = this.stored.add(BigInteger.valueOf(power));
            this.inputLastTick = this.inputLastTick.add(BigInteger.valueOf(power));
        }
        for (GT_MetaTileEntity_Hatch_DynamoTunnel gT_MetaTileEntity_Hatch_DynamoTunnel : this.mDynamoTunnelsTT) {
            if (gT_MetaTileEntity_Hatch_DynamoTunnel == null || gT_MetaTileEntity_Hatch_DynamoTunnel.getBaseMetaTileEntity().isInvalidTileEntity() || (power = this.getPowerToPush(ttLaserWattage = gT_MetaTileEntity_Hatch_DynamoTunnel.maxEUOutput() * (long)gT_MetaTileEntity_Hatch_DynamoTunnel.Amperes - (long)(gT_MetaTileEntity_Hatch_DynamoTunnel.Amperes / 20))) > gT_MetaTileEntity_Hatch_DynamoTunnel.maxEUStore() - gT_MetaTileEntity_Hatch_DynamoTunnel.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_DynamoTunnel.setEUVar(gT_MetaTileEntity_Hatch_DynamoTunnel.getEUVar() + power);
            this.stored = this.stored.subtract(BigInteger.valueOf(power));
            this.outputLastTick = this.outputLastTick.add(BigInteger.valueOf(power));
        }
        if (super.getRepairStatus() != this.repairStatusCache) {
            this.passiveDischargeAmount = this.recalculateLossWithMaintenance(super.getRepairStatus());
        }
        this.stored = this.stored.subtract(this.passiveDischargeAmount);
        this.stored = this.stored.compareTo(BigInteger.ZERO) <= 0 ? BigInteger.ZERO : this.stored;
        IGregTechTileEntity tBMTE = this.getBaseMetaTileEntity();
        tBMTE.injectEnergyUnits((byte)ForgeDirection.UNKNOWN.ordinal(), this.inputLastTick.longValue(), 1L);
        tBMTE.drainEnergyUnits((byte)ForgeDirection.UNKNOWN.ordinal(), this.outputLastTick.longValue(), 1L);
        return true;
    }

    private BigInteger recalculateLossWithMaintenance(int repairStatus) {
        this.repairStatusCache = repairStatus;
        return new BigDecimal(this.passiveDischargeAmount).multiply(BigDecimal.valueOf(1.0 + 0.2 * (double)(this.getIdealStatus() - repairStatus))).toBigInteger();
    }

    private long getPowerToDraw(long hatchWatts) {
        BigInteger remcapActual = this.capacity.subtract(this.stored);
        BigInteger recampLimited = MAX_LONG.compareTo(remcapActual) > 0 ? remcapActual : MAX_LONG;
        return Math.min(hatchWatts, recampLimited.longValue());
    }

    private long getPowerToPush(long hatchWatts) {
        BigInteger remStoredLimited = MAX_LONG.compareTo(this.stored) > 0 ? this.stored : MAX_LONG;
        return Math.min(hatchWatts, remStoredLimited.longValue());
    }

    public String[] getInfoData() {
        IGregTechTileEntity tGTTE = this.getBaseMetaTileEntity();
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("Used Capacity: " + NumberFormat.getNumberInstance().format(this.stored) + "EU");
        ll.add("Total Capacity: " + NumberFormat.getNumberInstance().format(this.capacity) + "EU");
        ll.add("Passive Loss: " + NumberFormat.getNumberInstance().format(this.passiveDischargeAmount) + "EU/t");
        ll.add("EU IN: " + NumberFormat.getNumberInstance().format(this.inputLastTick) + "EU/t");
        ll.add("EU OUT: " + NumberFormat.getNumberInstance().format(this.outputLastTick) + "EU/t");
        ll.add("Avg EU IN: " + NumberFormat.getNumberInstance().format(tGTTE.getAverageElectricInput()));
        ll.add("Avg EU OUT: " + NumberFormat.getNumberInstance().format(tGTTE.getAverageElectricOutput()));
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("---------------------------------------------");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74773_a("capacity", this.capacity.toByteArray());
        nbt.func_74773_a("stored", this.stored.toByteArray());
        nbt.func_74773_a("passiveDischargeAmount", this.passiveDischargeAmount.toByteArray());
        super.saveNBTData(nbt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.capacity = new BigInteger(nbt.func_74770_j("capacity"));
        this.stored = new BigInteger(nbt.func_74770_j("stored"));
        this.passiveDischargeAmount = new BigInteger(nbt.func_74770_j("passiveDischargeAmount"));
        super.loadNBTData(nbt);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public long maxEUStore() {
        return this.capacity.longValue();
    }

    public long getEUVar() {
        return this.stored.longValue();
    }

    public long maxEUInput() {
        return this.mMaxEUIn;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public long maxEUOutput() {
        return this.mMaxEUOut;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    static /* synthetic */ BigInteger access$000() {
        return MAX_LONG;
    }

    private static enum Capacitor {
        IV(2, BigInteger.valueOf(400000000L), BigInteger.valueOf(400000000L)),
        LuV(3, BigInteger.valueOf(4000000000L), BigInteger.valueOf(4000000000L)),
        ZPM(4, BigInteger.valueOf(40000000000L), BigInteger.valueOf(40000000000L)),
        UV(5, BigInteger.valueOf(400000000000L), BigInteger.valueOf(400000000000L)),
        UHV(6, BigInteger.valueOf(100000000000L), GTMTE_LapotronicSuperCapacitor.access$000()),
        None(0, BigInteger.ZERO, BigInteger.ZERO),
        EV(1, BigInteger.valueOf(40000000L), BigInteger.valueOf(40000000L));

        private final int minimalGlassTier;
        private final BigInteger passiveDischargeValue;
        private final BigInteger providedCapacity;
        static final Capacitor[] VALUES;

        private Capacitor(int minimalGlassTier, BigInteger passiveDischargeValue, BigInteger providedCapacity) {
            this.minimalGlassTier = minimalGlassTier;
            this.passiveDischargeValue = passiveDischargeValue;
            this.providedCapacity = providedCapacity;
        }

        public int getMinimalGlassTier() {
            return this.minimalGlassTier;
        }

        public BigInteger getPassiveDischargeValue() {
            return this.passiveDischargeValue;
        }

        public BigInteger getProvidedCapacity() {
            return this.providedCapacity;
        }

        static {
            VALUES = Capacitor.values();
        }
    }

    private static enum TopState {
        MayBeTop,
        Top,
        NotTop;

    }
}

