/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import kubatech.api.tileentity.CustomTileEntityPacketHandler;
import kubatech.api.utils.ModUtils;
import kubatech.kubatech;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CustomTileEntityPacket
implements IMessage {
    public int w;
    public int x;
    public int y;
    public int z;
    public final ByteBuf customdata = Unpooled.buffer();

    public CustomTileEntityPacket() {
    }

    public CustomTileEntityPacket(TileEntity te, byte[] customdata) {
        this.w = te.func_145831_w().field_73011_w.field_76574_g;
        this.x = te.field_145851_c;
        this.y = te.field_145848_d;
        this.z = te.field_145849_e;
        if (customdata != null && customdata.length > 0) {
            this.customdata.writeBytes(customdata);
        }
    }

    public void sendToAllAround(int range) {
        kubatech.NETWORK.sendToAllAround((IMessage)this, new NetworkRegistry.TargetPoint(this.w, (double)this.x, (double)this.y, (double)this.z, (double)range));
    }

    public void resetHelperData() {
        this.customdata.clear();
    }

    public void addData(byte[] data) {
        this.customdata.writeBytes(data);
    }

    public void addData(byte data) {
        this.customdata.writeByte((int)data);
    }

    public void addData(int data) {
        this.customdata.writeInt(data);
    }

    public void addData(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        this.addData(bytes.length);
        this.addData(bytes);
    }

    public void addData(boolean data) {
        this.customdata.writeBoolean(data);
    }

    public void getData(byte[] bytes) {
        this.customdata.readBytes(bytes);
    }

    public byte[] getData(int len) {
        byte[] bytes = new byte[len];
        this.getData(bytes);
        return bytes;
    }

    public int getDataInt() {
        return this.customdata.readInt();
    }

    public String getDataString() {
        return new String(this.getData(this.getDataInt()), StandardCharsets.UTF_8);
    }

    public boolean getDataBoolean() {
        return this.customdata.readBoolean();
    }

    public void fromBytes(ByteBuf buf) {
        this.w = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.customdata.clear();
        buf.readBytes(this.customdata, buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.w);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.customdata.readableBytes());
        buf.writeBytes(this.customdata);
    }

    public static class Handler
    implements IMessageHandler<CustomTileEntityPacket, IMessage> {
        public IMessage onMessage(CustomTileEntityPacket message, MessageContext ctx) {
            if (!ModUtils.isClientSided) {
                return null;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null) {
                return null;
            }
            if (mc.field_71439_g == null) {
                return null;
            }
            World w = mc.field_71439_g.func_130014_f_();
            if (w == null) {
                return null;
            }
            if (message.w != w.field_73011_w.field_76574_g) {
                return null;
            }
            TileEntity e = w.func_147438_o(message.x, message.y, message.z);
            if (e == null || e.func_145837_r()) {
                return null;
            }
            if (e instanceof IGregTechTileEntity && !((IGregTechTileEntity)e).isInvalidTileEntity()) {
                IMetaTileEntity mte = ((IGregTechTileEntity)e).getMetaTileEntity();
                if (mte == null) {
                    return null;
                }
                if (!(mte instanceof CustomTileEntityPacketHandler)) {
                    return null;
                }
                ((CustomTileEntityPacketHandler)mte).HandleCustomPacket(message);
                return null;
            }
            if (!(e instanceof CustomTileEntityPacketHandler)) {
                return null;
            }
            ((CustomTileEntityPacketHandler)e).HandleCustomPacket(message);
            return null;
        }
    }
}

