/*
 * Decompiled with CFR 0.152.
 */
package kubatech.config;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modcustomdrops.CustomDrops;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kubatech.api.ConstructableItemStack;
import kubatech.api.LoaderReference;
import kubatech.api.helpers.ReflectionHelper;
import kubatech.api.mobhandler.MobDrop;
import kubatech.api.utils.GSONUtils;
import kubatech.config.Config;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverridesConfig {
    private static final Logger LOG = LogManager.getLogger((String)"kubatech[Config-Overrides]");
    public static Map<String, MobOverride> overrides = new HashMap<String, MobOverride>();
    private static File overrideFile = null;
    private static final Gson gson = GSONUtils.GSON_BUILDER_PRETTY.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LoadConfig() {
        block24: {
            LOG.info("Loading Config");
            if (overrideFile == null) {
                overrideFile = Config.getConfigFile("MobOverrides.cfg");
            }
            if (!overrideFile.exists()) {
                OverridesConfig.writeExampleFile();
            }
            BufferedReader reader = null;
            try {
                reader = Files.newReader((File)overrideFile, (Charset)StandardCharsets.UTF_8);
                overrides = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, MobOverride>>(){}.getType());
                overrides.remove("ExampleMob");
                overrides.values().forEach(o -> o.additions.forEach(MobDrop::reconstructStack));
                if (!LoaderReference.GTNHCoreMod) break block24;
                LOG.info("Detected GTNH Core Mod, parsing custom drops from there.");
                CustomDrops coredrops = ReflectionHelper.getField(MainRegistry.Module_CustomDrops, "_mCustomDrops", null);
                if (coredrops == null) break block24;
                ArrayList customdrops = (ArrayList)((ArrayList)coredrops.getCustomDrops()).clone();
                for (CustomDrops.CustomDrop customdrop : customdrops) {
                    try {
                        String ename;
                        Class<?> eclass = Class.forName(customdrop.getEntityName());
                        if (!EntityLiving.class.isAssignableFrom(eclass) || (ename = (String)EntityList.field_75626_c.get(eclass)) == null) continue;
                        MobOverride override = overrides.computeIfAbsent(ename, k -> new MobOverride());
                        for (CustomDrops.CustomDrop.Drop drop : customdrop.getDrops()) {
                            String pNBT;
                            String[] parts = drop.getItemName().split(":");
                            ItemStack stack = GameRegistry.findItemStack((String)parts[0], (String)parts[1], (int)1);
                            if (stack == null) continue;
                            if (parts.length > 2) {
                                stack.func_77964_b(Integer.parseInt(parts[2]));
                            }
                            if ((pNBT = (String)ReflectionHelper.getField(drop, "mTag", null)) != null && !pNBT.isEmpty()) {
                                try {
                                    stack.field_77990_d = (NBTTagCompound)JsonToNBT.func_150315_a((String)pNBT);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            int chance = drop.getChance() * 100;
                            int amount = drop.getAmount();
                            if (drop.getIsRandomAmount()) {
                                chance = (int)((double)chance * ((2.0 + (double)(amount * amount) + (double)amount) / (2.0 * ((double)amount + 1.0))));
                                amount = 1;
                                if (chance > 10000) {
                                    int div = (int)Math.ceil((double)chance / 10000.0);
                                    amount *= div;
                                    chance /= div;
                                }
                            }
                            stack.field_77994_a = amount;
                            override.additions.add(new MobDrop(stack, MobDrop.DropType.Normal, chance, null, null, false, true));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeExampleFile() {
        LOG.info("No config has been detected, writing an example one");
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)overrideFile, (Charset)StandardCharsets.UTF_8);
            HashMap<String, MobOverride> example = new HashMap<String, MobOverride>(1);
            MobOverride ex1 = new MobOverride();
            ex1.removals.add(new MobDropSimplified(new ItemStack(Items.field_151078_bh, 1), MobDrop.DropType.Normal));
            HashMap<Integer, Integer> exdamages = new HashMap<Integer, Integer>(3);
            exdamages.put(1, 1);
            exdamages.put(2, 5);
            exdamages.put(3, 10);
            ex1.additions.add(new MobDrop(new ItemStack(Items.field_151048_u), MobDrop.DropType.Rare, 500, 20, exdamages, true, false));
            example.put("ExampleMob", ex1);
            gson.toJson(example, (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class MobOverride {
        public boolean removeAll = false;
        public final List<MobDrop> additions = new ArrayList<MobDrop>();
        public final List<MobDropSimplified> removals = new ArrayList<MobDropSimplified>();
        private static final ByteBuf BufHelper = Unpooled.buffer();

        public void writeToByteBuf(ByteBuf byteBuf) {
            BufHelper.clear();
            BufHelper.writeBoolean(this.removeAll);
            BufHelper.writeInt(this.additions.size());
            this.additions.forEach(drop -> drop.writeToByteBuf(BufHelper));
            BufHelper.writeInt(this.removals.size());
            this.removals.forEach(drop -> drop.writeToByteBuf(BufHelper));
            byteBuf.writeInt(BufHelper.readableBytes());
            byteBuf.writeBytes(BufHelper);
        }

        public static MobOverride readFromByteBuf(ByteBuf byteBuf) {
            int size = byteBuf.readInt();
            MobOverride mobOverride = new MobOverride();
            mobOverride.removeAll = byteBuf.readBoolean();
            int additionssize = byteBuf.readInt();
            for (int i = 0; i < additionssize; ++i) {
                mobOverride.additions.add(MobDrop.readFromByteBuf(byteBuf));
            }
            int removalssize = byteBuf.readInt();
            for (int i = 0; i < removalssize; ++i) {
                mobOverride.removals.add(MobDropSimplified.readFromByteBuf(byteBuf));
            }
            return mobOverride;
        }
    }

    public static class MobDropSimplified {
        @GSONUtils.SkipGSON
        ItemStack stack;
        ConstructableItemStack reconstructableStack;
        MobDrop.DropType type;
        private static final ByteBuf BufHelper = Unpooled.buffer();

        private MobDropSimplified() {
        }

        public MobDropSimplified(ItemStack stack, MobDrop.DropType type) {
            this.reconstructableStack = new ConstructableItemStack(stack);
            this.type = type;
        }

        public void reconstructStack() {
            this.stack = this.reconstructableStack.construct();
        }

        public boolean isMatching(MobDrop drop) {
            return this.reconstructableStack.isSame(drop.reconstructableStack, true);
        }

        public void writeToByteBuf(ByteBuf byteBuf) {
            BufHelper.clear();
            this.reconstructableStack.writeToByteBuf(BufHelper);
            BufHelper.writeInt(this.type.ordinal());
            byteBuf.writeInt(BufHelper.readableBytes());
            byteBuf.writeBytes(BufHelper);
        }

        public static MobDropSimplified readFromByteBuf(ByteBuf byteBuf) {
            MobDropSimplified mobDropSimplified = new MobDropSimplified();
            int size = byteBuf.readInt();
            mobDropSimplified.reconstructableStack = ConstructableItemStack.readFromByteBuf(byteBuf);
            mobDropSimplified.type = MobDrop.DropType.get(byteBuf.readInt());
            mobDropSimplified.reconstructStack();
            return mobDropSimplified;
        }
    }
}

