/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders.block;

import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import java.util.List;
import kubatech.loaders.block.IProxyTileEntityProvider;
import kubatech.loaders.block.KubaBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockProxy {
    private final String unlocalizedName;
    private final String texturepath;
    private IIcon icon;

    public BlockProxy(String unlocalizedName, String texture) {
        this.unlocalizedName = "kubablock." + unlocalizedName;
        this.texturepath = "kubatech:" + texture;
    }

    public void itemInit(int ID) {
    }

    public boolean onActivated(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te;
        if (this instanceof IProxyTileEntityProvider && (te = world.func_147438_o(x, y, z)) instanceof ITileWithModularUI) {
            if (world.field_72995_K) {
                return true;
            }
            if (te instanceof KubaBlock.IModularUIProvider) {
                ((KubaBlock.IModularUIProvider)te).getUI().open(player, world, x, y, z);
            } else {
                KubaBlock.defaultTileEntityUI.open(player, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public void onBlockPlaced(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
    }

    public void registerIcon(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a(this.texturepath);
    }

    public IIcon getIcon(int side) {
        return this.icon;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getDisplayName(ItemStack stack) {
        return StatCollector.func_74838_a((String)(this.unlocalizedName + ".name")).trim();
    }

    public void addInformation(ItemStack stack, EntityPlayer entity, List<String> tooltipList, boolean showDebugInfo) {
    }

    public float getHardness() {
        return 10.0f;
    }

    public Material getMaterial() {
        return Material.field_151574_g;
    }

    public float getResistance() {
        return 5.0f;
    }
}

