/*
 * Decompiled with CFR 0.152.
 */
package kubatech.savedata;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import kubatech.savedata.PlayerData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;

public class PlayerDataManager
extends WorldSavedData {
    private static final String playerDataName = "KubaTech_PlayerData";
    static PlayerDataManager Instance = null;
    private final HashMap<String, PlayerData> players = new HashMap();

    public static void Initialize(World world) {
        if (Instance != null) {
            PlayerDataManager.Instance.players.clear();
        }
        if ((Instance = (PlayerDataManager)world.field_72988_C.func_75742_a(PlayerDataManager.class, playerDataName)) == null) {
            Instance = new PlayerDataManager();
            world.field_72988_C.func_75745_a(playerDataName, (WorldSavedData)Instance);
        }
        Instance.func_76185_a();
    }

    public PlayerDataManager(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public PlayerDataManager() {
        super(playerDataName);
    }

    public void func_76184_a(NBTTagCompound NBTData) {
        if (!NBTData.func_74764_b("size")) {
            return;
        }
        this.players.clear();
        int imax = NBTData.func_74762_e("size");
        for (int i = 0; i < imax; ++i) {
            NBTTagCompound playerNBTData = NBTData.func_74775_l("Player." + i);
            this.players.put(playerNBTData.func_74779_i("username"), new PlayerData(playerNBTData.func_74775_l("data")));
        }
    }

    public void func_76187_b(NBTTagCompound NBTData) {
        NBTData.func_74768_a("size", this.players.size());
        int i = 0;
        for (Map.Entry<String, PlayerData> playerDataEntry : this.players.entrySet()) {
            NBTTagCompound playerNBTData = new NBTTagCompound();
            playerNBTData.func_74778_a("username", playerDataEntry.getKey());
            playerNBTData.func_74782_a("data", (NBTBase)playerDataEntry.getValue().toNBTData());
            NBTData.func_74782_a("Player." + i++, (NBTBase)playerNBTData);
        }
    }

    public static PlayerData getPlayer(String username) {
        if (Instance == null) {
            return null;
        }
        return PlayerDataManager.Instance.players.computeIfAbsent(username, s -> new PlayerData());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        PlayerDataManager.Initialize(event.world);
    }
}

