/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import java.text.NumberFormat;
import java.util.function.BiFunction;
import kubatech.api.enums.ItemList;
import kubatech.api.utils.StringUtils;
import kubatech.loaders.ItemLoader;
import kubatech.loaders.block.KubaBlock;
import kubatech.savedata.PlayerData;
import kubatech.savedata.PlayerDataManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;

public class TeaAcceptorTile
extends TileEntity
implements IInventory,
ITileWithModularUI,
KubaBlock.IModularUIProvider {
    private String tileOwner = null;
    private PlayerData playerData = null;
    private long averageInput = 0L;
    private long inAmount = 0L;
    private int ticker = 0;
    private static final int minDamage = ItemList.BlackTea.get(1L, new Object[0]).func_77960_j();
    private static final int maxDamage = ItemList.YellowTea.get(1L, new Object[0]).func_77960_j();
    private static final UIInfo<?, ?> UI = KubaBlock.TileEntityUIFactory.apply(ModularUIContainer::new);
    private static final BiFunction<TextWidget, Integer, Widget.PosProvider> posCenteredHorizontallyProvider = (widget, y) -> (screenSize, window, parent) -> new Pos2d(window.getSize().width / 2 - widget.getSize().width / 2, y.intValue());

    public void setTeaOwner(String teaOwner) {
        if (this.tileOwner == null || this.tileOwner.isEmpty()) {
            this.tileOwner = teaOwner;
            this.playerData = PlayerDataManager.getPlayer(this.tileOwner);
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound NBTData) {
        super.func_145839_a(NBTData);
        this.tileOwner = NBTData.func_74779_i("tileOwner");
        if (!this.tileOwner.isEmpty()) {
            this.playerData = PlayerDataManager.getPlayer(this.tileOwner);
        }
    }

    public void func_145841_b(NBTTagCompound NBTData) {
        super.func_145841_b(NBTData);
        NBTData.func_74778_a("tileOwner", this.tileOwner);
    }

    public void func_145845_h() {
        if (++this.ticker % 100 == 0) {
            this.averageInput = this.inAmount / 100L;
            this.inAmount = 0L;
        }
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        if (this.playerData != null) {
            this.playerData.teaAmount += (long)p_70299_2_.field_77994_a;
            this.playerData.markDirty();
            this.inAmount += (long)p_70299_2_.field_77994_a;
        }
    }

    public String func_145825_b() {
        return "Tea acceptor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return p_70300_1_.func_70005_c_().equals(this.tileOwner);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return p_94041_2_.func_77973_b() == ItemLoader.kubaitems && p_94041_2_.func_77960_j() >= minDamage && p_94041_2_.func_77960_j() <= maxDamage;
    }

    @Override
    public UIInfo<?, ?> getUI() {
        return UI;
    }

    private static TextWidget posCenteredHorizontally(int y, TextWidget textWidget) {
        return (TextWidget)textWidget.setPosProvider(posCenteredHorizontallyProvider.apply(textWidget, y));
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        ModularWindow.Builder builder = ModularWindow.builder((int)170, (int)70);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        EntityPlayer player = buildContext.getPlayer();
        builder.widgets(new Widget[]{TeaAcceptorTile.posCenteredHorizontally(10, new TextWidget(new Text("Tea Acceptor").format(EnumChatFormatting.BOLD).format(EnumChatFormatting.DARK_RED))), TeaAcceptorTile.posCenteredHorizontally(30, (TextWidget)new DynamicTextWidget(() -> {
            if (player.func_70005_c_().equals(this.tileOwner)) {
                return new Text("[Tea]").color(Color.GREEN.normal);
            }
            return new Text("This is not your block").color(Color.RED.normal);
        })), TeaAcceptorTile.posCenteredHorizontally(40, (TextWidget)new DynamicTextWidget(() -> new Text(this.playerData == null ? "ERROR" : StringUtils.applyRainbow(NumberFormat.getInstance().format(this.playerData.teaAmount), (int)(this.playerData.teaAmount / Math.max(1L, this.averageInput * 10L) % Integer.MAX_VALUE), EnumChatFormatting.BOLD.toString())).shadow())), TeaAcceptorTile.posCenteredHorizontally(50, (TextWidget)new DynamicTextWidget(() -> new Text("IN: " + this.averageInput + "/t").color(Color.BLACK.normal))).addTooltip(new Text("Average input from the last 5 seconds").color(Color.GRAY.normal))});
        return builder.build();
    }
}

