/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.event.RitualRunEvent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectWellOfSuffering;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import kubatech.api.LoaderReference;
import kubatech.api.Variables;
import kubatech.api.helpers.ReflectionHelper;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.api.network.CustomTileEntityPacket;
import kubatech.api.tileentity.CustomTileEntityPacketHandler;
import kubatech.api.utils.FastRandom;
import kubatech.api.utils.ItemID;
import kubatech.client.effect.EntityRenderer;
import kubatech.loaders.MobRecipeLoader;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ExtremeExterminationChamber
extends KubaTechGTMultiBlockBase<GT_MetaTileEntity_ExtremeExterminationChamber>
implements CustomTileEntityPacketHandler,
ISurvivalConstructable {
    public static final HashMap<String, MobRecipeLoader.MobRecipe> MobNameToRecipeMap = new HashMap();
    public static final double DIAMOND_SPIKES_DAMAGE = 9.0;
    public static final int MOB_SPAWN_INTERVAL = 55;
    public final Random rand = new FastRandom();
    private static final String WellOfSufferingRitualName = "AW013Suffering";
    private static final Item poweredSpawnerItem = Item.func_150898_a((Block)EnderIO.blockPoweredSpawner);
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_ExtremeExterminationChamber> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "gsssg", "gsssg", "gsssg", "fgggf"}, {"CC~CC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement('c', StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0))).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_ExtremeExterminationChamber.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Energy, GT_HatchElement.Maintenance}).casingIndex(16).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0))})).addElement('g', LoaderReference.Bartworks ? BorosilicateGlass.ofBoroGlass((byte)0, (t, v) -> {
        t.mGlassTier = v;
    }, t -> t.mGlassTier) : StructureUtility.onElementPass(t -> {
        t.mGlassTier = (byte)100;
    }, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150359_w, (int)0))).addElement('f', GT_StructureUtility.ofFrame((Materials)Materials.Steel)).addElement('s', LoaderReference.ExtraUtilities ? StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ExtraUtilities:spike_base_diamond"), (int)0) : StructureUtility.isAir()).build();
    private TileEntity masterStoneRitual = null;
    private TileEntity tileAltar = null;
    private boolean isInRitualMode = false;
    private int mCasing = 0;
    private byte mGlassTier = 0;
    private boolean mAnimationEnabled = true;
    private boolean mIsProducingInfernalDrops = true;
    private EntityRenderer entityRenderer = null;
    private boolean renderEntity = false;
    private EECFakePlayer EECPlayer = null;
    private CustomTileEntityPacket mobPacket = null;
    private final WeaponCache weaponCache = new WeaponCache();

    public GT_MetaTileEntity_ExtremeExterminationChamber(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ExtremeExterminationChamber(String aName) {
        super(aName);
        if (LoaderReference.BloodMagic) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void onRemoval() {
        if (LoaderReference.BloodMagic) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        if (this.getBaseMetaTileEntity().isClientSide() && this.entityRenderer != null) {
            this.entityRenderer.func_70106_y();
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isInRitualMode", this.isInRitualMode);
        aNBT.func_74757_a("mAnimationEnabled", this.mAnimationEnabled);
        aNBT.func_74774_a("mGlassTier", this.mGlassTier);
        aNBT.func_74757_a("mIsProducingInfernalDrops", this.mIsProducingInfernalDrops);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isInRitualMode = aNBT.func_74767_n("isInRitualMode");
        this.mAnimationEnabled = !aNBT.func_74764_b("mAnimationEnabled") || aNBT.func_74767_n("mAnimationEnabled");
        this.mGlassTier = aNBT.func_74771_c("mGlassTier");
        this.mIsProducingInfernalDrops = !aNBT.func_74764_b("mIsProducingInfernalDrops") || aNBT.func_74767_n("mIsProducingInfernalDrops");
    }

    @Override
    public boolean isOverclockingInfinite() {
        return true;
    }

    @Override
    protected int getOverclockTimeLimit() {
        return 20;
    }

    public IStructureDefinition<GT_MetaTileEntity_ExtremeExterminationChamber> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Powered Spawner").addInfo("Controller block for Extreme Extermination Chamber").addInfo(Variables.Author).addInfo("Spawns and Exterminates monsters for you").addInfo("You have to insert the powered spawner in controller").addInfo("Base energy usage: 2,000 EU/t").addInfo("Supports perfect OC, minimum time: 20 ticks, after that multiplies the outputs").addInfo("Recipe time is based on mob health").addInfo("You can additionally put a weapon to the ULV input bus").addInfo("It will speed up the process and apply looting level from the weapon (maximum 4 levels)").addInfo(EnumChatFormatting.RED + "Enchanting the spikes inside does nothing!").addInfo("Also produces 120 Liquid XP per operation").addInfo("If the mob spawns infernal").addInfo("it will drain 8 times more power").addInfo("You can prevent infernal spawns by shift clicking with a screwdriver").addInfo("Note: If the mob has forced infernal spawn, it will do it anyway").addInfo("You can enable ritual mode with a screwdriver").addInfo("When in ritual mode and Well Of Suffering ritual is built directly on the machine in center").addInfo("The mobs will start to buffer and die very slowly by a ritual").addInfo("You can disable mob animation with a soldering iron").addInfo(Variables.StructureHologram).addSeparator().beginStructureBlock(5, 7, 5, true).addController("Front Bottom Center").addCasingInfoMin("Solid Steel Machine Casing", 10, false).addOtherStructurePart("Borosilicate Glass", "All walls without corners").addStructureInfo("The glass tier limits the Energy Input tier").addOtherStructurePart("Steel Frame Box", "All vertical corners (except top and bottom)").addOtherStructurePart("Diamond spikes", "Inside second layer").addOutputBus("Any bottom casing", new int[]{1}).addOtherStructurePart("1x ULV " + StatCollector.func_74838_a((String)"GT5U.MBTT.InputBus"), "Any bottom casing", new int[]{1}).addOutputHatch("Any bottom casing", new int[]{1}).addEnergyHatch("Any bottom casing", new int[]{1}).addMaintenanceHatch("Any bottom casing", new int[]{1}).toolTipFinisher("KubaTech");
        return tt;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 6, 0, elementBudget, env, true, true);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ExtremeExterminationChamber(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    @SideOnly(value=Side.CLIENT)
    private void setupEntityRenderer(IGregTechTileEntity aBaseMetaTileEntity, int time) {
        if (this.entityRenderer == null) {
            ChunkCoordinates coords = this.getBaseMetaTileEntity().getCoords();
            int[] abc = new int[]{0, -2, 2};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + coords.field_71574_a;
            xyz[1] = xyz[1] + coords.field_71572_b;
            xyz[2] = xyz[2] + coords.field_71573_c;
            this.entityRenderer = new EntityRenderer(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], time);
        } else {
            this.entityRenderer.func_70106_y();
            this.entityRenderer = new EntityRenderer(this.entityRenderer, time);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)this.entityRenderer);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.renderEntity && aBaseMetaTileEntity.isActive() && aTick % 40L == 0L) {
            this.setupEntityRenderer(aBaseMetaTileEntity, 40);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void HandleCustomPacket(CustomTileEntityPacket message) {
        if (message.getDataBoolean()) {
            this.renderEntity = true;
            String mobType = message.getDataString();
            MobRecipeLoader.MobRecipe r = MobNameToRecipeMap.get(mobType);
            if (r != null) {
                if (this.entityRenderer == null) {
                    this.setupEntityRenderer(this.getBaseMetaTileEntity(), 40);
                }
                this.entityRenderer.setEntity(r.entity);
            } else {
                this.entityRenderer.setEntity(null);
            }
        } else {
            this.renderEntity = false;
            if (this.entityRenderer != null) {
                this.entityRenderer.func_70106_y();
                this.entityRenderer = null;
            }
        }
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Can't change mode when running !");
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (!LoaderReference.InfernalMobs) {
                return;
            }
            boolean bl = this.mIsProducingInfernalDrops = !this.mIsProducingInfernalDrops;
            if (!this.mIsProducingInfernalDrops) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Mobs will now be prevented from spawning infernal");
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Mobs can spawn infernal now");
            }
        } else {
            if (!LoaderReference.BloodMagic) {
                return;
            }
            boolean bl = this.isInRitualMode = !this.isInRitualMode;
            if (!this.isInRitualMode) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Ritual mode disabled");
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Ritual mode enabled");
                if (this.connectToRitual()) {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Successfully connected to the ritual");
                } else {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Can't connect to the ritual");
                }
            }
        }
    }

    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (super.onSolderingToolRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ)) {
            return true;
        }
        this.mAnimationEnabled = !this.mAnimationEnabled;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Animations are " + (this.mAnimationEnabled ? "enabled" : "disabled")));
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRitualPerform(RitualRunEvent event) {
        Rituals ritual;
        if (!this.isInRitualMode) {
            return;
        }
        if (this.masterStoneRitual == null) {
            return;
        }
        if (this.mMaxProgresstime == 0) {
            return;
        }
        if (event.mrs.equals(this.masterStoneRitual) && event.ritualKey.equals(WellOfSufferingRitualName) && (ritual = (Rituals)Rituals.ritualMap.get(WellOfSufferingRitualName)) != null && ritual.effect instanceof RitualEffectWellOfSuffering) {
            RitualEffectWellOfSuffering effect = (RitualEffectWellOfSuffering)ritual.effect;
            event.setCanceled(true);
            String owner = event.mrs.getOwner();
            int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
            World world = event.mrs.getWorld();
            int x = event.mrs.getXCoord();
            int y = event.mrs.getYCoord();
            int z = event.mrs.getZCoord();
            if (world.func_72820_D() % 25L != 0L) {
                return;
            }
            if (this.tileAltar == null || this.tileAltar.func_145837_r()) {
                this.tileAltar = null;
                for (int i = -5; i <= 5; ++i) {
                    for (int j = -5; j <= 5; ++j) {
                        for (int k = -10; k <= 10; ++k) {
                            if (!(world.func_147438_o(x + i, y + k, z + j) instanceof IBloodAltar)) continue;
                            this.tileAltar = world.func_147438_o(x + i, y + k, z + j);
                        }
                    }
                }
            }
            if (this.tileAltar == null) {
                return;
            }
            if (currentEssence < effect.getCostPerRefresh() * 100) {
                SoulNetworkHandler.causeNauseaToPlayer((String)owner);
                return;
            }
            ((IBloodAltar)this.tileAltar).sacrificialDaggerCall(100 * RitualEffectWellOfSuffering.amount * (effect.canDrainReagent(event.mrs, ReagentRegistry.offensaReagent, ReflectionHelper.getField(effect, "offensaDrain", 3).intValue(), true) ? 2 : 1) * (effect.canDrainReagent(event.mrs, ReagentRegistry.tenebraeReagent, ReflectionHelper.getField(effect, "tennebraeDrain", 5).intValue(), true) ? 2 : 1), true);
            SoulNetworkHandler.syphonFromNetwork((String)owner, (int)(effect.getCostPerRefresh() * 100));
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        MobRecipeLoader.MobRecipe recipe;
        if (this.getBaseMetaTileEntity().isClientSide()) {
            return false;
        }
        if (aStack == null) {
            return false;
        }
        if (aStack.func_77973_b() != poweredSpawnerItem) {
            return false;
        }
        if (aStack.func_77978_p() == null) {
            return false;
        }
        String mobType = aStack.func_77978_p().func_74779_i("mobType");
        if (mobType.isEmpty()) {
            return false;
        }
        if (mobType.equals("Skeleton") && this.getBaseMetaTileEntity().getWorld().field_73011_w instanceof WorldProviderHell && this.rand.nextInt(5) > 0) {
            mobType = "witherSkeleton";
        }
        if ((recipe = MobNameToRecipeMap.get(mobType)) == null) {
            return false;
        }
        if (!recipe.isPeacefulAllowed && this.getBaseMetaTileEntity().getWorld().field_73013_u == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (this.isInRitualMode && this.isRitualValid()) {
            if (this.getMaxInputVoltage() < (long)(recipe.mEUt / 4)) {
                return false;
            }
            this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"xpjuice", (int)5000)};
            this.mOutputItems = recipe.generateOutputs(this.rand, this, 3.0, 0, this.mIsProducingInfernalDrops);
            this.lEUt /= 4L;
            this.mMaxProgresstime = 400;
        } else {
            ItemStack lootingHolder;
            GT_MetaTileEntity_Hatch_InputBus inputbus;
            long l = this.getMaxInputVoltage();
            recipe.getClass();
            if (l < 2000L) {
                return false;
            }
            double attackDamage = 9.0;
            GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus = inputbus = this.mInputBusses.size() == 0 ? null : (GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0);
            if (inputbus != null && !GT_MetaTileEntity_ExtremeExterminationChamber.isValidMetaTileEntity((MetaTileEntity)inputbus)) {
                inputbus = null;
            }
            ItemStack itemStack = lootingHolder = inputbus == null ? null : inputbus.func_70301_a(0);
            if (!this.weaponCache.isValid || !this.weaponCache.id.equals(lootingHolder)) {
                if (lootingHolder == null || !Enchantment.field_77335_o.func_92089_a(lootingHolder)) {
                    this.weaponCache.isValid = false;
                } else {
                    try {
                        this.weaponCache.attackDamage = lootingHolder.func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).stream().mapToDouble(attr -> attr.func_111164_d() + (double)EnchantmentHelper.func_152377_a((ItemStack)lootingHolder, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)).sum();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.weaponCache.isValid = true;
                    this.weaponCache.looting = Math.min(4, EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)lootingHolder));
                    this.weaponCache.id = ItemID.create_NoCopy(lootingHolder, true, true);
                }
            }
            if (this.weaponCache.isValid) {
                attackDamage += this.weaponCache.attackDamage;
            }
            this.mOutputItems = recipe.generateOutputs(this.rand, this, attackDamage, this.weaponCache.isValid ? this.weaponCache.looting : 0, this.mIsProducingInfernalDrops);
            this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"xpjuice", (int)120)};
            int times = this.calculatePerfectOverclock(this.lEUt, this.mMaxProgresstime);
            if (this.weaponCache.isValid && lootingHolder.func_77984_f()) {
                if (this.EECPlayer == null) {
                    this.EECPlayer = new EECFakePlayer(this);
                }
                this.EECPlayer.currentWeapon = lootingHolder;
                Item lootingHolderItem = lootingHolder.func_77973_b();
                for (int i = 0; i < times + 1 && lootingHolderItem.func_77644_a(lootingHolder, (EntityLivingBase)recipe.entity, (EntityLivingBase)this.EECPlayer); ++i) {
                    if (lootingHolder.field_77994_a != 0) continue;
                    inputbus.func_70299_a(0, null);
                    break;
                }
                this.EECPlayer.currentWeapon = null;
            }
        }
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mobPacket == null) {
            this.mobPacket = new CustomTileEntityPacket((TileEntity)this.getBaseMetaTileEntity(), null);
        }
        this.mobPacket.resetHelperData();
        this.mobPacket.addData(this.mAnimationEnabled);
        if (this.mAnimationEnabled) {
            this.mobPacket.addData(mobType);
        }
        this.mobPacket.sendToAllAround(16);
        this.updateSlots();
        return true;
    }

    private boolean isRitualValid() {
        if (!this.isInRitualMode) {
            return false;
        }
        if (this.masterStoneRitual == null) {
            return false;
        }
        if (this.masterStoneRitual.func_145837_r() || !((TEMasterStone)this.masterStoneRitual).getCurrentRitual().equals(WellOfSufferingRitualName)) {
            this.masterStoneRitual = null;
            return false;
        }
        return true;
    }

    private boolean connectToRitual() {
        if (!LoaderReference.BloodMagic) {
            return false;
        }
        ChunkCoordinates coords = this.getBaseMetaTileEntity().getCoords();
        int[] abc = new int[]{0, -8, 2};
        int[] xyz = new int[]{0, 0, 0};
        this.getExtendedFacing().getWorldOffset(abc, xyz);
        xyz[0] = xyz[0] + coords.field_71574_a;
        xyz[1] = xyz[1] + coords.field_71572_b;
        xyz[2] = xyz[2] + coords.field_71573_c;
        TileEntity te = this.getBaseMetaTileEntity().getTileEntity(xyz[0], xyz[1], xyz[2]);
        if (te instanceof TEMasterStone && ((TEMasterStone)te).getCurrentRitual().equals(WellOfSufferingRitualName)) {
            this.masterStoneRitual = te;
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mGlassTier = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 6, 0)) {
            return false;
        }
        if (this.mCasing < 10 || this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.size() == 0 || this.mInputBusses.size() != 0 && (this.mInputBusses.size() != 1 || ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get((int)0)).mTier != 0)) {
            return false;
        }
        if (this.mGlassTier < 8) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mEnergyHatches) {
                if (hatch.mTier <= this.mGlassTier) continue;
                return false;
            }
        }
        if (this.isInRitualMode) {
            this.connectToRitual();
        }
        return true;
    }

    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Animations: " + EnumChatFormatting.YELLOW + (this.mAnimationEnabled ? "Enabled" : "Disabled"));
        info.add("Is allowed to produce infernal drops: " + EnumChatFormatting.YELLOW + (this.mIsProducingInfernalDrops ? "Yes" : "No"));
        info.add("Is in ritual mode: " + EnumChatFormatting.YELLOW + (this.isInRitualMode ? "Yes" : "No"));
        if (this.isInRitualMode) {
            info.add("Is connected to ritual: " + (this.isRitualValid() ? EnumChatFormatting.GREEN + "Yes" : EnumChatFormatting.RED + "No"));
        } else {
            info.add("Inserted weapon: " + EnumChatFormatting.YELLOW + (this.weaponCache.isValid ? "Yes" : "No"));
            if (this.weaponCache.isValid) {
                info.add("Weapon attack damage: " + EnumChatFormatting.YELLOW + this.weaponCache.attackDamage);
                info.add("Weapon looting level: " + EnumChatFormatting.YELLOW + this.weaponCache.looting);
                info.add("Total attack damage: " + EnumChatFormatting.YELLOW + (9.0 + this.weaponCache.attackDamage));
            } else {
                info.add("Total attack damage: " + EnumChatFormatting.YELLOW + 9.0);
            }
        }
        return info.toArray(new String[0]);
    }

    public boolean useModularUI() {
        return true;
    }

    public int getGUIHeight() {
        return 166;
    }

    public int getGUIWidth() {
        return 176;
    }

    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.bindPlayerInventory(buildContext.getPlayer(), new Pos2d(7, 83), (IDrawable)this.getGUITextureSet().getItemSlot());
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(143, 75).setEnabled(widget -> (Boolean)this.isFixed.apply(widget) == false));
        SlotWidget inventorySlot = new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setFilter(stack -> stack.func_77973_b() == poweredSpawnerItem);
        DynamicPositionedColumn configurationElements = new DynamicPositionedColumn();
        this.addConfigurationWidgets(configurationElements, buildContext, inventorySlot);
        builder.widget(((Column)((Column)((Column)((Column)new DynamicPositionedColumn().setSynced(false).widget((Widget)inventorySlot)).widget(new CycleButtonWidget().setToggle(() -> this.getBaseMetaTileEntity().isAllowedToWork(), works -> {
            if (works.booleanValue()) {
                this.getBaseMetaTileEntity().enableWorking();
            } else {
                this.getBaseMetaTileEntity().disableWorking();
            }
            if (!(buildContext.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            String tChat = GT_Utility.trans((String)"090", (String)"Machine Processing: ") + (works != false ? GT_Utility.trans((String)"088", (String)"Enabled") : GT_Utility.trans((String)"087", (String)"Disabled"));
            if (this.hasAlternativeModeText()) {
                tChat = this.getAlternativeModeText();
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)tChat);
        }).addTooltip(0, new Text("Disabled").color(Color.RED.dark(3))).addTooltip(1, new Text("Enabled").color(Color.GREEN.dark(3))).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(18, 18).addTooltip("Working status"))).widget(configurationElements.setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CROSS).setSize(18, 18).addTooltip(new Text("Please stop the machine to configure it").color(Color.RED.dark(3))).setEnabled(widget -> this.getBaseMetaTileEntity().isActive()))).setPos(151, 4));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, inventorySlot);
        builder.widget((Widget)screenElements);
    }

    private void addConfigurationWidgets(DynamicPositionedColumn configurationElements, UIBuildContext buildContext, SlotWidget inventorySlot) {
        configurationElements.setSynced(false);
        configurationElements.widget(new CycleButtonWidget().setToggle(() -> this.isInRitualMode, v -> {
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Can't change mode when running !");
                return;
            }
            this.isInRitualMode = v;
            if (!(buildContext.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.isInRitualMode) {
                GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Ritual mode disabled");
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Ritual mode enabled");
                if (this.connectToRitual()) {
                    GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Successfully connected to the ritual");
                } else {
                    GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Can't connect to the ritual");
                }
            }
        }).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(18, 18).addTooltip("Ritual mode"));
        configurationElements.widget(new CycleButtonWidget().setToggle(() -> this.mIsProducingInfernalDrops, v -> {
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Can't change mode when running !");
                return;
            }
            this.mIsProducingInfernalDrops = v;
            if (!(buildContext.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.mIsProducingInfernalDrops) {
                GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Mobs will now be prevented from spawning infernal");
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)buildContext.getPlayer(), (String)"Mobs can spawn infernal now");
            }
        }).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(18, 18).addTooltip("Is allowed to spawn infernal mobs").addTooltip(new Text("Does not affect mobs that are always infernal !").color(Color.GRAY.normal)));
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0).setPos(10, 7);
        screenElements.widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget((Widget)new TextWidget("Status: ").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()))).widget((Widget)new DynamicTextWidget(() -> {
            if (this.getBaseMetaTileEntity().isActive()) {
                return new Text("Working !").color(Color.GREEN.dark(3));
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                return new Text("Enabled").color(Color.GREEN.dark(3));
            }
            if (this.getBaseMetaTileEntity().wasShutdown()) {
                return new Text("Shutdown (CRITICAL)").color(Color.RED.dark(3));
            }
            return new Text("Disabled").color(Color.RED.dark(3));
        }))).setEnabled(this.isFixed));
        screenElements.widget(new DynamicTextWidget(() -> {
            ItemStack aStack = this.mInventory[1];
            if (aStack == null) {
                return new Text("Insert Powered Spawner").color(Color.RED.dark(3));
            }
            Text invalid = new Text("Invalid Spawner").color(Color.RED.dark(3));
            if (aStack.func_77973_b() != poweredSpawnerItem) {
                return invalid;
            }
            if (aStack.func_77978_p() == null) {
                return invalid;
            }
            String mobType = aStack.func_77978_p().func_74779_i("mobType");
            if (mobType.isEmpty()) {
                return invalid;
            }
            if (!MobNameToRecipeMap.containsKey(mobType)) {
                return invalid;
            }
            return new Text(StatCollector.func_74838_a((String)("entity." + mobType + ".name"))).color(Color.GREEN.dark(3));
        }).setEnabled(this.isFixed));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"132", (String)"Pipe is loose.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mWrench))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"133", (String)"Screws are loose.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mScrewdriver))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"134", (String)"Something is stuck.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSoftHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftHammer, val -> {
            this.mSoftHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"135", (String)"Platings are dented.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mHardHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"136", (String)"Circuitry burned out.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSolderingTool))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"137", (String)"That doesn't belong there.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mCrowbar))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"138", (String)"Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
    }

    private static class EECFakePlayer
    extends FakePlayer {
        GT_MetaTileEntity_ExtremeExterminationChamber mte;
        ItemStack currentWeapon;

        public EECFakePlayer(GT_MetaTileEntity_ExtremeExterminationChamber mte) {
            super((WorldServer)mte.getBaseMetaTileEntity().getWorld(), new GameProfile(UUID.nameUUIDFromBytes("[EEC Fake Player]".getBytes(StandardCharsets.UTF_8)), "[EEC Fake Player]"));
            this.mte = mte;
        }

        public void func_70669_a(ItemStack p_70669_1_) {
        }

        public Random func_70681_au() {
            return this.mte.rand;
        }

        public void func_71028_bD() {
        }

        public ItemStack func_71045_bC() {
            return this.currentWeapon;
        }
    }

    private static class WeaponCache {
        boolean isValid = false;
        ItemID id = null;
        int looting = 0;
        double attackDamage = 0.0;

        private WeaponCache() {
        }
    }
}

