/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.ChangeableWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockApicultureType;
import forestry.apiculture.genetics.Bee;
import forestry.plugins.PluginApiculture;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kubatech.api.LoaderReference;
import kubatech.api.Variables;
import kubatech.api.helpers.GTHelper;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.client.effect.MegaApiaryBeesRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class GT_MetaTileEntity_MegaIndustrialApiary
extends KubaTechGTMultiBlockBase<GT_MetaTileEntity_MegaIndustrialApiary>
implements ISurvivalConstructable {
    private byte mGlassTier = 0;
    private int mCasing = 0;
    private int mMaxSlots = 0;
    private int mPrimaryMode = 0;
    private int mSecondaryMode = 0;
    private final ArrayList<BeeSimulator> mStorage = new ArrayList();
    private static final ItemStack royalJelly = PluginApiculture.items.royalJelly.getItemStack(1);
    private static final int CASING_INDEX = 10;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "mainsurvival";
    private static final int CONFIGURATION_WINDOW_ID = 999;
    private static final int MEGA_APIARY_STORAGE_VERSION = 1;
    private static final String[][] struct = StructureUtility.transpose((String[][])new String[][]{{"               ", "               ", "               ", "      HHH      ", "    HHAAAHH    ", "    HAPLPAH    ", "   HAPAAAPAH   ", "   HALAAALAH   ", "   HAPAAAPAH   ", "    HAPLPAH    ", "    HHAAAHH    ", "      HHH      ", "               ", "               ", "               "}, {"               ", "               ", "      GGG      ", "   GGG   GG    ", "   G       G   ", "   G       G   ", "  G         G  ", "  G         G  ", "  G         G  ", "   G       G   ", "   G       G   ", "    GG   GG    ", "      GGG      ", "               ", "               "}, {"               ", "      HHH      ", "   HHH   HHH   ", "  H        GH  ", "  H         H  ", "  H         H  ", " H           H ", " H           H ", " H           H ", "  H         H  ", "  H         H  ", "  HG       GH  ", "   HHH   HHH   ", "      HHH      ", "               "}, {"      GGG      ", "   GGG   GGG   ", "  G         G  ", " G           G ", " G           G ", " G           G ", "G             G", "G             G", "G             G", " G           G ", " G           G ", " G           G ", "  G         G  ", "   GGG   GGG   ", "      GGG      "}, {"      AAA      ", "   OLA   ALO   ", "  P         P  ", " O           O ", " L           L ", " A           A ", "A             A", "A             A", "A             A", " A           A ", " L           L ", " O           O ", "  P         P  ", "   OLA   ALO   ", "      AAA      "}, {"     AAAAA     ", "   NA     AO   ", "  P         P  ", " N           O ", " A           A ", "A             A", "A     III     A", "A     III     A", "A     III     A", "A             A", " A           A ", " N           N ", "  P         P  ", "   NA     AN   ", "     AAAAA     "}, {"     AAAAA     ", "   NA FFF AO   ", "  PFF     FFP  ", " NF        FFO ", " AF         FA ", "A             A", "AF    JJJ    FA", "AF    JKJ    FA", "AF    JJJ    FA", "A             A", " AF         FA ", " NFF       FFN ", "  PFF     FFP  ", "   NA FFF AN   ", "     AAAAA     "}, {"      AAA      ", "   OLAFFFALO   ", "  PFFFFFFFFFP  ", " OFFFF   FFFFO ", " LFF       FFL ", " AFF FFFFF  FA ", "AFF  FKKKFF FFA", "AFF FFKKKFF FFA", "AFF FFKKKF  FFA", " AF  FFFFF  FA ", " LFF   FF  FFL ", " OFFFF    FFFO ", "  PFFFFFFFFFP  ", "   OLAFFFALO   ", "      AAA      "}, {"      G~G      ", "   GGGBBBGGG   ", "  GBBFFFFFBBG  ", " GBFFF   FFBBG ", " GBF       FBG ", " GFF FFFFF  FG ", "GBF  FKKKFF FBG", "GBF FFKJKFF FBG", "GBF FFKKKF  FBG", " GF  FFFFF  FG ", " GBF   FF  FBG ", " GBBFF    FBBG ", "  GBBFFFFFBBG  ", "   GGGBBBGGG   ", "      GGG      "}, {"      HHH      ", "    HHBBBHH    ", "  HHBBBBBBBHH  ", "  HBBBWWWBBBH  ", " HBBWWWWWWWBBH ", " HBBWBBBBBWWBH ", "HBBWWBBBBBBWBBH", "HBBWBBBBBBBWBBH", "HBBWBBBBBBWWBBH", " HBWWBBBBBWWBH ", " HBBWWWBBWWBBH ", "  HBBBWWWWBBH  ", "  HHBBBBBBBHH  ", "    HHBBBHH    ", "      HHH      "}, {"               ", "     GGGGG     ", "   GGGBBBBGG   ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", " GBBBBBBBBBBBG ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", "   GGBBBBBGG   ", "     GGGGG     ", "               "}, {"               ", "      HHH      ", "    HHBBBHH    ", "   HBBBBBBBH   ", "  HBBBBBBBBBH  ", "  HBBBBBBBBBH  ", " HBBBBBBBBBBBH ", " HBBBBBBBBBBBH ", " HBBBBBBBBBBBH ", "  HBBBBBBBBBH  ", "  HBBBBBBBBBH  ", "   HBBBBBBBH   ", "    HHBBBHH    ", "      HHH      ", "               "}, {"               ", "               ", "      GGG      ", "    GGBBBGG    ", "   GBBBBBBBG   ", "   GBBBBBBBG   ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", "  GBBBBBBBBBG  ", "   GBBBBBBBG   ", "   GBBBBBBBG   ", "    GGBBBGG    ", "      GGG      ", "               ", "               "}, {"               ", "               ", "       H       ", "     HHBHH     ", "    HBBBBBH    ", "   HBBBBBBBH   ", "   HBBBBBBBH   ", "  HBBBBBBBBBH  ", "   HBBBBBBBH   ", "   HBBBBBBBH   ", "    HBBBBBH    ", "     HHBHH     ", "       H       ", "               ", "               "}, {"               ", "               ", "               ", "       G       ", "     GGBGG     ", "    GBBBBBG    ", "    GBBBBBG    ", "   GBBBBBBBG   ", "    GBBBBBG    ", "    GBBBBBG    ", "     GGBGG     ", "       G       ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "      HHH      ", "     HHHHH     ", "    HHBBBHH    ", "    HHBBBHH    ", "    HHBBBHH    ", "     HHBHH     ", "      HHH      ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "      GGG      ", "      GHG      ", "      GGG      ", "               ", "               ", "               ", "               ", "               ", "               "}});
    private static final IStructureDefinition<GT_MetaTileEntity_MegaIndustrialApiary> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", struct).addShape("mainsurvival", (String[][])Arrays.stream(struct).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("W", " ").replaceAll("F", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('A', LoaderReference.Bartworks ? BorosilicateGlass.ofBoroGlass((byte)0, (t, v) -> {
        t.mGlassTier = v;
    }, t -> t.mGlassTier) : StructureUtility.onElementPass(t -> {
        t.mGlassTier = (byte)100;
    }, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150359_w, (int)0))).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150346_d, (int)0), StructureUtility.ofBlock((Block)Blocks.field_150349_c, (int)0)})).addElement('G', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_MegaIndustrialApiary.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Energy, GT_HatchElement.Maintenance}).casingIndex(10).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)10))})).addElement('H', StructureUtility.ofBlocksMap(Collections.singletonMap(Blocks.field_150344_f, IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList())), (Block)Blocks.field_150344_f, (int)5)).addElement('I', StructureUtility.ofBlocksMap(Collections.singletonMap(Blocks.field_150376_bx, IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList())), (Block)Blocks.field_150376_bx, (int)5)).addElement('J', StructureUtility.ofBlock((Block)PluginApiculture.blocks.apiculture, (int)BlockApicultureType.APIARY.getMeta())).addElement('K', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.PLAIN.ordinal())).addElement('L', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.HYGRO.ordinal())).addElement('N', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.STABILIZER.ordinal())).addElement('O', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.HEATER.ordinal())).addElement('P', StructureUtility.ofBlock((Block)PluginApiculture.blocks.alveary, (int)BlockAlveary.Type.FAN.ordinal())).addElement('W', StructureUtility.ofBlock((Block)Blocks.field_150355_j, (int)0)).addElement('F', (IStructureElement)new IStructureElementNoPlacement<GT_MetaTileEntity_MegaIndustrialApiary>(){

        public boolean check(GT_MetaTileEntity_MegaIndustrialApiary mte, World world, int x, int y, int z) {
            mte.flowerCheck(world, x, y, z);
            return true;
        }

        public boolean spawnHint(GT_MetaTileEntity_MegaIndustrialApiary mte, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)1);
            return true;
        }
    }).build();
    private boolean isCacheDirty = true;
    private final HashSet<String> flowersCache = new HashSet();
    private final HashSet<String> flowersCheck = new HashSet();
    private boolean flowersError = false;
    private boolean needsTVarUpdate = false;
    private int megaApiaryStorageVersion = 0;
    private static final UIInfo<?, ?> MegaApiaryUI = GT_MetaTileEntity_MegaIndustrialApiary.createKTMetaTileEntityUI(KT_ModulaUIContainer_MegaIndustrialApiary::new);
    private final List<ItemStack> drawables = new ArrayList<ItemStack>(this.mMaxSlots);

    public GT_MetaTileEntity_MegaIndustrialApiary(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_MegaIndustrialApiary(String aName) {
        super(aName);
    }

    private void flowerCheck(World world, int x, int y, int z) {
        if (!this.flowersCheck.isEmpty() && !world.func_147437_c(x, y, z)) {
            this.flowersCheck.removeIf(s -> FlowerManager.flowerRegistry.isAcceptedFlower(s, world, x, y, z));
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 8, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 7, 8, 0, elementBudget, env, true);
        if (built == -1) {
            GT_Utility.sendChatToPlayer((EntityPlayer)env.getActor(), (String)(EnumChatFormatting.GREEN + "Auto placing done ! Now go place the water and flowers yourself !"));
            return 0;
        }
        return built;
    }

    public IStructureDefinition<GT_MetaTileEntity_MegaIndustrialApiary> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated();
    }

    private String voltageFormatted(int v) {
        return GT_Values.TIER_COLORS[v] + GT_Values.VN[v] + EnumChatFormatting.GRAY;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Apiary").addInfo("Controller block for Industrial Apicultural Acclimatiser and Drone Domestication Station").addInfo(Variables.buildAuthorList("kuba6000", "Runakai")).addInfo("The ideal home for your bees").addInfo("AKA. Mega Apiary").addInfo("Use screwdriver to change primary mode (INPUT/OUTPUT/OPERATING)").addInfo("Use screwdriver + shift to change operation mode (NORMAL/SWARMER)").addInfo("--------------------- INPUT MODE ---------------------").addInfo("- Does not take power").addInfo("- Put your queens in the input bus to put them in the internal buffer").addInfo("-------------------- OUTPUT MODE ---------------------").addInfo("- Does not take power").addInfo("- Will give your bees back to output bus").addInfo("------------------- OPERATING MODE -------------------").addInfo("- NORMAL:").addInfo("  - For each " + this.voltageFormatted(6) + " amp you can insert 1 bee").addInfo("  - Processing time: 5 seconds").addInfo("  - Uses 1 " + this.voltageFormatted(6) + " amp per queen").addInfo("  - All bees are accelerated 64 times").addInfo("  - 8 production upgrades are applied").addInfo("  - Genetic Stabilizer upgrade applied").addInfo("  - Simulates perfect environment for your bees").addInfo("  - Additionally you can provide royal jelly to increase the outputs:").addInfo("    - 1 royal jelly grants 5% bonus per bee").addInfo("    - They will be consumed on each start of operation").addInfo("    - and be applied to that operation only").addInfo("    - Max bonus: 200%").addInfo("- SWARMER:").addInfo("  - You can only insert 1 queen").addInfo("  - It will slowly produce ignoble princesses").addInfo("  - Consumes 100 royal jelly per operation").addInfo("  - Base processing time: 1 minute").addInfo("  - Uses 1 amp " + this.voltageFormatted(5)).addInfo("  - Can overclock").addInfo(Variables.StructureHologram).addSeparator().beginStructureBlock(15, 17, 15, false).addController("Front Bottom Center").addCasingInfoMin("Bronze Plated Bricks", 190, false).addOtherStructurePart("Borosilicate Glass", "Look at the hologram").addStructureInfo("The glass tier limits the Energy Input tier").addOtherStructurePart("Flowers", "On dirt/grass", new int[]{2}).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).toolTipFinisher("KubaTech");
        return tt;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mGlassTier", this.mGlassTier);
        aNBT.func_74768_a("mPrimaryMode", this.mPrimaryMode);
        aNBT.func_74768_a("mSecondaryMode", this.mSecondaryMode);
        aNBT.func_74768_a("mStorageSize", this.mStorage.size());
        for (int i = 0; i < this.mStorage.size(); ++i) {
            aNBT.func_74782_a("mStorage." + i, (NBTBase)this.mStorage.get(i).toNBTTagCompound());
        }
        aNBT.func_74768_a("MEGA_APIARY_STORAGE_VERSION", 1);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mGlassTier = aNBT.func_74771_c("mGlassTier");
        this.mPrimaryMode = aNBT.func_74762_e("mPrimaryMode");
        this.mSecondaryMode = aNBT.func_74762_e("mSecondaryMode");
        int isize = aNBT.func_74762_e("mStorageSize");
        for (int i = 0; i < isize; ++i) {
            this.mStorage.add(new BeeSimulator(aNBT.func_74775_l("mStorage." + i)));
        }
        this.megaApiaryStorageVersion = aNBT.func_74762_e("MEGA_APIARY_STORAGE_VERSION");
        this.flowersCache.clear();
        this.mStorage.forEach(s -> this.flowersCache.add(s.flowerType));
        this.flowersCache.remove("");
        this.isCacheDirty = false;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Can't change mode when running !");
            return;
        }
        if (!aPlayer.func_70093_af()) {
            ++this.mPrimaryMode;
            if (this.mPrimaryMode == 3) {
                this.mPrimaryMode = 0;
            }
            switch (this.mPrimaryMode) {
                case 0: {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Changed primary mode to: Input mode");
                    break;
                }
                case 1: {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Changed primary mode to: Output mode");
                    break;
                }
                case 2: {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Changed primary mode to: Operating mode");
                }
            }
        } else {
            if (!this.mStorage.isEmpty()) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Can't change operating mode when the multi is not empty !");
                return;
            }
            ++this.mSecondaryMode;
            if (this.mSecondaryMode == 2) {
                this.mSecondaryMode = 0;
            }
            switch (this.mSecondaryMode) {
                case 0: {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Changed secondary mode to: Normal mode");
                    break;
                }
                case 1: {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Changed secondary mode to: Swarmer mode");
                }
            }
        }
    }

    private void updateMaxSlots() {
        int mOld = this.mMaxSlots;
        long v = this.getMaxInputEu();
        this.mMaxSlots = v < GT_Values.V[6] ? 0 : (this.mSecondaryMode == 0 ? (int)(v / GT_Values.V[6]) : 1);
        if (mOld != 0 && mOld != this.mMaxSlots) {
            this.needsTVarUpdate = true;
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdate < 0) {
                this.mUpdate = 600;
            }
        } else if (aBaseMetaTileEntity.isActive() && aTick % 100L == 0L) {
            int[] abc = new int[]{0, -2, 7};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + aBaseMetaTileEntity.getXCoord();
            xyz[1] = xyz[1] + aBaseMetaTileEntity.getYCoord();
            xyz[2] = xyz[2] + aBaseMetaTileEntity.getZCoord();
            this.showBees(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], 100);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showBees(World world, int x, int y, int z, int age) {
        MegaApiaryBeesRenderer bee = new MegaApiaryBeesRenderer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)bee);
    }

    public boolean checkRecipe(ItemStack aStack) {
        this.updateMaxSlots();
        if (this.mPrimaryMode < 2) {
            if (this.mPrimaryMode == 0 && this.mStorage.size() < this.mMaxSlots) {
                World w = this.getBaseMetaTileEntity().getWorld();
                float t = (float)GTHelper.getVoltageTierD((GT_MetaTileEntity_MultiBlockBase)this);
                ArrayList inputs = this.getStoredInputs();
                for (ItemStack input : inputs) {
                    if (BeeManager.beeRoot.getType(input) == EnumBeeType.QUEEN) {
                        BeeSimulator bs = new BeeSimulator(input, w, t);
                        if (bs.isValid) {
                            this.mStorage.add(bs);
                            this.isCacheDirty = true;
                        }
                    }
                    if (this.mStorage.size() < this.mMaxSlots) continue;
                    break;
                }
                this.updateSlots();
            } else if (this.mPrimaryMode == 1 && this.mStorage.size() > 0) {
                int imax = Math.min(10, this.mStorage.size());
                for (int i = 0; i < imax; ++i) {
                    this.addOutput(this.mStorage.get((int)0).queenStack);
                    this.mStorage.remove(0);
                    this.isCacheDirty = true;
                }
            } else {
                return false;
            }
            this.mMaxProgresstime = 10;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.lEUt = 0L;
            return true;
        }
        if (this.mPrimaryMode == 2 && this.mMaxSlots > 0 && !this.mStorage.isEmpty()) {
            if (this.mSecondaryMode == 0) {
                int maxConsume;
                if (this.megaApiaryStorageVersion != 1) {
                    this.megaApiaryStorageVersion = 1;
                    World w = this.getBaseMetaTileEntity().getWorld();
                    float t = (float)GTHelper.getVoltageTierD((GT_MetaTileEntity_MultiBlockBase)this);
                    this.mStorage.forEach(s -> s.generate(w, t));
                }
                if (this.mStorage.size() > this.mMaxSlots) {
                    return false;
                }
                if (this.flowersError) {
                    return false;
                }
                if (this.needsTVarUpdate) {
                    float t = (float)GTHelper.getVoltageTierD((GT_MetaTileEntity_MultiBlockBase)this);
                    this.needsTVarUpdate = false;
                    this.mStorage.forEach(s -> s.updateTVar(t));
                }
                int toConsume = maxConsume = Math.min(this.mStorage.size(), this.mMaxSlots) * 40;
                ArrayList inputs = this.getStoredInputs();
                for (ItemStack input : inputs) {
                    if (!input.func_77969_a(royalJelly)) continue;
                    int consumed = Math.min(input.field_77994_a, toConsume);
                    input.field_77994_a -= consumed;
                    if ((toConsume -= consumed) != 0) continue;
                    break;
                }
                double boosted = 1.0;
                if (toConsume != maxConsume) {
                    boosted += ((double)maxConsume - (double)toConsume) / (double)maxConsume * 2.0;
                    this.updateSlots();
                }
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                int mStorageSize = Math.min(this.mStorage.size(), this.mMaxSlots);
                for (int i = 0; i < mStorageSize; ++i) {
                    BeeSimulator beeSimulator = this.mStorage.get(i);
                    stacks.addAll(beeSimulator.getDrops(6400.0 * boosted));
                }
                this.lEUt = -((int)((double)GT_Values.V[6] * (double)this.mMaxSlots * 0.99));
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.mMaxProgresstime = 100;
                this.mOutputItems = stacks.toArray(new ItemStack[0]);
            } else {
                if (!this.depleteInput(PluginApiculture.items.royalJelly.getItemStack(64)) || !this.depleteInput(PluginApiculture.items.royalJelly.getItemStack(36))) {
                    this.updateSlots();
                    return false;
                }
                this.calculateOverclock(GT_Values.V[5] - 2L, 1200);
                if (this.lEUt > 0L) {
                    this.lEUt = -this.lEUt;
                }
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.mOutputItems = new ItemStack[]{this.mStorage.get(0).createIgnobleCopy()};
                this.updateSlots();
            }
            return true;
        }
        return false;
    }

    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Running in mode: " + EnumChatFormatting.GOLD + (this.mPrimaryMode == 0 ? "Input mode" : (this.mPrimaryMode == 1 ? "Output mode" : (this.mSecondaryMode == 0 ? "Operating mode (NORMAL)" : "Operating mode (SWARMER)"))));
        info.add("Bee storage (" + EnumChatFormatting.GOLD + this.mStorage.size() + EnumChatFormatting.RESET + "/" + (this.mStorage.size() > this.mMaxSlots ? EnumChatFormatting.DARK_RED.toString() : EnumChatFormatting.GOLD.toString()) + this.mMaxSlots + EnumChatFormatting.RESET + "):");
        HashMap<String, Integer> infos = new HashMap<String, Integer>();
        for (int i = 0; i < this.mStorage.size(); ++i) {
            StringBuilder builder = new StringBuilder();
            if (i > this.mMaxSlots) {
                builder.append(EnumChatFormatting.DARK_RED);
            }
            builder.append(EnumChatFormatting.GOLD);
            builder.append(this.mStorage.get((int)i).queenStack.func_82833_r());
            infos.merge(builder.toString(), 1, Integer::sum);
        }
        infos.forEach((key, value) -> info.add("x" + value + ": " + key));
        return info.toArray(new String[0]);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mGlassTier = 0;
        this.mCasing = 0;
        if (this.isCacheDirty) {
            this.flowersCache.clear();
            this.mStorage.forEach(s -> this.flowersCache.add(s.flowerType));
            this.flowersCache.remove("");
            this.isCacheDirty = false;
        }
        this.flowersCheck.addAll(this.flowersCache);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 8, 0)) {
            return false;
        }
        if (this.mGlassTier < 10 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.mGlassTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        boolean valid = this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() >= 1 && this.mCasing >= 190;
        boolean bl = this.flowersError = valid && !this.flowersCheck.isEmpty();
        if (valid) {
            this.updateMaxSlots();
        }
        return valid;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MegaIndustrialApiary(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10)};
    }

    public boolean useModularUI() {
        return true;
    }

    public int getGUIHeight() {
        return 166;
    }

    public int getGUIWidth() {
        return 176;
    }

    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.bindPlayerInventory(buildContext.getPlayer(), new Pos2d(7, 83), (IDrawable)this.getGUITextureSet().getItemSlot());
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        MegaApiaryUI.open(aPlayer, aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(143, 75).setEnabled(widget -> (Boolean)this.isFixed.apply(widget) == false));
        buildContext.addSyncedWindow(999, this::createConfigurationWindow);
        EntityPlayer player = buildContext.getPlayer();
        builder.widget(((Column)((Column)new DynamicPositionedColumn().setSynced(false).widget(new CycleButtonWidget().setToggle(() -> this.getBaseMetaTileEntity().isAllowedToWork(), works -> {
            if (works.booleanValue()) {
                this.getBaseMetaTileEntity().enableWorking();
            } else {
                this.getBaseMetaTileEntity().disableWorking();
            }
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            String tChat = GT_Utility.trans((String)"090", (String)"Machine Processing: ") + (works != false ? GT_Utility.trans((String)"088", (String)"Enabled") : GT_Utility.trans((String)"087", (String)"Disabled"));
            if (this.hasAlternativeModeText()) {
                tChat = this.getAlternativeModeText();
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)tChat);
        }).addTooltip(0, new Text("Disabled").color(Color.RED.dark(3))).addTooltip(1, new Text("Enabled").color(Color.GREEN.dark(3))).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(18, 18).addTooltip("Working status"))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(999);
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_CYCLIC}).addTooltip("Configuration").setSize(18, 18))).setPos(151, 4));
        ChangeableWidget beesContainer = new ChangeableWidget(() -> this.createBeesContainerWidget(player));
        AtomicInteger lastMaxSlots = new AtomicInteger();
        builder.widget(beesContainer.attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> {
            if (lastMaxSlots.get() != this.mMaxSlots) {
                lastMaxSlots.set(this.mMaxSlots);
                beesContainer.notifyChangeNoSync();
            }
            return this.mMaxSlots;
        }, i -> {
            if (this.mMaxSlots != i) {
                this.mMaxSlots = i;
                beesContainer.notifyChangeNoSync();
            }
        }), (IWidgetBuilder)builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.ListSyncer(() -> this.mStorage.stream().map(s -> s.queenStack).collect(Collectors.toList()), l -> {
            this.drawables.clear();
            this.drawables.addAll((Collection<ItemStack>)l);
            if (beesContainer.getChildren().size() > 0) {
                IWidgetParent.forEachByLayer((IWidgetParent)((IWidgetParent)beesContainer.getChildren().get(0)), Widget::notifyTooltipChange);
            }
        }, (buffer, i) -> {
            try {
                buffer.func_150788_a(i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, buffer -> {
            try {
                return buffer.func_150791_c();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }), (IWidgetBuilder)builder));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, null);
        builder.widget((Widget)screenElements);
    }

    private Widget createBeesContainerWidget(EntityPlayer player) {
        Scrollable beesContainer = new Scrollable().setVerticalScroll();
        int perRow = 7;
        if (this.mMaxSlots > 0) {
            int imax = (this.mMaxSlots - 1) / 7;
            for (int i = 0; i <= imax; ++i) {
                int jmax;
                DynamicPositionedRow row = new DynamicPositionedRow().setSynced(false);
                int j = 0;
                int n = jmax = i == imax ? (this.mMaxSlots - 1) % 7 : 6;
                while (j <= jmax) {
                    int finalI = i * 7;
                    int finalJ = j++;
                    int ID = finalI + finalJ;
                    row.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                        ItemStack input;
                        if (!(player instanceof EntityPlayerMP)) {
                            return;
                        }
                        if (!clickData.shift && (input = player.field_71071_by.func_70445_o()) != null) {
                            if (this.mMaxProgresstime > 0) {
                                GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Can't replace/insert while running !"));
                                return;
                            }
                            if (BeeManager.beeRoot.getType(input) == EnumBeeType.QUEEN) {
                                World w = this.getBaseMetaTileEntity().getWorld();
                                float t = (float)GTHelper.getVoltageTierD((GT_MetaTileEntity_MultiBlockBase)this);
                                BeeSimulator bs = new BeeSimulator(input, w, t);
                                if (bs.isValid) {
                                    if (this.mStorage.size() > ID) {
                                        BeeSimulator removed = this.mStorage.remove(ID);
                                        this.mStorage.add(ID, bs);
                                        player.field_71071_by.func_70437_b(removed.queenStack);
                                    } else {
                                        this.mStorage.add(bs);
                                        player.field_71071_by.func_70437_b(null);
                                    }
                                    ((EntityPlayerMP)player).field_71137_h = false;
                                    ((EntityPlayerMP)player).func_71113_k();
                                    this.isCacheDirty = true;
                                }
                            }
                            return;
                        }
                        if (this.mStorage.size() <= ID) {
                            return;
                        }
                        if (this.mMaxProgresstime > 0) {
                            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Can't eject while running !"));
                            return;
                        }
                        BeeSimulator removed = this.mStorage.remove(ID);
                        this.isCacheDirty = true;
                        if (clickData.shift && player.field_71071_by.func_70441_a(removed.queenStack)) {
                            player.field_71069_bz.func_75142_b();
                            return;
                        }
                        if (clickData.mouseButton == 1 && player.field_71071_by.func_70445_o() == null) {
                            player.field_71071_by.func_70437_b(removed.queenStack);
                            ((EntityPlayerMP)player).field_71137_h = false;
                            ((EntityPlayerMP)player).func_71113_k();
                            return;
                        }
                        this.addOutput(removed.queenStack);
                        GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"Queen ejected !");
                    }).setBackground(() -> new IDrawable[]{this.getBaseMetaTileEntity().getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_BEE_QUEEN, new ItemDrawable(this.drawables.size() > ID ? this.drawables.get(ID) : null).withFixedSize(16.0f, 16.0f, 1.0f, 1.0f)}).dynamicTooltip(() -> {
                        if (this.drawables.size() > ID) {
                            return Arrays.asList(this.drawables.get(ID).func_82833_r(), EnumChatFormatting.GRAY + "Left click to eject into input bus", EnumChatFormatting.GRAY + "Right click to get into mouse", EnumChatFormatting.GRAY + "Shift click to get into inventory", EnumChatFormatting.GRAY + "Click with other queen in mouse to replace");
                        }
                        return Collections.singletonList(EnumChatFormatting.GRAY + "Click with queen in mouse to insert");
                    }).setSize(18, 18));
                }
                beesContainer.widget(row.setPos(0, i * 18));
            }
        }
        beesContainer.setPos(10, 16).setSize(128, 60);
        return beesContainer;
    }

    /*
     * Exception decompiling
     */
    protected ModularWindow createConfigurationWindow(EntityPlayer player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0).setPos(10, 7);
        screenElements.widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget((Widget)new TextWidget("Status: ").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()))).widget((Widget)new DynamicTextWidget(() -> {
            if (this.flowersError) {
                return new Text("No flowers !").color(Color.RED.dark(3));
            }
            if (this.getBaseMetaTileEntity().isActive()) {
                return new Text("Working !").color(Color.GREEN.dark(3));
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                return new Text("Enabled").color(Color.GREEN.dark(3));
            }
            if (this.getBaseMetaTileEntity().wasShutdown()) {
                return new Text("Shutdown (CRITICAL)").color(Color.RED.dark(3));
            }
            return new Text("Disabled").color(Color.RED.dark(3));
        }))).setEnabled(this.isFixed));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"132", (String)"Pipe is loose.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mWrench))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"133", (String)"Screws are loose.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mScrewdriver))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"134", (String)"Something is stuck.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSoftHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftHammer, val -> {
            this.mSoftHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"135", (String)"Platings are dented.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mHardHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"136", (String)"Circuitry burned out.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSolderingTool))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"137", (String)"That doesn't belong there.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mCrowbar))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"138", (String)"Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
    }

    private /* synthetic */ Boolean lambda$createConfigurationWindow$38(Widget widget) {
        return this.getBaseMetaTileEntity().isActive();
    }

    private /* synthetic */ Boolean lambda$createConfigurationWindow$37(Widget widget) {
        return !this.getBaseMetaTileEntity().isActive();
    }

    private /* synthetic */ Boolean lambda$createConfigurationWindow$36(Widget widget) {
        return !this.getBaseMetaTileEntity().isActive();
    }

    private static /* synthetic */ IDrawable[] lambda$createConfigurationWindow$35(Integer i) {
        return new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GT_UITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f), i == 0 ? new Text("Normal").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Swarmer").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f)};
    }

    private /* synthetic */ void lambda$createConfigurationWindow$34(EntityPlayer player, Integer val) {
        if (this.mMaxProgresstime > 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"Can't change mode when running !");
            return;
        }
        this.mSecondaryMode = val;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        switch (this.mSecondaryMode) {
            case 0: {
                GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"Changed secondary mode to: Normal mode");
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"Changed secondary mode to: Swarmer mode");
            }
        }
    }

    private /* synthetic */ Integer lambda$createConfigurationWindow$33() {
        return this.mSecondaryMode;
    }

    private static class BeeSimulator {
        final ItemStack queenStack;
        boolean isValid;
        List<BeeDrop> drops = new ArrayList<BeeDrop>();
        List<BeeDrop> specialDrops = new ArrayList<BeeDrop>();
        float beeSpeed;
        float maxBeeCycles;
        String flowerType;
        final HashMap<BeeDrop, Double> dropProgress = new HashMap();

        public BeeSimulator(ItemStack queenStack, World world, float t) {
            this.isValid = false;
            this.queenStack = queenStack.func_77946_l();
            this.generate(world, t);
            this.isValid = true;
            --queenStack.field_77994_a;
        }

        public void generate(World world, float t) {
            this.drops.clear();
            this.specialDrops.clear();
            if (BeeManager.beeRoot.getType(this.queenStack) != EnumBeeType.QUEEN) {
                return;
            }
            IBee queen = BeeManager.beeRoot.getMember(this.queenStack);
            IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
            IBeeModifier beeModifier = mode.getBeeModifier();
            float mod = beeModifier.getLifespanModifier(null, null, 1.0f);
            int h = queen.getMaxHealth();
            this.maxBeeCycles = (float)h / (1.0f / mod);
            IBeeGenome genome = queen.getGenome();
            this.flowerType = genome.getFlowerProvider().getFlowerType();
            IAlleleBeeSpecies primary = genome.getPrimary();
            this.beeSpeed = genome.getSpeed() * beeModifier.getProductionModifier(null, 1.0f);
            genome.getPrimary().getProductChances().forEach((key, value) -> this.drops.add(new BeeDrop((ItemStack)key, value.floatValue(), this.beeSpeed, t)));
            genome.getSecondary().getProductChances().forEach((key, value) -> this.drops.add(new BeeDrop((ItemStack)key, value.floatValue() / 2.0f, this.beeSpeed, t)));
            primary.getSpecialtyChances().forEach((key, value) -> this.specialDrops.add(new BeeDrop((ItemStack)key, value.floatValue(), this.beeSpeed, t)));
        }

        public BeeSimulator(NBTTagCompound tag) {
            int i;
            this.queenStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("queenStack"));
            this.isValid = tag.func_74767_n("isValid");
            this.drops = new ArrayList<BeeDrop>();
            this.specialDrops = new ArrayList<BeeDrop>();
            int isize = tag.func_74762_e("dropssize");
            for (i = 0; i < isize; ++i) {
                this.drops.add(new BeeDrop(tag.func_74775_l("drops" + i)));
            }
            isize = tag.func_74762_e("specialDropssize");
            for (i = 0; i < isize; ++i) {
                this.specialDrops.add(new BeeDrop(tag.func_74775_l("specialDrops" + i)));
            }
            this.beeSpeed = tag.func_74760_g("beeSpeed");
            this.maxBeeCycles = tag.func_74760_g("maxBeeCycles");
            if (tag.func_74764_b("flowerType")) {
                this.flowerType = tag.func_74779_i("flowerType");
            } else {
                IBee queen = BeeManager.beeRoot.getMember(this.queenStack);
                IBeeGenome genome = queen.getGenome();
                this.flowerType = genome.getFlowerProvider().getFlowerType();
            }
        }

        public NBTTagCompound toNBTTagCompound() {
            int i;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("queenStack", (NBTBase)this.queenStack.func_77955_b(new NBTTagCompound()));
            tag.func_74757_a("isValid", this.isValid);
            tag.func_74768_a("dropssize", this.drops.size());
            for (i = 0; i < this.drops.size(); ++i) {
                tag.func_74782_a("drops" + i, (NBTBase)this.drops.get(i).toNBTTagCompound());
            }
            tag.func_74768_a("specialDropssize", this.specialDrops.size());
            for (i = 0; i < this.specialDrops.size(); ++i) {
                tag.func_74782_a("specialDrops" + i, (NBTBase)this.specialDrops.get(i).toNBTTagCompound());
            }
            tag.func_74776_a("beeSpeed", this.beeSpeed);
            tag.func_74776_a("maxBeeCycles", this.maxBeeCycles);
            tag.func_74778_a("flowerType", this.flowerType);
            return tag;
        }

        public List<ItemStack> getDrops(double timePassed) {
            this.drops.forEach(d -> this.dropProgress.merge((BeeDrop)d, d.getAmount(timePassed / 550.0), Double::sum));
            this.specialDrops.forEach(d -> this.dropProgress.merge((BeeDrop)d, d.getAmount(timePassed / 550.0), Double::sum));
            ArrayList<ItemStack> currentDrops = new ArrayList<ItemStack>();
            this.dropProgress.entrySet().forEach(e -> {
                double v = (Double)e.getValue();
                while (v > 1.0) {
                    int size = Math.min((int)v, 64);
                    currentDrops.add(((BeeDrop)e.getKey()).get(size));
                    e.setValue(v -= (double)size);
                }
            });
            return currentDrops;
        }

        public ItemStack createIgnobleCopy() {
            IBee princess = BeeManager.beeRoot.getMember(this.queenStack);
            princess.setIsNatural(false);
            return BeeManager.beeRoot.getMemberStack((IIndividual)princess, EnumBeeType.PRINCESS.ordinal());
        }

        public void updateTVar(float t) {
            this.drops.forEach(d -> d.updateTVar(t));
            this.specialDrops.forEach(d -> d.updateTVar(t));
        }

        private static class BeeDrop {
            final ItemStack stack;
            double amount;
            final GT_Utility.ItemId id;
            final float chance;
            final float beeSpeed;
            float t;

            public BeeDrop(ItemStack stack, float chance, float beeSpeed, float t) {
                this.stack = stack;
                this.chance = chance;
                this.beeSpeed = beeSpeed;
                this.t = t;
                this.id = GT_Utility.ItemId.createNoCopy((ItemStack)stack);
                this.evaluate();
            }

            public void updateTVar(float t) {
                if (this.t != t) {
                    this.t = t;
                    this.evaluate();
                }
            }

            public void evaluate() {
                this.amount = Bee.getFinalChance((float)this.chance, (float)this.beeSpeed, (float)2.0f, (float)this.t);
            }

            public double getAmount(double speedModifier) {
                return this.amount * speedModifier;
            }

            public ItemStack get(int amount) {
                ItemStack r = this.stack.func_77946_l();
                r.field_77994_a = amount;
                return r;
            }

            public BeeDrop(NBTTagCompound tag) {
                this.stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("stack"));
                this.chance = tag.func_74760_g("chance");
                this.beeSpeed = tag.func_74760_g("beeSpeed");
                this.t = tag.func_74760_g("t");
                this.amount = tag.func_74769_h("amount");
                this.id = GT_Utility.ItemId.createNoCopy((ItemStack)this.stack);
            }

            public NBTTagCompound toNBTTagCompound() {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
                tag.func_74776_a("chance", this.chance);
                tag.func_74776_a("beeSpeed", this.beeSpeed);
                tag.func_74776_a("t", this.t);
                tag.func_74780_a("amount", this.amount);
                return tag;
            }

            public int hashCode() {
                return this.id.hashCode();
            }
        }
    }

    private static class KT_ModulaUIContainer_MegaIndustrialApiary
    extends ModularUIContainer {
        final WeakReference<GT_MetaTileEntity_MegaIndustrialApiary> parent;

        public KT_ModulaUIContainer_MegaIndustrialApiary(ModularUIContext context, ModularWindow mainWindow, GT_MetaTileEntity_MegaIndustrialApiary mte) {
            super(context, mainWindow);
            this.parent = new WeakReference<GT_MetaTileEntity_MegaIndustrialApiary>(mte);
        }

        public ItemStack func_82846_b(EntityPlayer aPlayer, int aSlotIndex) {
            if (!(aPlayer instanceof EntityPlayerMP)) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            Slot s = this.func_75139_a(aSlotIndex);
            if (s == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (aSlotIndex >= 36) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            ItemStack aStack = s.func_75211_c();
            if (aStack == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            GT_MetaTileEntity_MegaIndustrialApiary mte = (GT_MetaTileEntity_MegaIndustrialApiary)((Object)this.parent.get());
            if (mte == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (mte.mStorage.size() >= mte.mMaxSlots) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (BeeManager.beeRoot.getType(aStack) == EnumBeeType.QUEEN) {
                if (mte.mMaxProgresstime > 0) {
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(EnumChatFormatting.RED + "Can't insert while running !"));
                    return super.func_82846_b(aPlayer, aSlotIndex);
                }
                World w = mte.getBaseMetaTileEntity().getWorld();
                float t = (float)GTHelper.getVoltageTierD((GT_MetaTileEntity_MultiBlockBase)mte);
                BeeSimulator bs = new BeeSimulator(aStack, w, t);
                if (bs.isValid) {
                    mte.mStorage.add(bs);
                    s.func_75215_d(null);
                    this.func_75142_b();
                    mte.isCacheDirty = true;
                    return null;
                }
            }
            return super.func_82846_b(aPlayer, aSlotIndex);
        }
    }
}

