/*
 * Decompiled with CFR 0.152.
 */
package kubatech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.spawner.BlockPoweredSpawner;
import gregtech.api.util.GT_Utility;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import kubatech.api.LoaderReference;
import kubatech.api.helpers.InfernalHelper;
import kubatech.api.mobhandler.MobDrop;
import kubatech.api.utils.FastRandom;
import kubatech.api.utils.MobUtils;
import kubatech.api.utils.ModUtils;
import kubatech.config.Config;
import kubatech.kubatech;
import kubatech.loaders.MobRecipeLoader;
import kubatech.nei.NEI_Config;
import kubatech.tileentity.gregtech.multiblock.GT_MetaTileEntity_ExtremeExterminationChamber;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class Mob_Handler
extends TemplateRecipeHandler {
    private static final Logger LOG = LogManager.getLogger((String)"kubatech[Mob Handler]");
    private static final Mob_Handler instance = new Mob_Handler();
    private static final List<MobCachedRecipe> cachedRecipes = new ArrayList<MobCachedRecipe>();
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());
    private static final int itemsPerRow = 8;
    private static final int itemXShift = 18;
    private static final int itemYShift = 18;
    private static final int nextRowYShift = 35;
    private static final Field mainmodelfield;

    public static void addRecipe(EntityLiving e, List<MobDrop> drop) {
        int xorigin;
        ArrayList<MobPositionedStack> positionedStacks = new ArrayList<MobPositionedStack>();
        int xoffset = xorigin = 7;
        int yoffset = 95;
        int normaldrops = 0;
        int raredrops = 0;
        int additionaldrops = 0;
        int infernaldrops = 0;
        MobDrop.DropType i = null;
        for (MobDrop d : drop) {
            if (i == d.type && (xoffset += 18) >= xorigin + 144) {
                xoffset = xorigin;
                yoffset += 18;
            }
            if (i != null && i != d.type) {
                xoffset = xorigin;
                yoffset += 35;
            }
            i = d.type;
            if (d.type == MobDrop.DropType.Normal) {
                ++normaldrops;
            } else if (d.type == MobDrop.DropType.Rare) {
                ++raredrops;
            } else if (d.type == MobDrop.DropType.Additional) {
                ++additionaldrops;
            } else if (d.type == MobDrop.DropType.Infernal) break;
            positionedStacks.add(new MobPositionedStack(d.stack.func_77946_l(), xoffset, yoffset, d.type, d.chance, d.enchantable, d.damages != null ? new ArrayList<Integer>(d.damages.keySet()) : null, d.lootable, d.playerOnly));
        }
        instance.addRecipeInt(e, positionedStacks, normaldrops, raredrops, additionaldrops, infernaldrops);
    }

    private void addRecipeInt(EntityLiving e, List<MobPositionedStack> l, int normaldrops, int raredrops, int additionaldrops, int infernalDrops) {
        cachedRecipes.add(new MobCachedRecipe(e, l, normaldrops, raredrops, additionaldrops, infernalDrops));
    }

    public static void clearRecipes() {
        cachedRecipes.clear();
    }

    public static void sortCachedRecipes() {
        cachedRecipes.sort((o1, o2) -> {
            boolean m1 = o1.mod.equals("Minecraft");
            boolean m2 = o2.mod.equals("Minecraft");
            if (m1 && !m2) {
                return -1;
            }
            if (!m1 && m2) {
                return 1;
            }
            if (!o1.mod.equals(o2.mod)) {
                return o1.mod.compareTo(o2.mod);
            }
            return o1.localizedName.compareTo(o2.localizedName);
        });
    }

    public Mob_Handler() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(7, 62, 16, 16), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_Config.isAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)kubatech.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("kubatech@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new Mob_Handler();
    }

    public String getOverlayIdentifier() {
        return "kubatech.mobhandler";
    }

    public String getGuiTexture() {
        return "kubatech:textures/gui/MobHandler.png";
    }

    public void drawBackground(int recipe) {
        int err;
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)168, (int)192);
        MobCachedRecipe currentrecipe = (MobCachedRecipe)((Object)this.arecipes.get(recipe));
        int x = 6;
        int y = 94;
        int yshift = 35;
        if (currentrecipe.normalOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.normalOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (currentrecipe.normalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.rareOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.rareOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (currentrecipe.rareOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.additionalOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.additionalOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (currentrecipe.additionalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.infernalOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.infernalOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
        }
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scale = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scale.func_78326_a();
        int height = scale.func_78328_b();
        int mouseX = Mouse.getX() * width / mc.field_71443_c;
        int mouseZ = height - Mouse.getY() * height / mc.field_71440_d - 1;
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf);
        float x2 = buf.get(12);
        float y2 = buf.get(13);
        int stackdepth = GL11.glGetInteger((int)2979);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        float healthScale = BossStatus.field_82828_a;
        int statusBarTime = BossStatus.field_82826_b;
        String bossName = BossStatus.field_82827_c;
        boolean hasColorModifier = BossStatus.field_82825_d;
        BossStatus.field_82826_b = 0;
        try {
            EntityLiving e = currentrecipe.mob;
            float eheight = MobUtils.getMobHeight(e);
            float scaled = MobUtils.getDesiredScale(eheight, 27.0f);
            int mobx = 30;
            int moby = 50;
            e.func_70107_b(mc.field_71439_g.field_70165_t + 5.0, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
            GuiInventory.func_147046_a((int)mobx, (int)moby, (int)Math.round(scaled), (float)(x2 + (float)mobx - (float)mouseX), (float)(y2 + (float)moby - eheight * scaled - (float)mouseZ), (EntityLivingBase)e);
        }
        catch (Throwable ex) {
            Tessellator tes = Tessellator.field_78398_a;
            try {
                tes.func_78381_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (BossStatus.field_82826_b > 0 && currentrecipe.isBoss.isEmpty()) {
            currentrecipe.isBoss = BossStatus.field_82827_c;
        }
        BossStatus.field_82828_a = healthScale;
        BossStatus.field_82826_b = statusBarTime;
        BossStatus.field_82827_c = bossName;
        BossStatus.field_82825_d = hasColorModifier;
        GL11.glMatrixMode((int)2982);
        if ((stackdepth -= GL11.glGetInteger((int)2979)) < 0) {
            while (stackdepth < 0) {
                GL11.glPopMatrix();
                ++stackdepth;
            }
        }
        if (stackdepth > 0) {
            while (stackdepth > 0) {
                GL11.glPushMatrix();
                --stackdepth;
            }
        }
        GL11.glPopAttrib();
        while ((err = GL11.glGetError()) != 0) {
            if (!Config.Debug.showRenderErrors) continue;
            LOG.error(currentrecipe.mobname + " | GL ERROR: " + err + " / " + GLU.gluErrorString((int)err));
        }
        GL11.glDisable((int)2929);
    }

    public void drawForeground(int recipe) {
        MobRecipeLoader.MobRecipe MBRecipe;
        MobCachedRecipe currentrecipe = (MobCachedRecipe)((Object)this.arecipes.get(recipe));
        int y = 7;
        int yshift = 10;
        int x = 57;
        GuiDraw.drawString((String)currentrecipe.localizedName, (int)x, (int)y, (int)-11184811, (boolean)false);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && NEIClientUtils.shiftKey()) {
            GuiDraw.drawString((String)currentrecipe.mobname, (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        }
        GuiDraw.drawString((String)(Translations.MOD.get() + currentrecipe.mod), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        GuiDraw.drawString((String)(Translations.MAX_HEALTH.get() + currentrecipe.maxHealth), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        switch (currentrecipe.infernaltype) {
            case -1: {
                break;
            }
            case 0: {
                GuiDraw.drawString((String)Translations.INFERNAL_CANNOT.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
                break;
            }
            case 1: {
                GuiDraw.drawString((String)Translations.INFERNAL_CAN.get(), (int)x, (int)(y += yshift), (int)-65536, (boolean)false);
                break;
            }
            case 2: {
                GuiDraw.drawString((String)Translations.INFERNAL_ALWAYS.get(), (int)x, (int)(y += yshift), (int)-65536, (boolean)false);
            }
        }
        if (!currentrecipe.isBoss.isEmpty()) {
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "" + Translations.BOSS.get()), (int)x, (int)(y += yshift), (int)-2715904, (boolean)false);
        }
        if ((MBRecipe = GT_MetaTileEntity_ExtremeExterminationChamber.MobNameToRecipeMap.get(currentrecipe.mobname)) != null) {
            if (MBRecipe.isUsable) {
                StringBuilder stringBuilder = new StringBuilder().append(GT_Utility.trans((String)"153", (String)"Usage: "));
                MBRecipe.getClass();
                GuiDraw.drawString((String)stringBuilder.append(GT_Utility.formatNumbers((long)2000L)).append(" EU/t").toString(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
                GuiDraw.drawString((String)(GT_Utility.trans((String)"158", (String)"Time: ") + GT_Utility.formatNumbers((double)((double)MBRecipe.mDuration / 20.0)) + " secs"), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
            } else {
                GuiDraw.drawString((String)Translations.CANNOT_USE_VIAL.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
            }
        }
        x = 6;
        y = Math.max(83, 83 + (y - 67));
        yshift = 35;
        if (currentrecipe.normalOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.NORMAL_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.normalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.rareOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.RARE_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.rareOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.additionalOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.ADDITIONAL_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.additionalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.infernalOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.INFERNAL_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.additionalOutputsCount - 1) / 8 * 18;
        }
        yshift = 10;
    }

    public String getRecipeName() {
        return "Mob Drops";
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        ItemStack candidate;
        TemplateRecipeHandler handler;
        if (inputId.equals("item") && RecipeCatalysts.containsCatalyst((IRecipeHandler)(handler = this.newInstance()), (ItemStack)(candidate = (ItemStack)ingredients[0]))) {
            handler.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
            return handler;
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.addAll(cachedRecipes);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MobCachedRecipe r : cachedRecipes) {
            if (!r.contains(r.mOutputs, result)) continue;
            this.arecipes.add(r);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (LoaderReference.EnderIO && ingredient.func_77973_b() == Item.func_150898_a((Block)EnderIO.blockPoweredSpawner)) {
            if (!ingredient.func_77942_o() || !ingredient.func_77978_p().func_74764_b("mobType")) {
                this.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
                return;
            }
            for (MobCachedRecipe r : cachedRecipes) {
                if (!r.mInput.stream().anyMatch(s -> s.func_77973_b() == ingredient.func_77973_b() && Objects.equals(s.func_77978_p().func_74779_i("mobType"), ingredient.func_77978_p().func_74779_i("mobType")))) continue;
                this.arecipes.add(r);
            }
        } else {
            for (MobCachedRecipe r : cachedRecipes) {
                if (!r.mInput.stream().anyMatch(arg_0 -> ((ItemStack)ingredient).func_77969_a(arg_0))) continue;
                this.arecipes.add(r);
            }
        }
    }

    public void onUpdate() {
        ++cycleTicksStatic;
    }

    static {
        try {
            mainmodelfield = RendererLivingEntity.class.getDeclaredField(ModUtils.isDeobfuscatedEnvironment ? "mainModel" : "field_77045_g");
            mainmodelfield.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private class MobCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final EntityLiving mob;
        public final List<PositionedStack> mOutputs;
        public final List<ItemStack> mInput;
        public final String mobname;
        public final int infernaltype;
        public final PositionedStack ingredient;
        public final String localizedName;
        public final String mod;
        public final float maxHealth;
        public final int normalOutputsCount;
        public final int rareOutputsCount;
        public final int additionalOutputsCount;
        public final int infernalOutputsCount;
        public String isBoss;

        public MobCachedRecipe(EntityLiving mob, List<MobPositionedStack> mOutputs, int normalOutputsCount, int rareOutputsCount, int additionalOutputsCount, int infernalOutputsCount) {
            super((TemplateRecipeHandler)Mob_Handler.this);
            this.isBoss = "";
            String classname = mob.getClass().getName();
            this.mod = ModUtils.getModNameFromClassName(classname);
            this.mob = mob;
            this.maxHealth = mob.func_110138_aP();
            this.mOutputs = new ArrayList<PositionedStack>(mOutputs.size());
            this.mOutputs.addAll(mOutputs);
            this.normalOutputsCount = normalOutputsCount;
            this.rareOutputsCount = rareOutputsCount;
            this.additionalOutputsCount = additionalOutputsCount;
            this.infernalOutputsCount = infernalOutputsCount;
            this.mInput = new ArrayList<ItemStack>();
            int id = EntityList.func_75619_a((Entity)mob);
            this.mobname = EntityList.func_75621_b((Entity)mob);
            String string = this.localizedName = this.mobname.equals("Skeleton") && ((EntitySkeleton)mob).func_82202_m() == 1 ? "Wither Skeleton" : StatCollector.func_74838_a((String)("entity." + this.mobname + ".name"));
            if (id != 0) {
                this.mInput.add(new ItemStack(Items.field_151063_bx, 1, id));
                this.mInput.add(new ItemStack(Blocks.field_150474_ac, 1, id));
            }
            if (LoaderReference.EnderIO) {
                ItemStack s = new ItemStack((Block)EnderIO.blockPoweredSpawner, 1);
                NBTTagCompound nbt = new NBTTagCompound();
                BlockPoweredSpawner.writeMobTypeToNBT((NBTTagCompound)nbt, (String)this.mobname);
                s.func_77982_d(nbt);
                this.mInput.add(0, s);
            } else if (id == 0) {
                this.mInput.add(new ItemStack(Items.field_151063_bx, 1, 0));
            }
            this.ingredient = new PositionedStack((Object)this.mInput.get(0), 38, 44, false);
            this.infernaltype = !LoaderReference.InfernalMobs ? -1 : (!InfernalHelper.isClassAllowed((EntityLivingBase)mob) ? 0 : (InfernalHelper.checkEntityClassForced((EntityLivingBase)mob) ? 2 : 1));
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            if (cycleTicksStatic % 10 == 0) {
                this.mOutputs.forEach(p -> p.setPermutationToRender(0));
            }
            return this.mOutputs;
        }
    }

    public static class MobPositionedStack
    extends PositionedStack {
        public final MobDrop.DropType type;
        public final int chance;
        public final boolean enchantable;
        public final boolean randomdamage;
        public final List<Integer> damages;
        public final int enchantmentLevel;
        private final Random rand = new FastRandom();

        public MobPositionedStack(Object object, int x, int y, MobDrop.DropType type, int chance, Integer enchantable, List<Integer> damages, boolean lootable, boolean isPlayerOnly) {
            super(object, x, y, false);
            this.type = type;
            this.chance = chance;
            this.enchantable = enchantable != null;
            this.enchantmentLevel = this.enchantable ? enchantable : 0;
            this.randomdamage = damages != null;
            this.damages = this.randomdamage ? damages : null;
            NBTTagList extratooltip = new NBTTagList();
            if (chance != 10000) {
                extratooltip.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + Translations.CHANCE.get() + chance / 100 + "." + chance % 100 + "%"));
            }
            if (lootable) {
                extratooltip.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + Translations.LOOTABLE.get()));
            }
            if (isPlayerOnly) {
                extratooltip.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + Translations.PLAYER_ONLY.get()));
            }
            extratooltip.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + Translations.AVERAGE_REMINDER.get()));
            NBTTagCompound itemtag = this.items[0].func_77978_p();
            if (itemtag == null) {
                itemtag = new NBTTagCompound();
            }
            NBTTagCompound display = new NBTTagCompound();
            if (itemtag.func_74764_b("display")) {
                display = itemtag.func_74775_l("display");
                if (display.func_74764_b("Lore")) {
                    NBTTagList lore = display.func_150295_c("Lore", 8);
                    for (int i = 0; i < extratooltip.func_74745_c(); ++i) {
                        lore.func_74742_a((NBTBase)new NBTTagString(extratooltip.func_150307_f(i)));
                    }
                    display.func_74782_a("Lore", (NBTBase)lore);
                } else {
                    display.func_74782_a("Lore", (NBTBase)extratooltip);
                }
            } else {
                display.func_74782_a("Lore", (NBTBase)extratooltip);
            }
            itemtag.func_74782_a("display", (NBTBase)display);
            this.items[0].func_77982_d(itemtag);
            this.item.func_77982_d((NBTTagCompound)itemtag.func_74737_b());
            this.setPermutationToRender(0);
        }

        public void setPermutationToRender(int index) {
            if (this.item == null) {
                this.item = this.items[0].func_77946_l();
            }
            if (this.enchantable) {
                if (this.item.func_77973_b() == Items.field_151134_bR) {
                    this.item = this.items[0].func_77946_l();
                }
                this.item.func_77978_p().func_82580_o("ench");
                EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)this.item, (int)this.enchantmentLevel);
            }
            if (this.randomdamage) {
                this.item.func_77964_b(this.damages.get(this.rand.nextInt(this.damages.size())).intValue());
            }
        }
    }

    static enum Translations {
        NORMAL_DROPS,
        RARE_DROPS,
        ADDITIONAL_DROPS,
        INFERNAL_DROPS,
        INFERNAL_CANNOT,
        INFERNAL_CAN,
        INFERNAL_ALWAYS,
        CANNOT_USE_VIAL,
        CHANCE,
        AVERAGE_REMINDER,
        MOD,
        MAX_HEALTH,
        BOSS,
        LOOTABLE,
        PLAYER_ONLY;

        final String key = "mobhandler." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public String get(Object ... args) {
            return StatCollector.func_74837_a((String)this.key, (Object[])args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

