/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PreviewTile;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;

public class PreviewTileAxis
extends PreviewTile {
    public static Vec3 red = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
    public RotationUtils.Axis axis;

    public PreviewTileAxis(LittleTileBox box, LittleTilePreview preview, RotationUtils.Axis axis) {
        super(box, preview);
        this.axis = axis;
    }

    @Override
    public Vec3 getPreviewColor() {
        return red;
    }

    @Override
    public boolean needsCollisionTest() {
        return false;
    }

    @Override
    public PreviewTile copy() {
        return new PreviewTileAxis(this.box.copy(), null, this.axis);
    }

    @Override
    public LittleTileBox getPreviewBox() {
        LittleTileBox preview = this.box.copy();
        int max = 640;
        int min = -max;
        switch (this.axis) {
            case Xaxis: {
                preview.minX = min;
                preview.maxX = max;
                break;
            }
            case Yaxis: {
                preview.minY = min;
                preview.maxY = max;
                break;
            }
            case Zaxis: {
                preview.minZ = min;
                preview.maxZ = max;
                break;
            }
        }
        return preview;
    }

    @Override
    public LittleTile placeTile(EntityPlayer player, ItemStack stack, TileEntityLittleTiles teLT, LittleStructure structure, ArrayList<LittleTile> unplaceableTiles) {
        if (structure instanceof LittleDoor) {
            LittleDoor door = (LittleDoor)structure;
            door.axisVec = this.box.getMinVec();
            door.axisVec.addVec(new LittleTileVec(teLT.field_145851_c * 16, teLT.field_145848_d * 16, teLT.field_145849_e * 16));
            door.axisVec.subVec(door.mainTile.cornerVec);
        }
        return null;
    }
}

