/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleFlipPacket
extends CreativeCorePacket {
    public ForgeDirection direction;

    public LittleFlipPacket() {
    }

    public LittleFlipPacket(ForgeDirection direction) {
        this.direction = direction;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        LittleFlipPacket.writeDirection(buf, this.direction);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        this.direction = LittleFlipPacket.readDirection(buf);
    }

    @Override
    public void executeClient(EntityPlayer player) {
        this.execute(player);
    }

    public void execute(EntityPlayer player) {
        if (PlacementHelper.isLittleBlock(player.func_70694_bm())) {
            ItemStack stack = player.func_70694_bm();
            ILittleTile itile = null;
            if (stack.func_77973_b() instanceof ILittleTile) {
                itile = (ILittleTile)stack.func_77973_b();
            } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
                itile = (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
            }
            if (itile != null) {
                itile.flipLittlePreview(stack, this.direction);
                LittleStructure structure = itile.getLittleStructure(stack);
                if (structure != null) {
                    structure.onFlip(player.field_70170_p, player, stack, this.direction);
                    NBTTagCompound nbt = new NBTTagCompound();
                    structure.writeToNBT(nbt);
                    stack.field_77990_d.func_74782_a("structure", (NBTBase)nbt);
                }
            }
        }
    }

    @Override
    public void executeServer(EntityPlayer player) {
        this.execute(player);
    }
}

