/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.LittleBlockVertex;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.TileList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TileEntityLittleTiles
extends TileEntity {
    private TileList<LittleTile> tiles = TileEntityLittleTiles.createTileList();
    @SideOnly(value=Side.CLIENT)
    public ArrayList<LittleTile> customRenderingTiles = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    public boolean needsRenderingUpdate;
    @SideOnly(value=Side.CLIENT)
    public int lightValue;
    @SideOnly(value=Side.CLIENT)
    public ArrayList<LittleBlockVertex> lastRendered;
    @SideOnly(value=Side.CLIENT)
    public boolean isRendering;
    @SideOnly(value=Side.CLIENT)
    public boolean needFullRenderUpdate;
    public boolean needFullUpdate = false;
    public LittleTile loadedTile = null;

    public static TileList<LittleTile> createTileList() {
        return new TileList<LittleTile>();
    }

    public void setTiles(TileList<LittleTile> tiles) {
        this.tiles = tiles;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.updateCustomRenderer();
        }
    }

    public TileList<LittleTile> getTiles() {
        return this.tiles;
    }

    @SideOnly(value=Side.CLIENT)
    public void markFullRenderUpdate() {
        this.needFullRenderUpdate = true;
        this.updateRender();
    }

    public boolean removeTile(LittleTile tile) {
        boolean result = this.tiles.remove(tile);
        this.updateTiles();
        return result;
    }

    public void addTiles(ArrayList<LittleTile> tiles) {
        this.tiles.addAll(tiles);
        this.updateTiles();
    }

    public boolean addTile(LittleTile tile) {
        boolean result = this.tiles.add(tile);
        this.updateTiles();
        return result;
    }

    public void updateTiles() {
        if (this.field_145850_b != null) {
            this.update();
            this.updateNeighbor();
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.updateCustomRenderer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateCustomRenderer() {
        this.customRenderingTiles.clear();
        for (int i = 0; i < this.tiles.size(); ++i) {
            if (!this.tiles.get(i).needCustomRendering()) continue;
            this.customRenderingTiles.add(this.tiles.get(i));
        }
    }

    public void updateNeighbor() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.markFullRenderUpdate();
        }
        for (int i = 0; i < this.tiles.size(); ++i) {
            this.tiles.get(i).onNeighborChangeInside();
        }
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)LittleTiles.blockTile);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        double renderDistance = 0.0;
        for (int i = 0; i < this.tiles.size(); ++i) {
            renderDistance = Math.max(renderDistance, this.tiles.get(i).getMaxRenderDistanceSquared());
        }
        return renderDistance;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        double minX = this.field_145851_c;
        double minY = this.field_145848_d;
        double minZ = this.field_145849_e;
        double maxX = this.field_145851_c + 1;
        double maxY = this.field_145848_d + 1;
        double maxZ = this.field_145849_e + 1;
        for (int i = 0; i < this.tiles.size(); ++i) {
            AxisAlignedBB box = this.tiles.get(i).getRenderBoundingBox();
            minX = Math.min(box.field_72340_a, minX);
            minY = Math.min(box.field_72338_b, minY);
            minZ = Math.min(box.field_72339_c, minZ);
            maxX = Math.max(box.field_72336_d, maxX);
            maxY = Math.max(box.field_72337_e, maxY);
            maxZ = Math.max(box.field_72334_f, maxZ);
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isSpaceForLittleTile(CubeObject cube) {
        return this.isSpaceForLittleTile(cube.getAxis());
    }

    public boolean isSpaceForLittleTile(AxisAlignedBB alignedBB, LittleTile ignoreTile) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            for (int j = 0; j < this.tiles.get((int)i).boundingBoxes.size(); ++j) {
                if (ignoreTile == this.tiles.get(i) || !alignedBB.func_72326_a(this.tiles.get((int)i).boundingBoxes.get(j).getBox())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSpaceForLittleTile(AxisAlignedBB alignedBB) {
        return this.isSpaceForLittleTile(alignedBB, null);
    }

    public boolean isSpaceForLittleTile(LittleTileBox box) {
        return this.isSpaceForLittleTile(box.getBox());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.tiles != null) {
            this.tiles.clear();
        }
        this.tiles = new TileList();
        int count = nbt.func_74762_e("tilesCount");
        for (int i = 0; i < count; ++i) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            tileNBT = nbt.func_74775_l("t" + i);
            LittleTile tile = LittleTile.CreateandLoadTile(this, this.field_145850_b, tileNBT);
            if (tile == null) continue;
            this.tiles.add(tile);
        }
        this.updateTiles();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < this.tiles.size(); ++i) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            this.tiles.get(i).saveTile(tileNBT);
            nbt.func_74782_a("t" + i, (NBTBase)tileNBT);
        }
        nbt.func_74768_a("tilesCount", this.tiles.size());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.tiles.size(); ++i) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            NBTTagCompound packet = new NBTTagCompound();
            this.tiles.get(i).saveTile(tileNBT);
            this.tiles.get(i).updatePacket(packet);
            tileNBT.func_74782_a("update", (NBTBase)packet);
            nbt.func_74782_a("t" + i, (NBTBase)tileNBT);
            if (!this.needFullUpdate) continue;
            nbt.func_74757_a("f" + i, true);
        }
        nbt.func_74768_a("tilesCount", this.tiles.size());
        this.needFullUpdate = false;
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, nbt);
    }

    public LittleTile getTile(LittleTileVec vec) {
        return this.getTile((byte)vec.x, (byte)vec.y, (byte)vec.z);
    }

    public LittleTile getTile(byte minX, byte minY, byte minZ) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            if (this.tiles.get((int)i).cornerVec.x != minX || this.tiles.get((int)i).cornerVec.y != minY || this.tiles.get((int)i).cornerVec.z != minZ) continue;
            return this.tiles.get(i);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int i;
        ArrayList<LittleTile> exstingTiles = new ArrayList<LittleTile>();
        exstingTiles.addAll(this.tiles);
        int count = pkt.func_148857_g().func_74762_e("tilesCount");
        for (i = 0; i < count; ++i) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            tileNBT = pkt.func_148857_g().func_74775_l("t" + i);
            LittleTile tile = this.getTile(tileNBT.func_74771_c("cVecx"), tileNBT.func_74771_c("cVecy"), tileNBT.func_74771_c("cVecz"));
            if (tile != null && tile.getID().equals(tileNBT.func_74779_i("tID")) && !pkt.func_148857_g().func_74767_n("f" + i)) {
                tile.receivePacket(tileNBT.func_74775_l("update"), net);
                exstingTiles.remove(tile);
                continue;
            }
            tile = LittleTile.CreateandLoadTile(this, this.field_145850_b, tileNBT);
            if (tile == null) continue;
            this.tiles.add(tile);
        }
        for (i = 0; i < exstingTiles.size(); ++i) {
            this.tiles.remove(exstingTiles.get(i));
        }
        this.updateTiles();
    }

    public MovingObjectPosition getMoving(EntityPlayer player) {
        return this.getMoving(player, false);
    }

    public MovingObjectPosition getMoving(EntityPlayer player, boolean loadTile) {
        Object hit = null;
        Vec3 pos = player.func_70666_h(1.0f);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 look = player.func_70676_i(1.0f);
        Vec3 vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.getMoving(pos, vec32, loadTile);
    }

    public MovingObjectPosition getMoving(Vec3 pos, Vec3 look, boolean loadTile) {
        MovingObjectPosition hit = null;
        for (int i = 0; i < this.tiles.size(); ++i) {
            for (int j = 0; j < this.tiles.get((int)i).boundingBoxes.size(); ++j) {
                MovingObjectPosition Temphit = this.tiles.get((int)i).boundingBoxes.get(j).getBox().func_72325_c((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e).func_72327_a(pos, look);
                if (Temphit == null || hit != null && !(hit.field_72307_f.func_72438_d(pos) > Temphit.field_72307_f.func_72438_d(pos))) continue;
                hit = Temphit;
                if (!loadTile) continue;
                this.loadedTile = this.tiles.get(i);
            }
        }
        return hit;
    }

    public boolean updateLoadedTile(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return false;
        }
        this.loadedTile = null;
        this.getMoving(player, true);
        return this.loadedTile != null;
    }

    public boolean updateLoadedTileServer(Vec3 pos, Vec3 look) {
        this.loadedTile = null;
        this.getMoving(pos, look, true);
        return this.loadedTile != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void checkClientLoadedTile(double distance) {
        Minecraft mc = Minecraft.func_71410_x();
        Vec3 pos = mc.field_71439_g.func_70666_h(1.0f);
        if (mc.field_71476_x.field_72307_f.func_72438_d(pos) < distance) {
            this.loadedTile = null;
        }
    }

    public boolean shouldRenderInPass(int pass) {
        if (super.shouldRenderInPass(pass)) {
            return this.customRenderingTiles.size() > 0;
        }
        return false;
    }

    public void update() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.markFullRenderUpdate();
        }
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRender() {
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.needsRenderingUpdate) {
            this.updateRender();
            this.needsRenderingUpdate = false;
        }
        for (int i = 0; i < this.tiles.size(); ++i) {
            this.tiles.get(i).updateEntity();
        }
        if (!this.field_145850_b.field_72995_K && this.tiles.size() == 0) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public ChunkCoordinates getCoord() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void combineTiles(LittleStructure structure) {
        int size = 0;
        while (size != this.tiles.size()) {
            size = this.tiles.size();
            int i = 0;
            while (i < this.tiles.size()) {
                if (this.tiles.get((int)i).structure != structure) {
                    ++i;
                    continue;
                }
                int j = 0;
                while (j < this.tiles.size()) {
                    LittleTileBox box;
                    if (this.tiles.get((int)j).structure != structure) {
                        ++j;
                        continue;
                    }
                    if (i != j && this.tiles.get((int)i).boundingBoxes.size() == 1 && this.tiles.get((int)j).boundingBoxes.size() == 1 && this.tiles.get(i).canBeCombined(this.tiles.get(j)) && this.tiles.get(j).canBeCombined(this.tiles.get(i)) && (box = this.tiles.get((int)i).boundingBoxes.get(0).combineBoxes(this.tiles.get((int)j).boundingBoxes.get(0))) != null) {
                        this.tiles.get((int)i).boundingBoxes.set(0, box);
                        this.tiles.get(i).combineTiles(this.tiles.get(j));
                        this.tiles.get(i).updateCorner();
                        this.tiles.remove(j);
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.update();
    }

    public void combineTiles() {
        int size = 0;
        while (size != this.tiles.size()) {
            size = this.tiles.size();
            for (int i = 0; i < this.tiles.size(); ++i) {
                int j = 0;
                while (j < this.tiles.size()) {
                    LittleTileBox box;
                    if (i != j && this.tiles.get((int)i).boundingBoxes.size() == 1 && this.tiles.get((int)j).boundingBoxes.size() == 1 && this.tiles.get(i).canBeCombined(this.tiles.get(j)) && this.tiles.get(j).canBeCombined(this.tiles.get(i)) && (box = this.tiles.get((int)i).boundingBoxes.get(0).combineBoxes(this.tiles.get((int)j).boundingBoxes.get(0))) != null) {
                        this.tiles.get((int)i).boundingBoxes.set(0, box);
                        this.tiles.get(i).combineTiles(this.tiles.get(j));
                        this.tiles.get(i).updateCorner();
                        this.tiles.remove(j);
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
        this.update();
    }
}

