/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class LittleTilePreview {
    public boolean canSplit = true;
    public LittleTileSize size = null;
    public NBTTagCompound nbt;
    public LittleTileBox box;
    public ArrayList<ShiftHandler> shifthandlers = new ArrayList();

    public LittleTilePreview(LittleTileBox box, NBTTagCompound nbt) {
        this(box.getSize(), nbt);
        this.box = box;
    }

    public LittleTilePreview(LittleTileSize size, NBTTagCompound nbt) {
        this.size = size;
        this.nbt = nbt;
    }

    public void updateSize() {
        this.size = this.box.getSize();
    }

    public LittleTile getLittleTile(TileEntityLittleTiles te) {
        return LittleTile.CreateandLoadTile(te, te.func_145831_w(), this.nbt);
    }

    public CubeObject getCubeBlock() {
        CubeObject cube = this.box.getCube();
        if (this.nbt.func_74764_b("block")) {
            cube.block = Block.func_149684_b((String)this.nbt.func_74779_i("block"));
            cube.meta = this.nbt.func_74762_e("meta");
        } else {
            cube.block = Blocks.field_150348_b;
        }
        if (this.nbt.func_74764_b("color")) {
            cube.color = this.nbt.func_74762_e("color");
        }
        return cube;
    }

    public LittleTilePreview copy() {
        LittleTilePreview preview = new LittleTilePreview(this.size != null ? this.size.copy() : null, (NBTTagCompound)this.nbt.func_74737_b());
        preview.canSplit = this.canSplit;
        preview.shifthandlers = new ArrayList<ShiftHandler>(this.shifthandlers);
        if (this.box != null) {
            preview.box = this.box.copy();
        }
        return preview;
    }

    public static void flipPreview(NBTTagCompound nbt, ForgeDirection direction) {
        if (nbt.func_74764_b("bBoxminX")) {
            LittleTileBox box = new LittleTileBox("bBox", nbt);
            box.flipBoxWithCenter(direction, null);
            box.writeToNBT("bBox", nbt);
        }
        if (nbt.func_74764_b("bSize")) {
            int count = nbt.func_74762_e("bSize");
            for (int i = 0; i < count; ++i) {
                LittleTileBox box = new LittleTileBox("bBox" + i, nbt);
                box.flipBoxWithCenter(direction, null);
                box.writeToNBT("bBox" + i, nbt);
            }
        }
    }

    public static void rotatePreview(NBTTagCompound nbt, ForgeDirection direction) {
        if (nbt.func_74764_b("sizex")) {
            LittleTileSize size = new LittleTileSize("size", nbt);
            size.rotateSize(direction);
            size.writeToNBT("size", nbt);
        }
        if (nbt.func_74764_b("bBoxminX")) {
            LittleTileBox box = new LittleTileBox("bBox", nbt);
            box.rotateBox(direction);
            box.writeToNBT("bBox", nbt);
        }
        if (nbt.func_74764_b("bSize")) {
            int count = nbt.func_74762_e("bSize");
            for (int i = 0; i < count; ++i) {
                LittleTileBox box = new LittleTileBox("bBox" + i, nbt);
                box.rotateBox(direction);
                box.writeToNBT("bBox" + i, nbt);
            }
        }
    }

    public static LittleTilePreview getPreviewFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        LittleTileSize size = null;
        LittleTileBox box = null;
        if (nbt.func_74764_b("sizex")) {
            size = new LittleTileSize("size", nbt);
        }
        if (nbt.func_74764_b("bBoxminX")) {
            box = new LittleTileBox("bBox", nbt);
            if (size == null) {
                size = box.getSize();
            }
        }
        if (size != null) {
            LittleTilePreview preview = new LittleTilePreview(size, nbt);
            preview.box = box;
            return preview;
        }
        return null;
    }
}

