/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.utils;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class PreviewTile {
    public static final Vec3 white = Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0);
    public LittleTileBox box;
    public LittleTilePreview preview;

    public PreviewTile(LittleTileBox box, LittleTilePreview preview) {
        this.box = box;
        this.preview = preview;
    }

    public PreviewTile copy() {
        return new PreviewTile(this.box.copy(), this.preview.copy());
    }

    public Vec3 getPreviewColor() {
        return white;
    }

    public boolean needsCollisionTest() {
        return true;
    }

    public LittleTileBox getPreviewBox() {
        return this.box;
    }

    public LittleTile placeTile(EntityPlayer player, ItemStack stack, TileEntityLittleTiles teLT, LittleStructure structure, ArrayList<LittleTile> unplaceableTiles) {
        LittleTile LT = this.preview.getLittleTile(teLT);
        if (LT == null) {
            return null;
        }
        LT.boundingBoxes.clear();
        LT.boundingBoxes.add(this.box.copy());
        LT.updateCorner();
        if (structure != null) {
            LT.isStructureBlock = true;
            LT.structure = structure;
            structure.getTiles().add(LT);
        }
        if (teLT.isSpaceForLittleTile(this.box.copy())) {
            LT.place();
            LT.onPlaced(player, stack);
            return LT;
        }
        if (unplaceableTiles != null) {
            unplaceableTiles.add(LT);
        }
        return null;
    }

    public boolean split(HashMapList<ChunkCoordinates, PreviewTile> tiles, int x, int y, int z) {
        if (this.preview != null && !this.preview.canSplit && this.box.needsMultipleBlocks()) {
            return false;
        }
        LittleTileSize size = this.box.getSize();
        int offX = this.box.minX / 16;
        if (this.box.minX < 0) {
            offX = (int)Math.floor((double)this.box.minX / 16.0);
        }
        int offY = this.box.minY / 16;
        if (this.box.minY < 0) {
            offY = (int)Math.floor((double)this.box.minY / 16.0);
        }
        int offZ = this.box.minZ / 16;
        if (this.box.minZ < 0) {
            offZ = (int)Math.floor((double)this.box.minZ / 16.0);
        }
        int posX = x + offX;
        int posY = y + offY;
        int posZ = z + offZ;
        int spaceX = this.box.minX - offX * 16;
        int spaceY = this.box.minY - offY * 16;
        int spaceZ = this.box.minZ - offZ * 16;
        int i = 0;
        while (spaceX + size.sizeX > i * 16) {
            posY = y + offY;
            int j = 0;
            while (spaceY + size.sizeY > j * 16) {
                posZ = z + offZ;
                int h = 0;
                while (spaceZ + size.sizeZ > h * 16) {
                    PreviewTile tile = this.copy();
                    tile.box.minX = i > 0 ? 0 : spaceX;
                    if (i * 16 + 16 > spaceX + size.sizeX) {
                        tile.box.maxX = this.box.maxX - this.box.maxX / 16 * 16;
                        if (this.box.maxX < 0) {
                            tile.box.maxX = 16 + tile.box.maxX;
                        }
                    } else {
                        tile.box.maxX = 16;
                    }
                    tile.box.minY = j > 0 ? 0 : spaceY;
                    if (j * 16 + 16 > spaceY + size.sizeY) {
                        tile.box.maxY = this.box.maxY - this.box.maxY / 16 * 16;
                        if (this.box.maxY < 0) {
                            tile.box.maxY = 16 + tile.box.maxY;
                        }
                    } else {
                        tile.box.maxY = 16;
                    }
                    tile.box.minZ = h > 0 ? 0 : spaceZ;
                    if (h * 16 + 16 > spaceZ + size.sizeZ) {
                        tile.box.maxZ = this.box.maxZ - this.box.maxZ / 16 * 16;
                        if (this.box.maxZ < 0) {
                            tile.box.maxZ = 16 + tile.box.maxZ;
                        }
                    } else {
                        tile.box.maxZ = 16;
                    }
                    if (tile.box.isValidBox()) {
                        tiles.add((Object)new ChunkCoordinates(posX, posY, posZ), (Object)tile);
                    }
                    ++posZ;
                    ++h;
                }
                ++posY;
                ++j;
            }
            ++posX;
            ++i;
        }
        return true;
    }
}

