/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerTileContainer
extends SubContainer {
    public InventoryBasic basic = new InventoryBasic("basic", false, 1);
    public ItemStack stack;
    public int index;

    public SubContainerTileContainer(EntityPlayer player, ItemStack stack, int index) {
        super(player);
        this.stack = stack;
        this.index = index;
    }

    @CustomEventSubscribe
    public void onSlotChange(SlotChangeEvent event) {
        Block block;
        ItemStack slot = this.basic.func_70301_a(0);
        if (slot != null && (!((block = Block.func_149634_a((Item)slot.func_77973_b())) instanceof BlockAir) && SubContainerHammer.isBlockValid(block) || PlacementHelper.isLittleBlock(slot) || slot.func_77973_b() instanceof ItemTileContainer)) {
            if (PlacementHelper.isLittleBlock(slot)) {
                float ammount = slot.field_77994_a;
                ArrayList<LittleTilePreview> tiles = null;
                if (slot.func_77973_b() instanceof ILittleTile) {
                    tiles = ((ILittleTile)slot.func_77973_b()).getLittlePreview(slot);
                } else if (Block.func_149634_a((Item)slot.func_77973_b()) instanceof ILittleTile) {
                    tiles = ((ILittleTile)Block.func_149634_a((Item)slot.func_77973_b())).getLittlePreview(slot);
                }
                if (tiles != null) {
                    for (LittleTilePreview tile : tiles) {
                        Block block2;
                        if (!tile.nbt.func_74764_b("block") || (block2 = Block.func_149684_b((String)tile.nbt.func_74779_i("block"))) == null || block2 instanceof BlockAir) continue;
                        ItemTileContainer.addBlock(this.stack, block2, tile.nbt.func_74762_e("meta"), ammount * tile.size.getPercentVolume());
                    }
                }
            } else if (slot.func_77973_b() instanceof ItemTileContainer) {
                ArrayList<ItemTileContainer.BlockEntry> map = ItemTileContainer.loadMap(slot);
                for (ItemTileContainer.BlockEntry blockEntry : map) {
                    ItemTileContainer.addBlock(this.stack, blockEntry.block, blockEntry.meta, blockEntry.value);
                }
                ItemTileContainer.saveMap(slot, new ArrayList<ItemTileContainer.BlockEntry>());
            } else {
                ItemTileContainer.addBlock(this.stack, block, slot.func_77960_j(), (float)this.basic.func_70301_a((int)0).field_77994_a);
            }
            NBTTagCompound nbt = this.stack.field_77990_d;
            nbt.func_74757_a("needUpdate", true);
            this.sendUpdate(nbt);
            if (!(slot.func_77973_b() instanceof ItemTileContainer)) {
                this.basic.func_70299_a(0, null);
            }
        }
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.basic, 0, 150, 35));
        this.addPlayerSlotsToContainer(this.player);
    }

    public void onGuiClosed() {
        this.player.field_71071_by.field_70462_a[this.player.field_71071_by.field_70461_c] = this.stack;
    }

    public void onGuiPacket(int controlID, NBTTagCompound nbt, EntityPlayer player) {
        if (controlID == 0) {
            ItemStack dropStack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            Block block = Block.func_149634_a((Item)dropStack.func_77973_b());
            int meta = dropStack.func_77960_j();
            ArrayList<ItemTileContainer.BlockEntry> entries = ItemTileContainer.loadMap(this.stack);
            for (int i = 0; i < entries.size(); ++i) {
                if (entries.get((int)i).block != block || entries.get((int)i).meta != meta) continue;
                if (entries.get((int)i).value > 1.0f) {
                    int drain = Math.min((int)entries.get((int)i).value, dropStack.field_77994_a);
                    entries.get((int)i).value -= (float)drain;
                    dropStack.field_77994_a = drain;
                    WorldUtils.dropItem((EntityPlayer)player, (ItemStack)dropStack);
                }
                if (entries.get((int)i).value != 0.0f) break;
                entries.remove(i);
                break;
            }
            ItemTileContainer.saveMap(this.stack, entries);
            NBTTagCompound nbt2 = this.stack.field_77990_d;
            nbt2.func_74757_a("needUpdate", true);
            this.sendUpdate(nbt2);
        }
    }
}

