/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.config.Configs;
import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.gui.orderer.GuiRequestTable;
import logisticspipes.network.IReadListObject;
import logisticspipes.network.IWriteListObject;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.request.resources.IResource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ComponentList
extends ModernPacket {
    private Collection<IResource> used = new ArrayList<IResource>();
    private Collection<IResource> missing = new ArrayList<IResource>();

    public ComponentList(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ComponentList(this.getId());
    }

    @Override
    @ClientSideOnlyMethodContent
    public void processPacket(EntityPlayer player) {
        if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r).handleSimulateAnswer(this.used, this.missing, (GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiRequestTable) {
            ((GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r).handleSimulateAnswer(this.used, this.missing, (GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else {
            for (IResource item : this.used) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Component: " + item.getDisplayText(IResource.ColorCode.SUCCESS)));
            }
            for (IResource item : this.missing) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Missing: " + item.getDisplayText(IResource.ColorCode.MISSING)));
            }
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeCollection(this.used, new IWriteListObject<IResource>(){

            @Override
            public void writeObject(LPDataOutputStream data, IResource object) throws IOException {
                data.writeIResource(object);
            }
        });
        data.writeCollection(this.missing, new IWriteListObject<IResource>(){

            @Override
            public void writeObject(LPDataOutputStream data, IResource object) throws IOException {
                data.writeIResource(object);
            }
        });
        data.write(0);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.used = data.readList(new IReadListObject<IResource>(){

            @Override
            public IResource readObject(LPDataInputStream data) throws IOException {
                return data.readIResource();
            }
        });
        this.missing = data.readList(new IReadListObject<IResource>(){

            @Override
            public IResource readObject(LPDataInputStream data) throws IOException {
                return data.readIResource();
            }
        });
    }

    public Collection<IResource> getUsed() {
        return this.used;
    }

    public ComponentList setUsed(Collection<IResource> used) {
        this.used = used;
        return this;
    }

    public Collection<IResource> getMissing() {
        return this.missing;
    }

    public ComponentList setMissing(Collection<IResource> missing) {
        this.missing = missing;
        return this;
    }
}

