/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.asm.IgnoreDisabledProxy;
import logisticspipes.asm.wrapper.AbstractWrapper;
import logisticspipes.asm.wrapper.CraftingRecipeProviderWrapper;
import logisticspipes.asm.wrapper.GenericProgressProviderWrapper;
import logisticspipes.asm.wrapper.WrapperState;
import logisticspipes.proxy.DontLoadProxy;
import logisticspipes.proxy.VersionNotSupportedException;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.proxy.interfaces.IGenericProgressProvider;
import logisticspipes.utils.ModStatusHelper;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LogisticsWrapperHandler {
    private static final boolean DUMP = false;
    private static final Map<String, Class<?>> lookupMap = new HashMap();
    public static List<AbstractWrapper> wrapperController = new ArrayList<AbstractWrapper>();
    private static Method m_defineClass = null;
    private static File tempFolder = null;

    private LogisticsWrapperHandler() {
    }

    public static IGenericProgressProvider getWrappedProgressProvider(String modId, String name, Class<? extends IGenericProgressProvider> providerClass) {
        IGenericProgressProvider provider = null;
        Throwable e = null;
        if (ModStatusHelper.isModLoaded(modId)) {
            try {
                provider = providerClass.newInstance();
            }
            catch (Exception e1) {
                if (e1 instanceof VersionNotSupportedException) {
                    throw (VersionNotSupportedException)e1;
                }
                e1.printStackTrace();
                e = e1;
            }
            catch (NoClassDefFoundError e1) {
                e1.printStackTrace();
                e = e1;
            }
        }
        GenericProgressProviderWrapper instance = new GenericProgressProviderWrapper(provider, modId + ": " + name);
        if (provider != null) {
            LogisticsPipes.log.info("Loaded " + modId + ", " + name + " ProgressProvider");
        } else if (e != null) {
            instance.setState(WrapperState.Exception);
            instance.setReason(e);
            LogisticsPipes.log.info("Couldn't load " + modId + ", " + name + " ProgressProvider");
        } else {
            LogisticsPipes.log.info("Didn't load " + modId + ", " + name + " ProgressProvider");
            instance.setState(WrapperState.ModMissing);
        }
        instance.setModId(modId);
        wrapperController.add(instance);
        return instance;
    }

    public static ICraftingRecipeProvider getWrappedRecipeProvider(String modId, String name, Class<? extends ICraftingRecipeProvider> providerClass) {
        ICraftingRecipeProvider provider = null;
        Throwable e = null;
        if (ModStatusHelper.isModLoaded(modId)) {
            try {
                provider = providerClass.newInstance();
            }
            catch (Exception e1) {
                if (e1 instanceof VersionNotSupportedException) {
                    throw (VersionNotSupportedException)e1;
                }
                e1.printStackTrace();
                e = e1;
            }
            catch (NoClassDefFoundError e1) {
                e1.printStackTrace();
                e = e1;
            }
        }
        CraftingRecipeProviderWrapper instance = new CraftingRecipeProviderWrapper(provider, name);
        if (provider != null) {
            LogisticsPipes.log.info("Loaded " + name + " RecipeProvider");
        } else if (e != null) {
            instance.setState(WrapperState.Exception);
            instance.setReason(e);
            LogisticsPipes.log.info("Couldn't load " + name + " RecipeProvider");
        } else {
            LogisticsPipes.log.info("Didn't load " + name + " RecipeProvider");
            instance.setState(WrapperState.ModMissing);
        }
        instance.setModId(modId);
        wrapperController.add(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getWrappedProxy(String modId, Class<T> interfaze, Class<? extends T> proxyClazz, T dummyProxy, Class<?> ... wrapperInterfaces) throws SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Throwable e;
        Object proxy;
        Class<?> clazz;
        List<Class<?>> wrapperInterfacesList;
        String proxyName;
        block24: {
            proxyName = interfaze.getSimpleName().substring(1);
            if (!proxyName.endsWith("Proxy")) {
                throw new RuntimeException("UnuportedProxyName: " + proxyName);
            }
            proxyName = proxyName.substring(0, proxyName.length() - 5);
            String className = "logisticspipes/asm/wrapper/generated/" + proxyName + "ProxyWrapper";
            boolean ignoreModLoaded = false;
            if (modId.startsWith("!")) {
                ignoreModLoaded = true;
                modId = modId.substring(1);
            }
            wrapperInterfacesList = Arrays.asList(wrapperInterfaces);
            Map<String, Class<?>> map = lookupMap;
            synchronized (map) {
                clazz = lookupMap.get(className);
                if (clazz == null) {
                    String fieldName = interfaze.getName().replace('.', '/');
                    ClassWriter cw = new ClassWriter(1);
                    cw.visit(50, 33, className, null, "logisticspipes/asm/wrapper/AbstractWrapper", new String[]{fieldName});
                    cw.visitSource(".LP|ASM.dynamic", null);
                    FieldVisitor fv = cw.visitField(2, "proxy", "L" + fieldName + ";", null, null);
                    fv.visitEnd();
                    fv = cw.visitField(18, "dummyProxy", "L" + fieldName + ";", null, null);
                    fv.visitEnd();
                    MethodVisitor mv = cw.visitMethod(1, "<init>", "(L" + fieldName + ";L" + fieldName + ";)V", null, null);
                    mv.visitCode();
                    Method[] l0 = new Label();
                    mv.visitLabel((Label)l0);
                    mv.visitLineNumber(11, (Label)l0);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(183, "logisticspipes/asm/wrapper/AbstractWrapper", "<init>", "()V");
                    Label l1 = new Label();
                    mv.visitLabel(l1);
                    mv.visitLineNumber(12, l1);
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 1);
                    mv.visitFieldInsn(181, className, "dummyProxy", "L" + fieldName + ";");
                    Label l2 = new Label();
                    mv.visitLabel(l2);
                    mv.visitLineNumber(13, l2);
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 2);
                    mv.visitFieldInsn(181, className, "proxy", "L" + fieldName + ";");
                    Label l3 = new Label();
                    mv.visitLabel(l3);
                    mv.visitLineNumber(14, l3);
                    mv.visitInsn(177);
                    Label l4 = new Label();
                    mv.visitLabel(l4);
                    mv.visitLocalVariable("this", "L" + className + ";", null, (Label)l0, l4, 0);
                    mv.visitLocalVariable("dProxy", "L" + fieldName + ";", null, (Label)l0, l4, 1);
                    mv.visitLocalVariable("iProxy", "L" + fieldName + ";", null, (Label)l0, l4, 2);
                    mv.visitMaxs(2, 3);
                    mv.visitEnd();
                    int lineAddition = 100;
                    for (Method method : interfaze.getMethods()) {
                        LogisticsWrapperHandler.addProxyMethod(cw, method, fieldName, className, lineAddition, !wrapperInterfacesList.contains(method.getReturnType()));
                        lineAddition += 10;
                    }
                    LogisticsWrapperHandler.addGetName(cw, className, proxyName);
                    LogisticsWrapperHandler.addGetTypeName(cw, className, "Proxy");
                    cw.visitEnd();
                    String lookfor = className.replace('/', '.');
                    byte[] bytes = cw.toByteArray();
                    try {
                        clazz = LogisticsWrapperHandler.loadClass(bytes, lookfor);
                    }
                    catch (LinkageError e2) {
                        try {
                            if (e2.getMessage().contains("attempted") && e2.getMessage().contains("duplicate class definition")) {
                                Class<?> prev = Class.forName(className);
                                System.err.println(e2.getMessage());
                                System.err.println("Already loaded: " + prev);
                                String resourcePath = className.replace('.', '/').concat(".class");
                                URL classResource = Launch.classLoader.findResource(resourcePath);
                                if (classResource != null) {
                                    String path = classResource.getPath();
                                    System.err.println("Class source: " + path);
                                } else {
                                    System.err.println("Class source: Null");
                                }
                            }
                        }
                        catch (Exception e22) {
                            e22.printStackTrace();
                        }
                        throw e2;
                    }
                    lookupMap.put(className, clazz);
                }
            }
            proxy = null;
            e = null;
            if (ModStatusHelper.areModsLoaded(modId) || ignoreModLoaded) {
                try {
                    proxy = proxyClazz.newInstance();
                }
                catch (Exception e1) {
                    if (e1 instanceof VersionNotSupportedException) {
                        throw (VersionNotSupportedException)e1;
                    }
                    if (!(e1 instanceof DontLoadProxy)) {
                        e1.printStackTrace();
                        e = e1;
                    }
                }
                catch (NoClassDefFoundError e1) {
                    if (ignoreModLoaded) break block24;
                    e1.printStackTrace();
                    e = e1;
                }
            }
        }
        Object instance = clazz.getConstructor(interfaze, interfaze).newInstance(dummyProxy, proxy);
        if (proxy != null) {
            LogisticsPipes.log.info("Loaded " + proxyName + "Proxy");
        } else {
            LogisticsPipes.log.info("Loaded " + proxyName + " DummyProxy");
            if (e != null) {
                ((AbstractWrapper)instance).setState(WrapperState.Exception);
                ((AbstractWrapper)instance).setReason(e);
            } else {
                ((AbstractWrapper)instance).setState(WrapperState.ModMissing);
            }
        }
        ((AbstractWrapper)instance).setModId(modId);
        ((AbstractWrapper)instance).setWrapperInterfaces(Collections.unmodifiableList(wrapperInterfacesList));
        wrapperController.add((AbstractWrapper)instance);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getWrappedSubProxy(AbstractWrapper wrapper, Class<T> interfaze, T proxy, T dummyProxy) throws SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz;
        if (proxy == null) {
            return null;
        }
        String proxyName = interfaze.getSimpleName().substring(1);
        String className = "logisticspipes/asm/wrapper/generated/" + proxyName + "ProxyWrapper";
        Map<String, Class<?>> map = lookupMap;
        synchronized (map) {
            clazz = lookupMap.get(className);
            if (clazz == null) {
                String fieldName = interfaze.getName().replace('.', '/');
                ClassWriter cw = new ClassWriter(1);
                cw.visit(50, 33, className, null, "logisticspipes/asm/wrapper/AbstractSubWrapper", new String[]{fieldName});
                cw.visitSource(".LP|ASM.dynamic", null);
                FieldVisitor fv = cw.visitField(2, "proxy", "L" + fieldName + ";", null, null);
                fv.visitEnd();
                fv = cw.visitField(18, "dummyProxy", "L" + fieldName + ";", null, null);
                fv.visitEnd();
                MethodVisitor mv = cw.visitMethod(1, "<init>", "(Llogisticspipes/asm/wrapper/AbstractWrapper;L" + fieldName + ";L" + fieldName + ";)V", null, null);
                mv.visitCode();
                Method[] l0 = new Label();
                mv.visitLabel((Label)l0);
                mv.visitLineNumber(11, (Label)l0);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, "logisticspipes/asm/wrapper/AbstractSubWrapper", "<init>", "(Llogisticspipes/asm/wrapper/AbstractWrapper;)V");
                Label l1 = new Label();
                mv.visitLabel(l1);
                mv.visitLineNumber(12, l1);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 2);
                mv.visitFieldInsn(181, className, "dummyProxy", "L" + fieldName + ";");
                Label l2 = new Label();
                mv.visitLabel(l2);
                mv.visitLineNumber(13, l2);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 3);
                mv.visitFieldInsn(181, className, "proxy", "L" + fieldName + ";");
                Label l3 = new Label();
                mv.visitLabel(l3);
                mv.visitLineNumber(14, l3);
                mv.visitInsn(177);
                Label l4 = new Label();
                mv.visitLabel(l4);
                mv.visitLocalVariable("this", "L" + className + ";", null, (Label)l0, l4, 0);
                mv.visitLocalVariable("wrapper", "Llogisticspipes/asm/wrapper/AbstractWrapper;", null, (Label)l0, l4, 1);
                mv.visitLocalVariable("dProxy", "L" + fieldName + ";", null, (Label)l0, l4, 2);
                mv.visitLocalVariable("iProxy", "L" + fieldName + ";", null, (Label)l0, l4, 3);
                mv.visitMaxs(2, 3);
                mv.visitEnd();
                int lineAddition = 100;
                for (Method method : interfaze.getMethods()) {
                    LogisticsWrapperHandler.addProxyMethod(cw, method, fieldName, className, lineAddition, !wrapper.getWrapperInterfaces().contains(method.getReturnType()));
                    lineAddition += 10;
                }
                cw.visitEnd();
                String lookfor = className.replace('/', '.');
                byte[] bytes = cw.toByteArray();
                try {
                    clazz = LogisticsWrapperHandler.loadClass(bytes, lookfor);
                }
                catch (LinkageError e) {
                    try {
                        if (e.getMessage().contains("attempted") && e.getMessage().contains("duplicate class definition")) {
                            Class<?> prev = Class.forName(className);
                            System.err.println(e.getMessage());
                            System.err.println("Already loaded: " + prev);
                            String resourcePath = className.replace('.', '/').concat(".class");
                            URL classResource = Launch.classLoader.findResource(resourcePath);
                            if (classResource != null) {
                                String path = classResource.getPath();
                                System.err.println("Class source: " + path);
                            } else {
                                System.err.println("Class source: Null");
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw e;
                }
                lookupMap.put(className, clazz);
            }
        }
        Object instance = clazz.getConstructor(AbstractWrapper.class, interfaze, interfaze).newInstance(wrapper, dummyProxy, proxy);
        ((AbstractWrapper)instance).setWrapperInterfaces(wrapper.getWrapperInterfaces());
        return (T)instance;
    }

    private static Class<?> loadClass(byte[] data, String lookfor) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (m_defineClass == null) {
            m_defineClass = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
            m_defineClass.setAccessible(true);
        }
        return (Class)m_defineClass.invoke((Object)Launch.classLoader, data, 0, data.length);
    }

    private static void addGetTypeName(ClassWriter cw, String className, String type) {
        MethodVisitor mv = cw.visitMethod(1, "getTypeName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(31, l0);
        mv.visitLdcInsn((Object)type);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addGetName(ClassWriter cw, String className, String proxyName) {
        MethodVisitor mv = cw.visitMethod(1, "getName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(41, l0);
        mv.visitLdcInsn((Object)proxyName);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addProxyMethod(ClassWriter cw, Method method, String fieldName, String className, int lineAddition, boolean normalResult) {
        int returnType;
        Class<?> retclazz = method.getReturnType();
        int eIndex = 1;
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> clazz : method.getParameterTypes()) {
            desc.append(LogisticsWrapperHandler.getClassSignature(clazz));
            if (clazz == Long.TYPE || clazz == Double.TYPE) {
                eIndex += 2;
                continue;
            }
            ++eIndex;
        }
        ++eIndex;
        desc.append(")");
        String resultClassL = null;
        String resultClass = null;
        if (retclazz == null || retclazz == Void.TYPE) {
            desc.append("V");
            returnType = 177;
        } else if (retclazz.isPrimitive()) {
            desc.append(LogisticsWrapperHandler.getPrimitiveMapping(retclazz));
            returnType = LogisticsWrapperHandler.getPrimitiveReturnMapping(retclazz);
        } else if (retclazz.isArray()) {
            resultClass = resultClassL = retclazz.getName().replace('.', '/');
            desc.append(resultClassL);
            returnType = 176;
        } else {
            resultClassL = "L" + retclazz.getName().replace('.', '/') + ";";
            resultClass = retclazz.getName().replace('.', '/');
            desc.append(resultClassL);
            returnType = 176;
        }
        MethodVisitor mv = cw.visitMethod(1, method.getName(), desc.toString(), null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Exception");
        Label l3 = new Label();
        mv.visitTryCatchBlock(l0, l1, l3, "java/lang/NoClassDefFoundError");
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLineNumber(lineAddition + 1, l4);
        mv.visitVarInsn(25, 0);
        if (method.isAnnotationPresent(IgnoreDisabledProxy.class) || !normalResult) {
            mv.visitMethodInsn(182, className, "canTryAnyway", "()Z");
        } else {
            mv.visitMethodInsn(182, className, "isEnabled", "()Z");
        }
        Label l5 = new Label();
        mv.visitJumpInsn(153, l5);
        mv.visitLabel(l0);
        mv.visitLineNumber(lineAddition + 2, l0);
        if (normalResult) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "proxy", "L" + fieldName + ";");
            LogisticsWrapperHandler.addMethodParameterLoad(mv, method);
            mv.visitMethodInsn(185, fieldName, method.getName(), desc.toString());
            mv.visitLabel(l1);
            mv.visitInsn(returnType);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)Type.getType((String)resultClassL));
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "proxy", "L" + fieldName + ";");
            LogisticsWrapperHandler.addMethodParameterLoad(mv, method);
            mv.visitMethodInsn(185, fieldName, method.getName(), desc.toString());
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "dummyProxy", "L" + fieldName + ";");
            LogisticsWrapperHandler.addMethodParameterLoad(mv, method);
            mv.visitMethodInsn(185, fieldName, method.getName(), desc.toString());
            mv.visitMethodInsn(184, "logisticspipes/asm/wrapper/LogisticsWrapperHandler", "getWrappedSubProxy", "(Llogisticspipes/asm/wrapper/AbstractWrapper;Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, resultClass);
            mv.visitLabel(l1);
            mv.visitInsn(176);
        }
        mv.visitLabel(l2);
        mv.visitLineNumber(lineAddition + 3, l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
        mv.visitVarInsn(58, eIndex);
        Label l6 = new Label();
        mv.visitLabel(l6);
        mv.visitLineNumber(lineAddition + 4, l6);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, eIndex);
        mv.visitMethodInsn(182, className, "handleException", "(Ljava/lang/Throwable;)V");
        Label l7 = new Label();
        mv.visitLabel(l7);
        mv.visitJumpInsn(167, l5);
        mv.visitLabel(l3);
        mv.visitLineNumber(lineAddition + 5, l3);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/NoClassDefFoundError"});
        mv.visitVarInsn(58, eIndex);
        Label l8 = new Label();
        mv.visitLabel(l8);
        mv.visitLineNumber(lineAddition + 6, l8);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, eIndex);
        mv.visitMethodInsn(182, className, "handleException", "(Ljava/lang/Throwable;)V");
        mv.visitLabel(l5);
        mv.visitLineNumber(lineAddition + 7, l5);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "dummyProxy", "L" + fieldName + ";");
        LogisticsWrapperHandler.addMethodParameterLoad(mv, method);
        mv.visitMethodInsn(185, fieldName, method.getName(), desc.toString());
        mv.visitInsn(returnType);
        Label l9 = new Label();
        mv.visitLabel(l9);
        mv.visitLocalVariable("this", "L" + className + ";", null, l4, l9, 0);
        LogisticsWrapperHandler.addParameterVars(mv, method, l4, l9);
        mv.visitLocalVariable("e", "Ljava/lang/Exception;", null, l6, l7, eIndex);
        mv.visitLocalVariable("e", "Ljava/lang/NoClassDefFoundError;", null, l8, l5, eIndex);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void addMethodParameterLoad(MethodVisitor mv, Method method) {
        int i = 1;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
                    mv.visitVarInsn(21, i);
                    ++i;
                    continue;
                }
                if (clazz == Long.TYPE) {
                    mv.visitVarInsn(22, i);
                    i += 2;
                    continue;
                }
                if (clazz == Float.TYPE) {
                    mv.visitVarInsn(23, i);
                    ++i;
                    continue;
                }
                if (clazz == Double.TYPE) {
                    mv.visitVarInsn(24, i);
                    i += 2;
                    continue;
                }
                throw new UnsupportedOperationException("Unmapped clazz: " + clazz.getName());
            }
            mv.visitVarInsn(25, i);
            ++i;
        }
    }

    private static void addParameterVars(MethodVisitor mv, Method method, Label l3, Label l8) {
        int i = 1;
        for (Class<?> clazz : method.getParameterTypes()) {
            mv.visitLocalVariable("par" + i, LogisticsWrapperHandler.getClassSignature(clazz), null, l3, l8, i);
            if (clazz == Long.TYPE || clazz == Double.TYPE) {
                ++i;
            }
            ++i;
        }
    }

    private static String getPrimitiveMapping(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        throw new UnsupportedOperationException("Unmapped clazz: " + clazz.getName());
    }

    private static int getPrimitiveReturnMapping(Class<?> clazz) {
        if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            return 172;
        }
        if (clazz == Long.TYPE) {
            return 173;
        }
        if (clazz == Float.TYPE) {
            return 174;
        }
        if (clazz == Double.TYPE) {
            return 175;
        }
        throw new UnsupportedOperationException("Unmapped clazz: " + clazz.getName());
    }

    private static String getClassSignature(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return LogisticsWrapperHandler.getPrimitiveMapping(clazz);
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static void saveGeneratedClass(byte[] data, String transformedName, String folder) {
        File outFile;
        File outDir;
        if (tempFolder == null) {
            tempFolder = new File(Launch.minecraftHome, folder);
        }
        if (!(outDir = (outFile = new File(tempFolder, transformedName.replace('.', File.separatorChar) + ".class")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            LogWrapper.fine((String)"Saving transformed class \"%s\" to \"%s\"", (Object[])new Object[]{transformedName, outFile.getAbsolutePath().replace('\\', '/')});
            FileOutputStream output = new FileOutputStream(outFile);
            ((OutputStream)output).write(data);
            ((OutputStream)output).close();
        }
        catch (IOException ex) {
            LogWrapper.log((Level)Level.WARN, (Throwable)ex, (String)"Could not save transformed class \"%s\"", (Object[])new Object[]{transformedName});
        }
    }
}

