/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import logisticspipes.interfaces.IStack;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraft;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.tuples.Pair;

public class RequestTreeNode {
    private final IResource requestType;
    private final IAdditionalTargetInformation info;
    private final RequestTreeNode parentNode;
    protected final RequestTree root;
    private final List<RequestTreeNode> subRequests = new ArrayList<RequestTreeNode>();
    private final List<IPromise> promises = new ArrayList<IPromise>();
    private final List<IExtraPromise> extrapromises = new ArrayList<IExtraPromise>();
    private final List<IExtraPromise> byproducts = new ArrayList<IExtraPromise>();
    private final SortedSet<ICraftingTemplate> usedCrafters = new TreeSet<ICraftingTemplate>();
    private final Set<LogisticsOrderManager<?, ?>> usedExtrasFromManager = new HashSet();
    private ICraftingTemplate lastCrafterTried = null;
    private int promiseAmount = 0;

    protected RequestTreeNode(IResource requestType, RequestTreeNode parentNode, EnumSet<RequestTree.ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        this(null, requestType, parentNode, requestFlags, info);
    }

    private RequestTreeNode(ICraftingTemplate template, IResource requestType, RequestTreeNode parentNode, EnumSet<RequestTree.ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        this.info = info;
        this.parentNode = parentNode;
        this.requestType = requestType;
        if (parentNode != null) {
            parentNode.subRequests.add(this);
            this.root = parentNode.root;
        } else {
            this.root = (RequestTree)this;
        }
        if (template != null) {
            this.declareCrafterUsed(template);
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Provide) && this.checkProvider()) {
            return;
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Craft) && this.checkExtras()) {
            return;
        }
        if (!requestFlags.contains((Object)RequestTree.ActiveRequestType.Craft) || this.checkCrafting()) {
            // empty if block
        }
    }

    private boolean isCrafterUsed(ICraftingTemplate test) {
        if (!this.usedCrafters.isEmpty() && this.usedCrafters.contains(test)) {
            return true;
        }
        if (this.parentNode == null) {
            return false;
        }
        return this.parentNode.isCrafterUsed(test);
    }

    private boolean declareCrafterUsed(ICraftingTemplate test) {
        if (this.isCrafterUsed(test)) {
            return false;
        }
        this.usedCrafters.add(test);
        return true;
    }

    public int getPromiseAmount() {
        return this.promiseAmount;
    }

    public int getMissingAmount() {
        return this.requestType.getRequestedAmount() - this.promiseAmount;
    }

    public void addPromise(IPromise promise) {
        if (!promise.matches(this.requestType)) {
            throw new IllegalArgumentException("wrong item");
        }
        if (this.getMissingAmount() == 0) {
            throw new IllegalArgumentException("zero count needed, promises not needed.");
        }
        if (promise.getAmount() > this.getMissingAmount()) {
            int more = promise.getAmount() - this.getMissingAmount();
            this.extrapromises.add(promise.split(more));
        }
        if (promise.getAmount() <= 0) {
            throw new IllegalArgumentException("zero count ... again");
        }
        this.promises.add(promise);
        this.promiseAmount += promise.getAmount();
        this.root.promiseAdded(promise);
    }

    public boolean isDone() {
        return this.getMissingAmount() <= 0;
    }

    public boolean isAllDone() {
        boolean result = this.getMissingAmount() <= 0;
        for (RequestTreeNode node : this.subRequests) {
            result &= node.isAllDone();
        }
        return result;
    }

    protected void remove(RequestTreeNode subNode) {
        this.subRequests.remove(subNode);
        subNode.removeSubPromisses();
    }

    protected void removeSubPromisses() {
        for (IPromise promise : this.promises) {
            this.root.promiseRemoved(promise);
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeSubPromisses();
        }
    }

    protected void checkForExtras(IResource item, HashMap<IProvide, List<IExtraPromise>> extraMap) {
        for (IExtraPromise extra : this.extrapromises) {
            if (!item.matches(extra.getItemType(), IResource.MatchSettings.NORMAL)) continue;
            List extras = extraMap.computeIfAbsent(extra.getProvider(), k -> new LinkedList());
            extras.add(extra.copy());
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.checkForExtras(item, extraMap);
        }
    }

    protected void removeUsedExtras(IResource item, HashMap<IProvide, List<IExtraPromise>> extraMap) {
        block0: for (IPromise promise : this.promises) {
            IExtraPromise epromise;
            if (!item.matches(promise.getItemType(), IResource.MatchSettings.NORMAL) || !(promise instanceof IExtraPromise) || (epromise = (IExtraPromise)promise).isProvided()) continue;
            int usedcount = epromise.getAmount();
            List<IExtraPromise> extras = extraMap.get(epromise.getProvider());
            if (extras == null) continue;
            Iterator<IExtraPromise> it = extras.iterator();
            while (it.hasNext()) {
                IExtraPromise extra = it.next();
                if (extra.getAmount() >= usedcount) {
                    extra.lowerAmount(usedcount);
                    continue block0;
                }
                usedcount -= extra.getAmount();
                it.remove();
            }
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeUsedExtras(item, extraMap);
        }
    }

    protected LinkedLogisticsOrderList fullFill() {
        LinkedLogisticsOrderList list = new LinkedLogisticsOrderList();
        for (RequestTreeNode requestTreeNode : this.subRequests) {
            list.getSubOrders().add(requestTreeNode.fullFill());
        }
        for (IPromise iPromise : this.promises) {
            IOrderInfoProvider result = iPromise.fullFill(this.requestType, this.info);
            if (result == null) continue;
            list.add(result);
        }
        for (IExtraPromise iExtraPromise : this.extrapromises) {
            iExtraPromise.registerExtras(this.requestType);
        }
        for (IExtraPromise iExtraPromise : this.byproducts) {
            iExtraPromise.registerExtras(this.requestType);
        }
        return list;
    }

    protected void buildMissingMap(Map<IResource, Integer> missing) {
        if (this.getMissingAmount() != 0) {
            Integer count = missing.get(this.getRequestType());
            if (count == null) {
                count = 0;
            }
            count = count + this.getMissingAmount();
            missing.put(this.getRequestType(), count);
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.buildMissingMap(missing);
        }
    }

    protected void buildUsedMap(Map<IResource, Integer> used, Map<IResource, Integer> missing) {
        Integer count;
        int usedcount = 0;
        for (IPromise promise : this.promises) {
            if (promise.getType() != IOrderInfoProvider.ResourceType.PROVIDER) continue;
            usedcount += promise.getAmount();
        }
        if (usedcount != 0) {
            count = used.get(this.getRequestType());
            if (count == null) {
                count = 0;
            }
            count = count + usedcount;
            used.put(this.getRequestType(), count);
        }
        if (this.getMissingAmount() != 0) {
            count = missing.get(this.getRequestType());
            if (count == null) {
                count = 0;
            }
            count = count + this.getMissingAmount();
            missing.put(this.getRequestType(), count);
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.buildUsedMap(used, missing);
        }
    }

    private boolean checkProvider() {
        CoreRoutedPipe thisPipe = this.requestType.getRouter().getCachedPipe();
        if (thisPipe == null) {
            return false;
        }
        for (Pair<IProvide, List<IFilter>> provider : RequestTreeNode.getProviders(this.requestType.getRouter(), this.getRequestType())) {
            if (this.isDone()) break;
            if (provider.getValue1() == null || provider.getValue1().getRouter() == null || provider.getValue1().getRouter().getPipe() == null || thisPipe.sharesInterestWith(provider.getValue1().getRouter().getPipe())) continue;
            provider.getValue1().canProvide(this, this.root, provider.getValue2());
        }
        return this.isDone();
    }

    private static List<Pair<IProvide, List<IFilter>>> getProviders(IRouter destination, IResource item) {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(item);
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            List<ExitRoute> e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.isValidCache() && (e = destination.getDistanceTo(r)) != null) {
                validSources.addAll(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        validSources.sort(new RequestTree.workWeightedSorter(1.0));
        LinkedList<Pair<IProvide, List<IFilter>>> providers = new LinkedList<Pair<IProvide, List<IFilter>>>();
        for (ExitRoute r : validSources) {
            CoreRoutedPipe pipe;
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !((pipe = r.destination.getPipe()) instanceof IProvide)) continue;
            LinkedList<IFilter> list = new LinkedList<IFilter>(r.filters);
            providers.add(new Pair<IProvide, LinkedList<IFilter>>((IProvide)((Object)pipe), list));
        }
        return providers;
    }

    private boolean checkExtras() {
        LinkedList<IExtraPromise> map = this.root.getExtrasFor(this.requestType);
        for (IExtraPromise extraPromise : map) {
            if (this.isDone()) break;
            if (extraPromise.getAmount() == 0) continue;
            boolean valid = false;
            List<ExitRoute> sources = extraPromise.getProvider().getRouter().getRouteTable().get(this.getRequestType().getRouter().getSimpleID());
            block1: for (ExitRoute source : sources) {
                if (source == null || !source.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
                for (ExitRoute node : this.getRequestType().getRouter().getIRoutersByCost()) {
                    if (node.destination != extraPromise.getProvider().getRouter() || !node.containsFlag(PipeRoutingConnectionType.canRequestFrom)) continue;
                    valid = true;
                    break block1;
                }
            }
            if (!valid) continue;
            extraPromise.setAmount(Math.min(extraPromise.getAmount(), this.getMissingAmount()));
            this.addPromise(extraPromise);
        }
        return this.isDone();
    }

    private boolean checkCrafting() {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(this.getRequestType());
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            List<ExitRoute> e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.isValidCache() && (e = this.getRequestType().getRouter().getDistanceTo(r)) != null) {
                validSources.addAll(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        RequestTree.workWeightedSorter wSorter = new RequestTree.workWeightedSorter(0.0);
        validSources.sort(wSorter);
        List<Pair<ICraftingTemplate, List<IFilter>>> allCraftersForItem = RequestTreeNode.getCrafters(this.getRequestType(), validSources);
        Iterator<Pair<ICraftingTemplate, List<IFilter>>> iterAllCrafters = allCraftersForItem.iterator();
        PriorityQueue<CraftingSorterNode> craftersSamePriority = new PriorityQueue<CraftingSorterNode>(5);
        ArrayList craftersToBalance = new ArrayList();
        boolean done = false;
        Pair<ICraftingTemplate, List<IFilter>> lastCrafter = null;
        int currentPriority = 0;
        block1: while (!done) {
            if (iterAllCrafters.hasNext()) {
                if (lastCrafter == null) {
                    lastCrafter = iterAllCrafters.next();
                }
            } else if (lastCrafter == null) {
                done = true;
            }
            int itemsNeeded = this.getMissingAmount();
            if (lastCrafter != null && (craftersSamePriority.isEmpty() || currentPriority == lastCrafter.getValue1().getPriority())) {
                currentPriority = lastCrafter.getValue1().getPriority();
                Pair<ICraftingTemplate, List<IFilter>> crafter = lastCrafter;
                lastCrafter = null;
                ICraftingTemplate template = crafter.getValue1();
                if (this.isCrafterUsed(template) || !template.canCraft(this.getRequestType())) continue;
                for (IFilter filter : crafter.getValue2()) {
                    if (filter.isBlocked() != filter.isFilteredItem(template.getResultResource()) && !filter.blockCrafting()) continue;
                    continue block1;
                }
                CraftingSorterNode cn = new CraftingSorterNode(crafter, itemsNeeded, this.root, this);
                craftersSamePriority.add(cn);
                continue;
            }
            if (craftersToBalance.isEmpty() && (craftersSamePriority == null || craftersSamePriority.isEmpty())) continue;
            if (craftersSamePriority.size() == 1) {
                craftersToBalance.add(craftersSamePriority.poll());
                ((CraftingSorterNode)craftersToBalance.get(0)).addToWorkRequest(itemsNeeded);
            } else {
                if (!craftersSamePriority.isEmpty()) {
                    craftersToBalance.add(craftersSamePriority.poll());
                }
                while (!craftersToBalance.isEmpty() && itemsNeeded > 0) {
                    while (!craftersSamePriority.isEmpty() && ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() <= ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo()) {
                        craftersToBalance.add(craftersSamePriority.poll());
                    }
                    int cap = !craftersSamePriority.isEmpty() ? ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() : Integer.MAX_VALUE;
                    int floor = ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo();
                    cap = Math.min(cap, floor + (itemsNeeded + craftersToBalance.size() - 1) / craftersToBalance.size());
                    for (CraftingSorterNode crafter : craftersToBalance) {
                        int request = Math.min(itemsNeeded, cap - floor);
                        if (request <= 0) continue;
                        int craftingDone = crafter.addToWorkRequest(request);
                        itemsNeeded -= craftingDone;
                    }
                }
            }
            craftersToBalance.removeIf(c -> ((CraftingSorterNode)c).stacksOfWorkRequested > 0 && !c.addWorkPromisesToTree());
            itemsNeeded = this.getMissingAmount();
            if (itemsNeeded <= 0) break;
            if (craftersToBalance.isEmpty()) continue;
            done = false;
        }
        return this.isDone();
    }

    public boolean hasBeenQueried(LogisticsOrderManager<?, ?> orderManager) {
        return this.usedExtrasFromManager.contains(orderManager);
    }

    public void setQueried(LogisticsOrderManager<?, ?> orderManager) {
        this.usedExtrasFromManager.add(orderManager);
    }

    private static List<Pair<ICraftingTemplate, List<IFilter>>> getCrafters(IResource iRequestType, List<ExitRoute> validDestinations) {
        ArrayList<Pair<ICraftingTemplate, List<IFilter>>> crafters = new ArrayList<Pair<ICraftingTemplate, List<IFilter>>>(validDestinations.size());
        for (ExitRoute r : validDestinations) {
            ICraftingTemplate craftable;
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(pipe instanceof ICraft) || (craftable = ((ICraft)((Object)pipe)).addCrafting(iRequestType)) == null) continue;
            for (IFilter filter : r.filters) {
                if (filter.isBlocked() != filter.isFilteredItem(craftable.getResultResource()) && !filter.blockCrafting()) continue;
            }
            LinkedList<IFilter> list = new LinkedList<IFilter>(r.filters);
            crafters.add(new Pair<ICraftingTemplate, LinkedList<IFilter>>(craftable, list));
        }
        return crafters;
    }

    private int getSubRequests(int nCraftingSets, ICraftingTemplate template) {
        boolean failed = false;
        List<Pair<IResource, IAdditionalTargetInformation>> stacks = template.getComponents(nCraftingSets);
        int workSetsAvailable = nCraftingSets;
        ArrayList<RequestTreeNode> lastNodes = new ArrayList<RequestTreeNode>(stacks.size());
        for (Pair<IResource, IAdditionalTargetInformation> stack : stacks) {
            RequestTreeNode node = new RequestTreeNode(template, stack.getValue1(), this, RequestTree.defaultRequestFlags, stack.getValue2());
            lastNodes.add(node);
            if (node.isDone()) continue;
            failed = true;
        }
        if (failed) {
            for (RequestTreeNode n : lastNodes) {
                n.destroy();
            }
            this.lastCrafterTried = template;
            for (int i = 0; i < stacks.size(); ++i) {
                workSetsAvailable = Math.min(workSetsAvailable, ((RequestTreeNode)lastNodes.get(i)).getPromiseAmount() / (stacks.get(i).getValue1().getRequestedAmount() / nCraftingSets));
            }
            return this.generateRequestTreeFor(workSetsAvailable, template);
        }
        this.byproducts.addAll(template.getByproducts(workSetsAvailable));
        return workSetsAvailable;
    }

    private int generateRequestTreeFor(int workSets, ICraftingTemplate template) {
        ArrayList<RequestTreeNode> newChildren = new ArrayList<RequestTreeNode>();
        if (workSets > 0) {
            List<Pair<IResource, IAdditionalTargetInformation>> stacks = template.getComponents(workSets);
            boolean failed = false;
            for (Pair<IResource, IAdditionalTargetInformation> stack : stacks) {
                RequestTreeNode node = new RequestTreeNode(template, stack.getValue1(), this, RequestTree.defaultRequestFlags, stack.getValue2());
                newChildren.add(node);
                if (node.isDone()) continue;
                failed = true;
            }
            if (failed) {
                for (RequestTreeNode c : newChildren) {
                    c.destroy();
                }
                return 0;
            }
        }
        this.byproducts.addAll(template.getByproducts(workSets));
        return workSets;
    }

    void recurseFailedRequestTree() {
        if (this.isDone()) {
            return;
        }
        if (this.lastCrafterTried == null) {
            return;
        }
        ICraftingTemplate template = this.lastCrafterTried;
        IStack resultStack = template.getResultStack();
        int nCraftingSetsNeeded = (this.getMissingAmount() + resultStack.getStackSize() - 1) / resultStack.getStackSize();
        List<Pair<IResource, IAdditionalTargetInformation>> stacks = template.getComponents(nCraftingSetsNeeded);
        for (Pair<IResource, IAdditionalTargetInformation> stack : stacks) {
            new RequestTreeNode(template, stack.getValue1(), this, RequestTree.defaultRequestFlags, stack.getValue2());
        }
        this.addPromise(template.generatePromise(nCraftingSetsNeeded));
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.recurseFailedRequestTree();
        }
    }

    protected void logFailedRequestTree(RequestLog log) {
        HashMap<IResource, Integer> missing = new HashMap<IResource, Integer>();
        for (RequestTreeNode node : this.subRequests) {
            if (!(node instanceof RequestTree) || node.isDone()) continue;
            node.recurseFailedRequestTree();
            node.buildMissingMap(missing);
        }
        log.handleMissingItems(RequestTreeNode.shrinkToList(missing));
    }

    private void destroy() {
        this.parentNode.remove(this);
    }

    protected static List<IResource> shrinkToList(Map<IResource, Integer> items) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        block0: for (Map.Entry<IResource, Integer> entry : items.entrySet()) {
            for (IResource resource : resources) {
                if (!resource.mergeForDisplay(entry.getKey(), entry.getValue())) continue;
                continue block0;
            }
            resources.add(entry.getKey().copyForDisplayWith(entry.getValue()));
        }
        return resources;
    }

    public IResource getRequestType() {
        return this.requestType;
    }

    private class CraftingSorterNode
    implements Comparable<CraftingSorterNode> {
        private int stacksOfWorkRequested;
        private final int setSize;
        private final int maxWorkSetsAvailable;
        private final RequestTreeNode treeNode;
        public final Pair<ICraftingTemplate, List<IFilter>> crafter;
        public final int originalToDo;

        CraftingSorterNode(Pair<ICraftingTemplate, List<IFilter>> crafter, int maxCount, RequestTree tree, RequestTreeNode treeNode) {
            this.crafter = crafter;
            this.treeNode = treeNode;
            this.originalToDo = crafter.getValue1().getCrafter().getTodo();
            this.stacksOfWorkRequested = 0;
            this.setSize = crafter.getValue1().getResultStack().getStackSize();
            this.maxWorkSetsAvailable = (treeNode.getMissingAmount() + this.setSize - 1) / this.setSize;
        }

        int calculateMaxWork(int maxSetsToCraft) {
            int nCraftingSetsNeeded = maxSetsToCraft == 0 ? (this.treeNode.getMissingAmount() + this.setSize - 1) / this.setSize : maxSetsToCraft;
            if (nCraftingSetsNeeded == 0) {
                return 0;
            }
            ICraftingTemplate template = this.crafter.getValue1();
            return RequestTreeNode.this.getSubRequests(nCraftingSetsNeeded, template);
        }

        int addToWorkRequest(int extraWork) {
            int stacksRequested = (extraWork + this.setSize - 1) / this.setSize;
            this.stacksOfWorkRequested += stacksRequested;
            return stacksRequested * this.setSize;
        }

        boolean addWorkPromisesToTree() {
            ICraftingTemplate template = this.crafter.getValue1();
            int setsToCraft = Math.min(this.stacksOfWorkRequested, this.maxWorkSetsAvailable);
            int setsAbleToCraft = this.calculateMaxWork(setsToCraft);
            if (setsAbleToCraft > 0) {
                IPromise job = template.generatePromise(setsAbleToCraft);
                if (job.getAmount() != setsAbleToCraft * this.setSize) {
                    throw new IllegalStateException("generatePromises not creating the promisesPromised; this is goign to end badly.");
                }
                this.treeNode.addPromise(job);
            }
            boolean isDone = setsToCraft == setsAbleToCraft;
            this.stacksOfWorkRequested = 0;
            return isDone;
        }

        @Override
        public int compareTo(CraftingSorterNode o) {
            return this.currentToDo() - o.currentToDo();
        }

        public int currentToDo() {
            return this.originalToDo + this.stacksOfWorkRequested * this.setSize;
        }
    }
}

