/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import logisticspipes.asm.addinfo.IAddInfo;
import logisticspipes.asm.addinfo.IAddInfoProvider;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.utils.FinalNBTTagCompound;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class FluidIdentifier
implements ILPCCTypeHolder {
    private static final ReadWriteLock dblock = new ReentrantReadWriteLock();
    private static final Lock rlock = dblock.readLock();
    private static final Lock wlock = dblock.writeLock();
    private static final HashMap<Integer, FluidIdentifier> _fluidIdentifierIdCache = new HashMap(256, 0.5f);
    private static final ArrayList<HashMap<FinalNBTTagCompound, FluidIdentifier>> _fluidIdentifierTagCache = new ArrayList(256);
    private static final ArrayList<FluidIdentifier> _fluidIdentifierCache = new ArrayList(256);
    public final int fluidID;
    public final String name;
    public final FinalNBTTagCompound tag;
    public final int uniqueID;
    private final ItemIdentifier itemIdentifier;
    private static boolean init = false;
    private Object ccObject;

    private FluidIdentifier(int fluidID, String name, FinalNBTTagCompound tag, int uniqueID) {
        this.fluidID = fluidID;
        this.name = name;
        this.tag = tag;
        this.uniqueID = uniqueID;
        this.itemIdentifier = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(this.makeFluidStack(0)).getItem();
    }

    public static FluidIdentifier get(Fluid fluid, NBTTagCompound tag, FluidIdentifier proposal) {
        FinalNBTTagCompound tagwithfixedname;
        FluidIdentifier unknownFluid;
        HashMap<FinalNBTTagCompound, FluidIdentifier> fluidNBTList;
        int fluidID = fluid.getID();
        if (tag == null) {
            FluidIdentifier ident;
            FluidAddInfo info;
            if (proposal != null && proposal.fluidID == fluidID && proposal.tag == null) {
                return proposal;
            }
            proposal = null;
            IAddInfoProvider prov = null;
            if (fluid instanceof IAddInfoProvider && (info = (prov = (IAddInfoProvider)fluid).getLogisticsPipesAddInfo(FluidAddInfo.class)) != null) {
                proposal = info.fluid;
            }
            if (proposal != (ident = FluidIdentifier.getFluidIdentifierWithoutTag(fluid, fluidID, proposal)) && prov != null) {
                prov.setLogisticsPipesAddInfo(new FluidAddInfo(ident));
            }
            return ident;
        }
        rlock.lock();
        if (fluidID < _fluidIdentifierTagCache.size() && (fluidNBTList = _fluidIdentifierTagCache.get(fluidID)) != null && (unknownFluid = fluidNBTList.get((Object)(tagwithfixedname = new FinalNBTTagCompound(tag)))) != null) {
            rlock.unlock();
            return unknownFluid;
        }
        rlock.unlock();
        wlock.lock();
        if (fluidID < _fluidIdentifierTagCache.size() && (fluidNBTList = _fluidIdentifierTagCache.get(fluidID)) != null && (unknownFluid = fluidNBTList.get((Object)(tagwithfixedname = new FinalNBTTagCompound(tag)))) != null) {
            wlock.unlock();
            return unknownFluid;
        }
        while (_fluidIdentifierTagCache.size() <= fluidID) {
            _fluidIdentifierTagCache.add(null);
        }
        fluidNBTList = _fluidIdentifierTagCache.get(fluidID);
        if (fluidNBTList == null) {
            fluidNBTList = new HashMap(16, 0.5f);
            _fluidIdentifierTagCache.set(fluidID, fluidNBTList);
        }
        FinalNBTTagCompound finaltag = new FinalNBTTagCompound((NBTTagCompound)tag.func_74737_b());
        int id = FluidIdentifier.getUnusedId();
        FluidIdentifier unknownFluid2 = new FluidIdentifier(fluidID, FluidRegistry.getFluidName((Fluid)fluid), finaltag, id);
        fluidNBTList.put(finaltag, unknownFluid2);
        _fluidIdentifierIdCache.put(id, unknownFluid2);
        wlock.unlock();
        return unknownFluid2;
    }

    private static FluidIdentifier getFluidIdentifierWithoutTag(Fluid fluid, int fluidID, FluidIdentifier proposal) {
        FluidIdentifier unknownFluid;
        if (proposal != null && proposal.fluidID == fluidID && proposal.tag == null) {
            return proposal;
        }
        rlock.lock();
        if (fluidID < _fluidIdentifierCache.size() && (unknownFluid = _fluidIdentifierCache.get(fluidID)) != null) {
            rlock.unlock();
            return unknownFluid;
        }
        rlock.unlock();
        wlock.lock();
        if (fluidID < _fluidIdentifierCache.size() && (unknownFluid = _fluidIdentifierCache.get(fluidID)) != null) {
            wlock.unlock();
            return unknownFluid;
        }
        int id = FluidIdentifier.getUnusedId();
        FluidIdentifier unknownFluid2 = new FluidIdentifier(fluidID, FluidRegistry.getFluidName((Fluid)fluid), null, id);
        while (_fluidIdentifierCache.size() <= fluidID) {
            _fluidIdentifierCache.add(null);
        }
        _fluidIdentifierCache.set(fluidID, unknownFluid2);
        _fluidIdentifierIdCache.put(id, unknownFluid2);
        wlock.unlock();
        return unknownFluid2;
    }

    public static FluidIdentifier get(FluidStack stack) {
        FluidIdentifier ident;
        FluidStackAddInfo info;
        FluidIdentifier proposal = null;
        IAddInfoProvider prov = null;
        if (stack instanceof IAddInfoProvider && (info = (prov = (IAddInfoProvider)stack).getLogisticsPipesAddInfo(FluidStackAddInfo.class)) != null) {
            proposal = info.fluid;
        }
        if (proposal != (ident = FluidIdentifier.get(stack.getFluid(), stack.tag, proposal)) && stack.tag == null && prov != null) {
            prov.setLogisticsPipesAddInfo(new FluidStackAddInfo(ident));
        }
        return ident;
    }

    public static FluidIdentifier get(ItemIdentifier stack) {
        return FluidIdentifier.get(stack.makeStack(1));
    }

    public static FluidIdentifier get(ItemStack stack) {
        return FluidIdentifier.get(ItemIdentifierStack.getFromStack(stack));
    }

    public static FluidIdentifier get(ItemIdentifierStack stack) {
        FluidStack f = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(stack);
        if (f == null) {
            return null;
        }
        return FluidIdentifier.get(f);
    }

    private static FluidIdentifier get(Fluid fluid) {
        return FluidIdentifier.get(fluid, null, null);
    }

    private static int getUnusedId() {
        int id = new Random().nextInt();
        while (FluidIdentifier.isIdUsed(id)) {
            id = new Random().nextInt();
        }
        return id;
    }

    private static boolean isIdUsed(int id) {
        return _fluidIdentifierIdCache.containsKey(id);
    }

    public String getName() {
        return this.name;
    }

    public FluidStack makeFluidStack(int amount) {
        return new FluidStack(this.fluidID, amount, (NBTTagCompound)this.tag);
    }

    public int getFreeSpaceInsideTank(IFluidHandler container, ForgeDirection dir) {
        int free = 0;
        FluidTankInfo[] tanks = container.getTankInfo(dir);
        if (tanks != null && tanks.length > 0) {
            for (FluidTankInfo tank : tanks) {
                free += this.getFreeSpaceInsideTank(tank);
            }
        }
        return free;
    }

    private int getFreeSpaceInsideTank(FluidTankInfo tanks) {
        if (tanks == null) {
            return 0;
        }
        FluidStack liquid = tanks.fluid;
        if (liquid == null || liquid.getFluidID() <= 0) {
            return tanks.capacity;
        }
        if (FluidIdentifier.get(liquid).equals(this)) {
            return tanks.capacity - liquid.amount;
        }
        return 0;
    }

    public int getFreeSpaceInsideTank(IFluidTank tank) {
        FluidStack liquid = tank.getFluid();
        if (liquid == null || liquid.getFluidID() <= 0) {
            return tank.getCapacity();
        }
        if (FluidIdentifier.get(liquid).equals(this)) {
            return tank.getCapacity() - liquid.amount;
        }
        return 0;
    }

    public static void initFromForge(boolean flag) {
        if (init) {
            return;
        }
        Map fluids = FluidRegistry.getRegisteredFluids();
        for (Fluid fluid : fluids.values()) {
            FluidIdentifier.get(fluid);
        }
        if (flag) {
            init = true;
        }
    }

    public String toString() {
        String t = this.tag != null ? this.tag.toString() : "null";
        return this.name + "/" + this.fluidID + ":" + t;
    }

    public FluidIdentifier next() {
        rlock.lock();
        boolean takeNext = false;
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (takeNext && i != null) {
                rlock.unlock();
                return i;
            }
            if (!this.equals(i)) continue;
            takeNext = true;
        }
        rlock.unlock();
        return null;
    }

    public FluidIdentifier prev() {
        rlock.lock();
        FluidIdentifier last = null;
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (this.equals(i)) {
                rlock.unlock();
                return last;
            }
            if (i == null) continue;
            last = i;
        }
        rlock.unlock();
        return last;
    }

    public static FluidIdentifier first() {
        rlock.lock();
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (i == null) continue;
            rlock.unlock();
            return i;
        }
        rlock.unlock();
        return null;
    }

    public static FluidIdentifier last() {
        rlock.lock();
        FluidIdentifier last = null;
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (i == null) continue;
            last = i;
        }
        rlock.unlock();
        return last;
    }

    public static List<FluidIdentifier> all() {
        rlock.lock();
        List<FluidIdentifier> list = Collections.unmodifiableList(_fluidIdentifierCache);
        rlock.unlock();
        return list;
    }

    @Override
    public void setCCType(Object type) {
        this.ccObject = type;
    }

    @Override
    public Object getCCType() {
        return this.ccObject;
    }

    public ItemIdentifier getItemIdentifier() {
        return this.itemIdentifier;
    }

    private static class FluidAddInfo
    implements IAddInfo {
        private final FluidIdentifier fluid;

        public FluidAddInfo(FluidIdentifier fluid) {
            this.fluid = fluid;
        }
    }

    private static class FluidStackAddInfo
    implements IAddInfo {
        private final FluidIdentifier fluid;

        public FluidStackAddInfo(FluidIdentifier fluid) {
            this.fluid = fluid;
        }
    }
}

