/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import java.io.IOException;
import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class DebugTargetResponse
extends ModernPacket {
    private TargetMode mode;
    private int[] additions = new int[0];

    public DebugTargetResponse(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.mode = TargetMode.values()[data.readByte()];
        int size = data.readInt();
        this.additions = new int[size];
        for (int i = 0; i < size; ++i) {
            this.additions[i] = data.readInt();
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (this.mode == TargetMode.None) {
            player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.RED) + "No Target Found"));
        } else if (this.mode == TargetMode.Block) {
            int x = this.additions[0];
            int y = this.additions[1];
            int z = this.additions[2];
            player.func_146105_b((IChatComponent)new ChatComponentText("Checking Block at: x:" + x + " y:" + y + " z:" + z));
            Block id = player.field_70170_p.func_147439_a(x, y, z);
            player.func_146105_b((IChatComponent)new ChatComponentText("Found Block with Id: " + id.getClass()));
            TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
            if (tile == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.RED) + "No TileEntity found"));
            } else {
                LPChatListener.addTask(() -> {
                    player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.GREEN) + "Starting debuging of TileEntity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + tile.getClass().getSimpleName()));
                    DebugGuiController.instance().startWatchingOf(tile, player);
                    MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                    return true;
                }, (ICommandSender)player);
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Start debuging of TileEntity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + tile.getClass().getSimpleName() + (Object)((Object)ChatColor.AQUA) + "? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        } else if (this.mode == TargetMode.Entity) {
            int entityId = this.additions[0];
            Entity entity = player.field_70170_p.func_73045_a(entityId);
            if (entity == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.RED) + "No Entity found"));
            } else {
                LPChatListener.addTask(() -> {
                    player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.GREEN) + "Starting debuging of Entity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + entity.getClass().getSimpleName()));
                    DebugGuiController.instance().startWatchingOf(entity, player);
                    MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                    return true;
                }, (ICommandSender)player);
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Start debuging of Entity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + entity.getClass().getSimpleName() + (Object)((Object)ChatColor.AQUA) + "? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeByte(this.mode.ordinal());
        data.writeInt(this.additions.length);
        for (int addition : this.additions) {
            data.writeInt(addition);
        }
    }

    @Override
    public ModernPacket template() {
        return new DebugTargetResponse(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public TargetMode getMode() {
        return this.mode;
    }

    public DebugTargetResponse setMode(TargetMode mode) {
        this.mode = mode;
        return this;
    }

    public int[] getAdditions() {
        return this.additions;
    }

    public DebugTargetResponse setAdditions(int[] additions) {
        this.additions = additions;
        return this;
    }

    public static enum TargetMode {
        Block,
        Entity,
        None;

    }
}

