/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.FluidSlotSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.slot.FluidSlot;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import logisticspipes.api.IMUICompatiblePipe;
import logisticspipes.compat.ModularUIHelper;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.migration.LegacyHelper;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PipeFluidSupplierMk2
extends FluidRoutedPipe
implements IRequestFluid,
IRequireReliableFluidTransport,
IMUICompatiblePipe {
    private static final Logger log = LogManager.getLogger(PipeFluidSupplierMk2.class);
    private boolean _lastRequestFailed = false;
    private final FluidTank phantomTank = new FluidTank(1);
    private int amount = 0;
    private boolean requestPartials = false;
    private int refillThreshold = 0;
    private final TObjectIntMap<FluidIdentifier> _requestedItems = new TObjectIntHashMap(8, 0.5f, -1);

    @Override
    public void addUIWidgets(ModularPanel panel, PosGuiData data, PanelSyncManager syncManager) {
        ((ModularPanel)panel.background(new IDrawable[]{ModularUIHelper.BACKGROUND_TEXTURE})).bindPlayerInventory().child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().widthRel(1.0f)).top(6)).coverChildrenHeight()).child((IWidget)((Flow)((Flow)new Row().mainAxisAlignment(Alignment.MainAxis.CENTER).crossAxisAlignment(Alignment.CrossAxis.CENTER).widthRel(1.0f)).coverChildrenHeight()).child((IWidget)IKey.lang((String)"gui.fluidsuppliermk2.TargetInv").asWidget()))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().mainAxisAlignment(Alignment.MainAxis.CENTER).crossAxisAlignment(Alignment.CrossAxis.CENTER).marginTop(5)).coverChildrenHeight()).child((IWidget)IKey.comp((IKey[])new IKey[]{IKey.lang((String)"gui.fluidsuppliermk2.Fluid"), IKey.str((String)":")}).asWidget())).child((IWidget)((FluidSlot)((FluidSlot)new FluidSlot().syncHandler(new FluidSlotSyncHandler((IFluidTank)this.phantomTank).phantom(true).controlsAmount(false)).marginLeft(6)).width(16)).height(16))).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().marginLeft(6)).width(80)).setNumbers(0, Integer.MAX_VALUE).value((IStringValue)SyncHandlers.intNumber(() -> this.amount, value -> {
            this.amount = value;
        })))).child((IWidget)IKey.str((String)"mB").asWidget().marginLeft(3)))).child((IWidget)((Flow)((Flow)((Flow)new Row().mainAxisAlignment(Alignment.MainAxis.CENTER).crossAxisAlignment(Alignment.CrossAxis.CENTER).marginTop(5)).coverChildrenHeight()).child((IWidget)IKey.comp((IKey[])new IKey[]{IKey.lang((String)"gui.fluidsuppliermk2.partial"), IKey.str((String)":")}).asWidget())).child((IWidget)((CycleButtonWidget)((CycleButtonWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().marginLeft(6)).width(24)).value((IIntValue)SyncHandlers.bool(() -> this.requestPartials, value -> {
            this.requestPartials = value;
        })).overlay(new IDrawable[]{IKey.lang(() -> this.requestPartials ? "gui.fluidsuppliermk2.partial.yes" : "gui.fluidsuppliermk2.partial.no")})).tooltipBuilder(tooltip -> {
            tooltip.addLine((IDrawable)IKey.lang((String)"gui.fluidsuppliermk2.partial.tip"));
            if (this.requestPartials) {
                tooltip.addLine((IDrawable)IKey.lang((String)"gui.fluidsuppliermk2.partial.yes.tip"));
            } else {
                tooltip.addLine((IDrawable)IKey.lang((String)"gui.fluidsuppliermk2.partial.no.tip"));
            }
        })).tooltipPos(RichTooltip.Pos.ABOVE)))).child((IWidget)((Flow)((Flow)new Row().mainAxisAlignment(Alignment.MainAxis.CENTER).crossAxisAlignment(Alignment.CrossAxis.CENTER).marginTop(5)).coverChildrenHeight()).child((IWidget)IKey.comp((IKey[])new IKey[]{IKey.lang((String)"gui.fluidsuppliermk2.refill_if_depleted"), IKey.str((String)":")}).asWidget()))).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().marginTop(5)).mainAxisAlignment(Alignment.MainAxis.CENTER).coverChildrenHeight()).child((IWidget)((TextFieldWidget)new TextFieldWidget().width(80)).setNumbers(0, Integer.MAX_VALUE).value((IStringValue)SyncHandlers.intNumber(() -> this.refillThreshold, value -> {
            this.refillThreshold = value;
        })))).child((IWidget)IKey.str((String)"mB").asWidget().marginLeft(3))).child((IWidget)((TextWidget)((TextWidget)IKey.str((String)"\u00a79[?]").asWidget().marginLeft(6)).tooltipBuilder(tooltip -> {
            tooltip.setAutoUpdate(true);
            tooltip.addLine((IDrawable)IKey.lang((String)"gui.fluidsuppliermk2.refill_if_depleted.tip", (Object[])new Object[]{this.refillThreshold != 0 ? Integer.valueOf(this.refillThreshold) : "n"}));
            tooltip.addLine((IDrawable)IKey.lang((String)"gui.fluidsuppliermk2.refill_if_depleted.tip.zero"));
        })).tooltipPos(RichTooltip.Pos.ABOVE))));
    }

    @Override
    public String getId() {
        return "fluid_supplier_mk2";
    }

    @Override
    public int getGuiWidth() {
        return 184;
    }

    @Override
    public int getGuiHeight() {
        return 186;
    }

    public PipeFluidSupplierMk2(Item item) {
        super(item);
        this.throttleTime = 100;
    }

    @Override
    public void sendFailed(FluidIdentifier value1, Integer value2) {
        this.liquidLost(value1, value2);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_MK2_TEXTURE;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    protected void fillSide(FluidStack toFill, ForgeDirection tankLocation, IFluidHandler tile) {
        if (this.phantomTank.getFluid() == null) {
            return;
        }
        int have = 0;
        for (FluidTankInfo info : tile.getTankInfo(ForgeDirection.UNKNOWN)) {
            if (info.fluid == null || !info.fluid.isFluidEqual(this.phantomTank.getFluid())) continue;
            have += info.fluid.amount;
        }
        int vacant = this.amount - have;
        if (vacant <= 0) {
            return;
        }
        if (this.refillThreshold != 0 && vacant < this.refillThreshold) {
            return;
        }
        FluidStack filled = toFill.copy();
        filled.amount = Math.min(filled.amount, vacant);
        toFill.amount -= tile.fill(tankLocation.getOpposite(), filled, true);
    }

    @Override
    public void throttledUpdateEntity() {
        if (!this.isEnabled()) {
            return;
        }
        if (MainProxy.isClient(this.container.getWorld())) {
            return;
        }
        super.throttledUpdateEntity();
        if (this.phantomTank.getFluid() == null) {
            return;
        }
        TObjectIntHashMap requestDiscount = new TObjectIntHashMap(this._requestedItems);
        FluidTank centerTank = ((PipeFluidTransportLogistics)this.transport).internalTank;
        if (centerTank != null && centerTank.getFluid() != null) {
            requestDiscount.adjustOrPutValue((Object)FluidIdentifier.get(centerTank.getFluid()), centerTank.getFluid().amount, centerTank.getFluid().amount);
        }
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            FluidTank sideTank;
            FluidTankInfo[] result;
            IFluidHandler container;
            if (!(tile.tile instanceof IFluidHandler) || SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile) || (container = (IFluidHandler)tile.tile).getTankInfo(ForgeDirection.UNKNOWN) == null || container.getTankInfo(ForgeDirection.UNKNOWN).length == 0) continue;
            TObjectIntHashMap wantFluids = new TObjectIntHashMap(8);
            FluidIdentifier fIdent = FluidIdentifier.get(this.phantomTank.getFluid());
            wantFluids.put((Object)fIdent, this.amount);
            for (FluidTankInfo slot : result = container.getTankInfo(ForgeDirection.UNKNOWN)) {
                if (slot == null || slot.fluid == null || slot.fluid.getFluidID() == 0) continue;
                wantFluids.adjustValue((Object)FluidIdentifier.get(slot.fluid), -slot.fluid.amount);
            }
            if (tile.orientation.ordinal() < ((PipeFluidTransportLogistics)this.transport).sideTanks.length && (sideTank = ((PipeFluidTransportLogistics)this.transport).sideTanks[tile.orientation.ordinal()]) != null && sideTank.getFluid() != null) {
                wantFluids.adjustValue((Object)FluidIdentifier.get(sideTank.getFluid()), -sideTank.getFluid().amount);
            }
            TObjectIntIterator iter = requestDiscount.iterator();
            while (iter.hasNext()) {
                iter.advance();
                wantFluids.adjustValue((Object)((FluidIdentifier)iter.key()), -iter.value());
            }
            this.setRequestFailed(false);
            iter = wantFluids.iterator();
            while (iter.hasNext()) {
                iter.advance();
                FluidIdentifier need = (FluidIdentifier)iter.key();
                int countToRequest = iter.value();
                if (countToRequest <= 0 || this.refillThreshold != 0 && countToRequest < this.refillThreshold) continue;
                if (!this.useEnergy(11)) continue block0;
                boolean success = false;
                if (this.requestPartials) {
                    if ((countToRequest = RequestTree.requestFluidPartial(need, countToRequest, this, null)) > 0) {
                        success = true;
                    }
                } else {
                    success = RequestTree.requestFluid(need, countToRequest, this, null);
                }
                if (success) {
                    this._requestedItems.adjustOrPutValue((Object)need, countToRequest, countToRequest);
                    continue;
                }
                this.setRequestFailed(true);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("items")) {
            LegacyHelper.readItemIdentifierInventoryAndConvertToTank(this.phantomTank, compound, "");
        } else {
            this.phantomTank.readFromNBT(compound.func_74775_l("tank"));
        }
        if (compound.func_74764_b("_bucketMinimum")) {
            byte bucketMinimum = compound.func_74771_c("_bucketMinimum");
            if (bucketMinimum == 0) {
                this.refillThreshold = 0;
            }
            if (bucketMinimum == 1) {
                this.refillThreshold = 1000;
            }
            if (bucketMinimum == 2) {
                this.refillThreshold = 2000;
            }
            if (bucketMinimum == 3) {
                this.refillThreshold = 5000;
            }
        } else {
            this.refillThreshold = compound.func_74762_e("refillThreshold");
        }
        this.requestPartials = compound.func_74767_n("requestpartials");
        this.amount = compound.func_74762_e("amount");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74757_a("requestpartials", this.requestPartials);
        compound.func_74768_a("amount", this.amount);
        compound.func_74768_a("refillThreshold", this.refillThreshold);
        compound.func_74782_a("tank", (NBTBase)this.phantomTank.writeToNBT(new NBTTagCompound()));
    }

    private void decreaseRequested(FluidIdentifier liquid, int remaining) {
        int count = this._requestedItems.get((Object)liquid);
        if (count <= 0) {
            return;
        }
        if (count <= remaining) {
            this._requestedItems.remove((Object)liquid);
        } else {
            this._requestedItems.put((Object)liquid, count - remaining);
        }
        if (remaining > count) {
            this.debug.log("liquid supplier got unexpected item %s", liquid.toString());
        }
    }

    @Override
    public void liquidLost(FluidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
    }

    @Override
    public void liquidArrived(FluidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
        this.delayThrottle();
    }

    @Override
    public void liquidNotInserted(FluidIdentifier item, int amount) {
    }

    @Override
    public void onWrenchClicked(EntityPlayer player) {
        this.openGui(player, this);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

