/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.SimpleGraphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public final class GuiGraphics {
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot.png");
    public static final ResourceLocation BIG_SLOT_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot-big.png");
    public static final ResourceLocation SMALL_SLOT_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/slot-small.png");
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/GuiBackground.png");
    public static final ResourceLocation LOCK_ICON = new ResourceLocation("logisticspipes", "textures/gui/lock.png");
    public static final ResourceLocation LINES_ICON = new ResourceLocation("logisticspipes", "textures/gui/lines.png");
    public static final ResourceLocation STATS_ICON = new ResourceLocation("logisticspipes", "textures/gui/stats.png");
    public static float zLevel = 0.0f;

    private GuiGraphics() {
    }

    public static void drawDurabilityBar(ItemStack itemstack, int x, int y, double zLevel) {
        if (itemstack.func_77973_b().showDurabilityBar(itemstack)) {
            double health = itemstack.func_77973_b().getDurabilityForDisplay(itemstack);
            int j1 = (int)Math.round(13.0 - health * 13.0);
            int k = (int)Math.round(255.0 - health * 255.0);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.field_78398_a;
            int l = 255 - k << 16 | k << 8;
            int i1 = (255 - k) / 4 << 16 | 0x3F00;
            SimpleGraphics.drawQuad(tessellator, x + 2, y + 13, 13, 2, Color.BLACK, zLevel);
            SimpleGraphics.drawQuad(tessellator, x + 2, y + 13, 12, 1, i1, zLevel + 1.0);
            SimpleGraphics.drawQuad(tessellator, x + 2, y + 13, j1, 1, l, zLevel + 2.0);
            GL11.glEnable((int)3553);
        }
    }

    public static void displayItemToolTip(Object[] tooltip, Gui gui, float pzLevel, int guiLeft, int guiTop) {
        GuiGraphics.displayItemToolTip(tooltip, pzLevel, guiLeft, guiTop, false);
    }

    public static void displayItemToolTip(Object[] tooltip, float pzLevel, int guiLeft, int guiTop, boolean forceAdd) {
        int var12;
        int var11;
        if (tooltip == null) {
            return;
        }
        zLevel = pzLevel;
        Minecraft mc = FMLClientHandler.instance().getClient();
        ItemStack var22 = (ItemStack)tooltip[2];
        List<String> var24 = mc.field_71462_r instanceof GuiContainer ? SimpleServiceLocator.neiProxy.getItemToolTip(var22, (EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x, (GuiContainer)mc.field_71462_r) : var22.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        if (tooltip.length > 4) {
            var24.addAll(1, (List)tooltip[4]);
        }
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (tooltip.length < 4 || ((Boolean)tooltip[3]).booleanValue())) {
            var24.add(1, "\u00a77" + ((ItemStack)tooltip[2]).field_77994_a);
        }
        if (!SimpleServiceLocator.neiProxy.renderItemToolTip(var11 = (Integer)tooltip[0] - (forceAdd ? 0 : guiLeft) + 12, var12 = (Integer)tooltip[1] - (forceAdd ? 0 : guiTop) - 12, var24, var22.func_77953_t().field_77937_e, var22)) {
            GuiGraphics.drawToolTip(var11, var12, var24, var22.func_77953_t().field_77937_e);
        }
        zLevel = 0.0f;
    }

    public static void drawToolTip(int posX, int posY, List<String> msg, EnumChatFormatting rarityColor) {
        int var12;
        int var11;
        if (msg.isEmpty()) {
            return;
        }
        int var10 = 0;
        for (var11 = 0; var11 < msg.size(); ++var11) {
            var12 = FMLClientHandler.instance().getClient().field_71466_p.func_78256_a(msg.get(var11));
            if (var12 <= var10) continue;
            var10 = var12;
        }
        var11 = posX + 12;
        var12 = posY - 12;
        int var14 = 8;
        if (msg.size() > 1) {
            var14 += 2 + (msg.size() - 1) * 10;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        zLevel = 300.0f;
        int var15 = -267386864;
        SimpleGraphics.drawGradientRect(var11 - 3, var12 - 4, var11 + var10 + 3, var12 - 3, var15, var15, 0.0);
        SimpleGraphics.drawGradientRect(var11 - 3, var12 + var14 + 3, var11 + var10 + 3, var12 + var14 + 4, var15, var15, 0.0);
        SimpleGraphics.drawGradientRect(var11 - 3, var12 - 3, var11 + var10 + 3, var12 + var14 + 3, var15, var15, 0.0);
        SimpleGraphics.drawGradientRect(var11 - 4, var12 - 3, var11 - 3, var12 + var14 + 3, var15, var15, 0.0);
        SimpleGraphics.drawGradientRect(var11 + var10 + 3, var12 - 3, var11 + var10 + 4, var12 + var14 + 3, var15, var15, 0.0);
        int var16 = 0x505000FF;
        int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
        SimpleGraphics.drawGradientRect(var11 - 3, var12 - 3 + 1, var11 - 3 + 1, var12 + var14 + 3 - 1, var16, var17, 0.0);
        SimpleGraphics.drawGradientRect(var11 + var10 + 2, var12 - 3 + 1, var11 + var10 + 3, var12 + var14 + 3 - 1, var16, var17, 0.0);
        SimpleGraphics.drawGradientRect(var11 - 3, var12 - 3, var11 + var10 + 3, var12 - 3 + 1, var16, var16, 0.0);
        SimpleGraphics.drawGradientRect(var11 - 3, var12 + var14 + 2, var11 + var10 + 3, var12 + var14 + 3, var17, var17, 0.0);
        for (int var18 = 0; var18 < msg.size(); ++var18) {
            String var19 = msg.get(var18);
            var19 = var18 == 0 ? "\u00a7" + rarityColor.func_96298_a() + var19 : "\u00a77" + var19;
            FMLClientHandler.instance().getClient().field_71466_p.func_78261_a(var19, var11, var12, -1);
            if (var18 == 0) {
                var12 += 2;
            }
            var12 += 10;
        }
        zLevel = 0.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    public static void drawPlayerInventoryBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                GuiGraphics.drawSlotBackground(mc, xOffset + column * 18 - 1, yOffset + row * 18 - 1);
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            GuiGraphics.drawSlotBackground(mc, xOffset + i1 * 18 - 1, yOffset + 58 - 1);
        }
    }

    public static void drawPlayerHotbarBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int i1 = 0; i1 < 9; ++i1) {
            GuiGraphics.drawSlotBackground(mc, xOffset + i1 * 18 - 1, yOffset - 1);
        }
    }

    public static void drawPlayerArmorBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int i1 = 0; i1 < 4; ++i1) {
            GuiGraphics.drawSlotBackground(mc, xOffset - 1, yOffset - 1 - i1 * 18);
        }
    }

    public static void drawSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(SLOT_TEXTURE);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 18), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)(y + 18), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawSlotBackground(Minecraft mc, int x, int y, int color) {
        zLevel = 0.0f;
        GL11.glColor4f((float)Color.getRed(color), (float)Color.getGreen(color), (float)Color.getBlue(color), (float)Color.getAlpha(color));
        mc.field_71446_o.func_110577_a(SLOT_TEXTURE);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 18), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)(y + 18), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawBigSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(BIG_SLOT_TEXTURE);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 26), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 26), (double)(y + 26), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 26), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawSmallSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(SMALL_SLOT_TEXTURE);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 8), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 8), (double)(y + 8), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 8), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void renderIconAt(Minecraft mc, int x, int y, float zLevel, IIcon icon) {
        if (icon == null) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        var9.func_78374_a((double)x, (double)y, (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        var9.func_78381_a();
    }

    public static void drawLockBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(LOCK_ICON);
        GL11.glEnable((int)3042);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 15), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 14), (double)(y + 15), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 14), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawLinesBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(LINES_ICON);
        GL11.glEnable((int)3042);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawStatsBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(STATS_ICON);
        GL11.glEnable((int)3042);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawGuiBackGround(Minecraft mc, int guiLeft, int guiTop, int right, int bottom, float zLevel, boolean resetColor) {
        GuiGraphics.drawGuiBackGround(mc, guiLeft, guiTop, right, bottom, zLevel, resetColor, true, true, true, true);
    }

    public static void drawGuiBackGround(Minecraft mc, int guiLeft, int guiTop, int right, int bottom, float zLevel, boolean resetColor, boolean displayTop, boolean displayLeft, boolean displayBottom, boolean displayRight) {
        if (resetColor) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        mc.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
        Tessellator var9 = Tessellator.field_78398_a;
        if (displayTop) {
            var9.func_78382_b();
            var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
            var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
            var9.func_78374_a((double)(right - 15), (double)guiTop, (double)zLevel, 0.66, 0.0);
            var9.func_78374_a((double)(guiLeft + 15), (double)guiTop, (double)zLevel, 0.33, 0.0);
            var9.func_78381_a();
        }
        if (displayLeft) {
            var9.func_78382_b();
            var9.func_78374_a((double)guiLeft, (double)(bottom - 15), (double)zLevel, 0.0, 0.66);
            var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
            var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
            var9.func_78374_a((double)guiLeft, (double)(guiTop + 15), (double)zLevel, 0.0, 0.33);
            var9.func_78381_a();
        }
        if (displayBottom) {
            var9.func_78382_b();
            var9.func_78374_a((double)(guiLeft + 15), (double)bottom, (double)zLevel, 0.33, 1.0);
            var9.func_78374_a((double)(right - 15), (double)bottom, (double)zLevel, 0.66, 1.0);
            var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
            var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
            var9.func_78381_a();
        }
        if (displayRight) {
            var9.func_78382_b();
            var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
            var9.func_78374_a((double)right, (double)(bottom - 15), (double)zLevel, 1.0, 0.66);
            var9.func_78374_a((double)right, (double)(guiTop + 15), (double)zLevel, 1.0, 0.33);
            var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
            var9.func_78381_a();
        }
        if (displayTop && displayLeft) {
            var9.func_78382_b();
            var9.func_78374_a((double)guiLeft, (double)(guiTop + 15), (double)zLevel, 0.0, 0.33);
            var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
            var9.func_78374_a((double)(guiLeft + 15), (double)guiTop, (double)zLevel, 0.33, 0.0);
            var9.func_78374_a((double)guiLeft, (double)guiTop, (double)zLevel, 0.0, 0.0);
            var9.func_78381_a();
        }
        if (displayBottom && displayLeft) {
            var9.func_78382_b();
            var9.func_78374_a((double)guiLeft, (double)bottom, (double)zLevel, 0.0, 1.0);
            var9.func_78374_a((double)(guiLeft + 15), (double)bottom, (double)zLevel, 0.33, 1.0);
            var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
            var9.func_78374_a((double)guiLeft, (double)(bottom - 15), (double)zLevel, 0.0, 0.66);
            var9.func_78381_a();
        }
        if (displayBottom && displayRight) {
            var9.func_78382_b();
            var9.func_78374_a((double)(right - 15), (double)bottom, (double)zLevel, 0.66, 1.0);
            var9.func_78374_a((double)right, (double)bottom, (double)zLevel, 1.0, 1.0);
            var9.func_78374_a((double)right, (double)(bottom - 15), (double)zLevel, 1.0, 0.66);
            var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
            var9.func_78381_a();
        }
        if (displayTop && displayRight) {
            var9.func_78382_b();
            var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
            var9.func_78374_a((double)right, (double)(guiTop + 15), (double)zLevel, 1.0, 0.33);
            var9.func_78374_a((double)right, (double)guiTop, (double)zLevel, 1.0, 0.0);
            var9.func_78374_a((double)(right - 15), (double)guiTop, (double)zLevel, 0.66, 0.0);
            var9.func_78381_a();
        }
        var9.func_78382_b();
        var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
        var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
        var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
        var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
        var9.func_78381_a();
    }
}

