/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.ISearchBar;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class SearchBar
implements ISearchBar {
    public String searchinput1 = "";
    public String searchinput2 = "";
    private boolean isActive;
    private boolean displaycursor = true;
    private long oldSystemTime = 0L;
    private int searchWidth;
    private final boolean numberOnly;
    private final boolean alignRight;
    private final FontRenderer fontRenderer;
    private final LogisticsBaseGuiScreen screen;
    private int left;
    private int top;
    private int heigth;
    private int width;

    public SearchBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth) {
        this(fontRenderer, screen, left, top, width, heigth, true);
    }

    public SearchBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth, boolean isActive) {
        this(fontRenderer, screen, left, top, width, heigth, isActive, false);
    }

    public SearchBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth, boolean isActive, boolean numberOnly) {
        this(fontRenderer, screen, left, top, width, heigth, isActive, numberOnly, false);
    }

    public SearchBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int heigth, boolean isActive, boolean numberOnly, boolean alignRight) {
        this.fontRenderer = fontRenderer;
        this.screen = screen;
        this.left = left;
        this.top = top;
        this.width = width;
        this.heigth = heigth;
        this.searchWidth = width - 10;
        this.isActive = isActive;
        this.numberOnly = numberOnly;
        this.alignRight = alignRight;
    }

    @Override
    public void reposition(int left, int top, int width, int heigth) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.heigth = heigth;
        this.searchWidth = width - 10;
    }

    @Override
    public void renderSearchBar() {
        if (this.isFocused()) {
            this.screen.drawRect(this.left, this.top - 2, this.left + this.width, this.top + this.heigth, Color.BLACK);
            this.screen.drawRect(this.left + 1, this.top - 1, this.left + this.width - 1, this.top + this.heigth - 1, Color.WHITE);
        } else {
            this.screen.drawRect(this.left + 1, this.top - 1, this.left + this.width - 1, this.top + this.heigth - 1, Color.BLACK);
        }
        this.screen.drawRect(this.left + 2, this.top, this.left + this.width - 2, this.top + this.heigth - 2, Color.DARKER_GREY);
        if (this.alignRight) {
            this.fontRenderer.func_78276_b(this.searchinput1 + this.searchinput2, this.left + 5 + this.searchWidth - this.fontRenderer.func_78256_a(this.searchinput1 + this.searchinput2), this.top + 3, 0xFFFFFF);
        } else {
            this.fontRenderer.func_78276_b(this.searchinput1 + this.searchinput2, this.left + 5, this.top + 3, 0xFFFFFF);
        }
        if (this.isFocused()) {
            int linex = this.alignRight ? this.left + 5 + this.searchWidth - this.fontRenderer.func_78256_a(this.searchinput2) : this.left + 5 + this.fontRenderer.func_78256_a(this.searchinput1);
            if (System.currentTimeMillis() - this.oldSystemTime > 500L) {
                this.displaycursor = !this.displaycursor;
                this.oldSystemTime = System.currentTimeMillis();
            }
            if (this.displaycursor) {
                this.screen.drawRect(linex, this.top + 1, linex + 1, this.top + this.heigth - 3, Color.WHITE);
            }
        }
    }

    @Override
    public boolean handleClick(int x, int y, int k) {
        if (x >= this.left + 2 && x < this.left + this.width - 2 && y >= this.top && y < this.top + this.heigth) {
            this.focus();
            if (k == 1) {
                this.searchinput1 = "";
                this.searchinput2 = "";
            }
            return true;
        }
        if (this.isFocused()) {
            this.unFocus();
            return true;
        }
        return false;
    }

    private void unFocus() {
        this.isActive = false;
        if (this.numberOnly) {
            this.searchinput1 = this.searchinput1 + this.searchinput2;
            this.searchinput2 = "";
            try {
                int value = Integer.parseInt(this.searchinput1);
                this.searchinput1 = Integer.toString(value);
            }
            catch (Exception e) {
                this.searchinput1 = "";
            }
            if (this.searchinput1.isEmpty() && this.searchinput2.isEmpty()) {
                this.searchinput1 = "0";
            }
        }
    }

    private void focus() {
        this.isActive = true;
    }

    @Override
    public boolean isFocused() {
        return this.isActive;
    }

    @Override
    public boolean handleKey(char typedChar, int keyCode) {
        if (!this.isFocused()) {
            return false;
        }
        if (keyCode == 1) {
            return false;
        }
        if (keyCode == 28) {
            this.unFocus();
        } else if (keyCode == 14) {
            if (this.searchinput1.length() > 0) {
                this.searchinput1 = this.searchinput1.substring(0, this.searchinput1.length() - 1);
            }
        } else if (keyCode == 203) {
            if (this.searchinput1.length() > 0) {
                this.searchinput2 = this.searchinput1.substring(this.searchinput1.length() - 1) + this.searchinput2;
                this.searchinput1 = this.searchinput1.substring(0, this.searchinput1.length() - 1);
            }
        } else if (keyCode == 205) {
            if (this.searchinput2.length() > 0) {
                this.searchinput1 = this.searchinput1 + this.searchinput2.substring(0, 1);
                this.searchinput2 = this.searchinput2.substring(1);
            }
        } else if (keyCode == 199) {
            this.searchinput2 = this.searchinput1 + this.searchinput2;
            this.searchinput1 = "";
        } else if (keyCode == 207) {
            this.searchinput1 = this.searchinput1 + this.searchinput2;
            this.searchinput2 = "";
        } else if (keyCode == 211) {
            if (this.searchinput2.length() > 0) {
                this.searchinput2 = this.searchinput2.substring(1);
            }
        } else if (keyCode == 47 && GuiScreen.func_146271_m()) {
            boolean isFine = true;
            if (this.numberOnly) {
                try {
                    Integer.valueOf(SearchBar.getClipboardString());
                }
                catch (Exception e) {
                    isFine = false;
                }
            }
            if (isFine) {
                String toAdd = SearchBar.getClipboardString();
                while (this.fontRenderer.func_78256_a(this.searchinput1 + toAdd + this.searchinput2) > this.searchWidth) {
                    toAdd = toAdd.substring(0, toAdd.length() - 1);
                }
                this.searchinput1 = this.searchinput1 + toAdd;
            }
        } else if ((!this.numberOnly && !Character.isISOControl(typedChar) || this.numberOnly && Character.isDigit(typedChar)) && this.fontRenderer.func_78256_a(this.searchinput1 + typedChar + this.searchinput2) <= this.searchWidth) {
            this.searchinput1 = this.searchinput1 + typedChar;
        }
        return true;
    }

    @Override
    public String getContent() {
        return this.searchinput1 + this.searchinput2;
    }

    @Override
    public boolean isEmpty() {
        return this.searchinput1.isEmpty() && this.searchinput2.isEmpty();
    }

    private static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

