/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ISlotCheck;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.LogicControllerPacket;
import logisticspipes.network.packets.pipe.PipeManagerWatchingPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgrade;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtils;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiPipeController
extends LogisticsBaseGuiScreen {
    private final String PREFIX = "gui.pipecontroller.";
    private final int TAB_COUNT = 5;
    private int current_Tab;
    private final List<Slot> TAB_SLOTS_1_1 = new ArrayList<Slot>();
    private final List<Slot> TAB_SLOTS_1_2 = new ArrayList<Slot>();
    private final List<Slot> TAB_SLOTS_2 = new ArrayList<Slot>();
    private final List<Slot> TAB_SLOTS_4 = new ArrayList<Slot>();
    private final List<GuiButton> TAB_BUTTON_4 = new ArrayList<GuiButton>();
    private final List<GuiButton> TAB_BUTTON_5 = new ArrayList<GuiButton>();
    private ItemDisplay _itemDisplay_5;
    private final CoreRoutedPipe pipe;
    private boolean managerWatching;

    public GuiPipeController(EntityPlayer player, final CoreRoutedPipe pipe) {
        super(180, 220, 0, 0);
        int pipeSlot;
        this.pipe = pipe;
        DummyContainer dummy = new DummyContainer(player, null, pipe.getOriginalUpgradeManager().getGuiController());
        dummy.addNormalSlotsForPlayerInventory(10, 135);
        for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            this.TAB_SLOTS_1_1.add(dummy.addRestrictedSlot(pipeSlot, (IInventory)pipe.getOriginalUpgradeManager().getInv(), 10 + pipeSlot * 18, 42, new ISlotCheck(){

                @Override
                public boolean isStackAllowed(ItemStack itemStack) {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.func_77973_b() == LogisticsPipes.UpgradeItem) {
                        return LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null).isAllowedForPipe(pipe);
                    }
                    return false;
                }
            }));
        }
        for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            this.TAB_SLOTS_1_2.add(dummy.addRestrictedSlot(pipeSlot, (IInventory)pipe.getOriginalUpgradeManager().getSneakyInv(), 10 + pipeSlot * 18, 78, new ISlotCheck(){

                @Override
                public boolean isStackAllowed(ItemStack itemStack) {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.func_77973_b() == LogisticsPipes.UpgradeItem) {
                        IPipeUpgrade upgrade = LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null);
                        if (!(upgrade instanceof SneakyUpgrade)) {
                            return false;
                        }
                        return upgrade.isAllowedForPipe(pipe);
                    }
                    return false;
                }
            }));
        }
        this.TAB_SLOTS_2.add(dummy.addStaticRestrictedSlot(0, (IInventory)pipe.getOriginalUpgradeManager().getSecInv(), 10, 42, new ISlotCheck(){

            @Override
            public boolean isStackAllowed(ItemStack itemStack) {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() != LogisticsPipes.LogisticsItemCard) {
                    return false;
                }
                if (itemStack.func_77960_j() != 1) {
                    return false;
                }
                return SimpleServiceLocator.securityStationManager.isAuthorized(UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID")));
            }
        }, 1));
        this.TAB_SLOTS_4.add(dummy.addRestrictedSlot(0, (IInventory)pipe.container.logicController.diskInv, 14, 36, LogisticsPipes.LogisticsItemDisk));
        this.field_147002_h = dummy;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.TAB_BUTTON_4.add(this.addButton(new GuiButton(0, this.field_147003_i + 10, this.field_147009_r + 70, 160, 20, "Edit Logic Controller")));
        this.TAB_BUTTON_5.add(this.addButton(new SmallGuiButton(1, this.field_147003_i + 95, this.field_147009_r + 26, 10, 10, "<")));
        this.TAB_BUTTON_5.add(this.addButton(new SmallGuiButton(2, this.field_147003_i + 165, this.field_147009_r + 26, 10, 10, ">")));
        if (this._itemDisplay_5 == null) {
            this._itemDisplay_5 = new ItemDisplay(null, this.field_146297_k.field_71466_p, this, null, 10, 40, 20, 60, new int[]{1, 1, 1, 1}, true);
        }
        this._itemDisplay_5.reposition(10, 40, 20, 60);
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146127_k == 0) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(LogicControllerPacket.class).setTilePos(this.pipe.container));
        } else if (p_146284_1_.field_146127_k == 1) {
            this._itemDisplay_5.prevPage();
        } else if (p_146284_1_.field_146127_k == 2) {
            this._itemDisplay_5.nextPage();
        }
    }

    @Override
    protected void func_146976_a(float f, int mouse_x, int mouse_y) {
        if (this.current_Tab == 3 && !this.pipe.getOriginalUpgradeManager().hasLogicControll()) {
            this.current_Tab = 0;
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        for (int i = 0; i < 5; ++i) {
            if (i == 3 && !this.pipe.getOriginalUpgradeManager().hasLogicControll()) {
                GL11.glColor4d((double)0.4, (double)0.4, (double)0.4, (double)1.0);
            }
            GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i + 25 * i + 2, this.field_147009_r - 2, this.field_147003_i + 27 + 25 * i, this.field_147009_r + 35, this.field_73735_i, false, true, true, false, true);
            if (i != 3 || this.pipe.getOriginalUpgradeManager().hasLogicControll()) continue;
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        }
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r + 20, this.right, this.bottom, this.field_73735_i, true);
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i + 25 * this.current_Tab + 2, this.field_147009_r - 2, this.field_147003_i + 27 + 25 * this.current_Tab, this.field_147009_r + 38, this.field_73735_i, true, true, true, false, true);
        GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, this.field_147003_i + 10, this.field_147009_r + 135);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
        ItemStack stack = new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 6);
        GuiScreen.field_146296_j.func_82406_b(this.field_146289_q, this.getMC().field_71446_o, stack, this.field_147003_i + 6, this.field_147009_r + 4);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
        GuiGraphics.drawLockBackground(this.field_146297_k, this.field_147003_i + 32, this.field_147009_r + 3);
        GuiGraphics.drawStatsBackground(this.field_146297_k, this.field_147003_i + 56, this.field_147009_r + 3);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
        ItemStack stack2 = new ItemStack(Blocks.field_150429_aA);
        GuiScreen.field_146296_j.func_82406_b(this.field_146289_q, this.getMC().field_71446_o, stack2, this.field_147003_i + 81, this.field_147009_r + 1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
        GuiGraphics.drawLinesBackground(this.field_146297_k, this.field_147003_i + 106, this.field_147009_r + 3);
        if (this.current_Tab == 0) {
            int pipeSlot;
            for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 9 + pipeSlot * 18, this.field_147009_r + 41);
            }
            if (this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade()) {
                for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
                    GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 9 + pipeSlot * 18, this.field_147009_r + 77);
                }
            }
        } else if (this.current_Tab == 1) {
            GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 9, this.field_147009_r + 41);
        } else if (this.current_Tab == 3) {
            this.drawRect(this.field_147003_i + 12, this.field_147009_r + 34, this.field_147003_i + 32, this.field_147009_r + 54, Color.BLACK);
            this.drawRect(this.field_147003_i + 14, this.field_147009_r + 36, this.field_147003_i + 30, this.field_147009_r + 52, Color.DARKER_GREY);
        }
        super.func_146976_a(f, mouse_x, mouse_y);
    }

    @Override
    protected void func_73864_a(int par1, int par2, int par3) {
        if (par3 == 0 && par1 > this.field_147003_i && par1 < this.field_147003_i + 220 && par2 > this.field_147009_r && par2 < this.field_147009_r + 20) {
            int select = Math.max(0, Math.min((par1 -= this.field_147003_i + 3) / 25, 4));
            if (select != 3 || this.pipe.getOriginalUpgradeManager().hasLogicControll()) {
                this.current_Tab = select;
            }
            if (this.current_Tab == 4) {
                if (!this.managerWatching) {
                    this.managerWatching = true;
                    MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeManagerWatchingPacket.class).setStart(true).setTilePos(this.pipe.container));
                }
            } else if (this.managerWatching) {
                this.managerWatching = false;
                MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeManagerWatchingPacket.class).setStart(false).setTilePos(this.pipe.container));
            }
        } else if (this.current_Tab == 4) {
            super.func_73864_a(par1, par2, par3);
        } else {
            super.func_73864_a(par1, par2, par3);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.field_146297_k.field_71466_p.func_85187_a(StringUtils.translate("gui.pipecontroller.inventory"), 10, 122, Color.getValue(Color.DARKER_GREY), false);
        if (this.current_Tab == 0) {
            this.field_146297_k.field_71466_p.func_85187_a(StringUtils.translate("gui.pipecontroller.upgrade"), 10, 28, Color.getValue(Color.DARKER_GREY), false);
            if (this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade()) {
                this.field_146297_k.field_71466_p.func_85187_a(StringUtils.translate("gui.pipecontroller.sneakyUpgrades"), 10, 64, Color.getValue(Color.DARKER_GREY), false);
            }
        } else if (this.current_Tab == 1) {
            this.field_146297_k.field_71466_p.func_85187_a(StringUtils.translate("gui.pipecontroller.security"), 10, 28, Color.getValue(Color.DARKER_GREY), false);
            ItemStack itemStack = this.pipe.getOriginalUpgradeManager().getSecInv().func_70301_a(0);
            if (itemStack != null) {
                UUID id = UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID"));
                this.field_146297_k.field_71466_p.func_85187_a("Id: ", 10, 68, Color.getValue(Color.DARKER_GREY), false);
                GL11.glTranslated((double)10.0, (double)80.0, (double)0.0);
                GL11.glScaled((double)0.75, (double)0.75, (double)1.0);
                this.field_146297_k.field_71466_p.func_85187_a(ChatColor.BLUE.toString() + id.toString(), 0, 0, Color.getValue(Color.DARKER_GREY), false);
                GL11.glScaled((double)1.3333333333333333, (double)1.3333333333333333, (double)1.0);
                GL11.glTranslated((double)-10.0, (double)-80.0, (double)0.0);
                this.field_146297_k.field_71466_p.func_85187_a("Authorization: " + (SimpleServiceLocator.securityStationManager.isAuthorized(id) ? (Object)((Object)ChatColor.GREEN) + "Authorized" : (Object)((Object)ChatColor.RED) + "Deauthorized"), 10, 94, Color.getValue(Color.DARKER_GREY), false);
            }
        } else if (this.current_Tab == 2) {
            String pipeName = ItemIdentifier.get(this.pipe.item, 0, null).getFriendlyName();
            this.field_146289_q.func_78276_b(pipeName, (170 - this.field_146289_q.func_78256_a(pipeName)) / 2, 28, 8609820);
            int sessionxCenter = 85;
            int lifetimexCenter = 140;
            String s = null;
            this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Session"), sessionxCenter - this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Session")) / 2, 40, 0x303030);
            this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Lifetime"), lifetimexCenter - this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Lifetime")) / 2, 40, 0x303030);
            this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Sent") + ":", 55 - this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Sent") + ":"), 55, 0x303030);
            this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Recieved") + ":", 55 - this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Recieved") + ":"), 70, 0x303030);
            this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.Relayed") + ":", 55 - this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.Relayed") + ":"), 85, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.stat_session_sent);
            this.field_146289_q.func_78276_b(s, sessionxCenter - this.field_146289_q.func_78256_a(s) / 2, 55, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.stat_session_recieved);
            this.field_146289_q.func_78276_b(s, sessionxCenter - this.field_146289_q.func_78256_a(s) / 2, 70, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.stat_session_relayed);
            this.field_146289_q.func_78276_b(s, sessionxCenter - this.field_146289_q.func_78256_a(s) / 2, 85, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.stat_lifetime_sent);
            this.field_146289_q.func_78276_b(s, lifetimexCenter - this.field_146289_q.func_78256_a(s) / 2, 55, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.stat_lifetime_recieved);
            this.field_146289_q.func_78276_b(s, lifetimexCenter - this.field_146289_q.func_78256_a(s) / 2, 70, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.stat_lifetime_relayed);
            this.field_146289_q.func_78276_b(s, lifetimexCenter - this.field_146289_q.func_78256_a(s) / 2, 85, 0x303030);
            this.field_146289_q.func_78276_b(StringUtils.translate("gui.pipecontroller.RoutingTableSize") + ":", 110 - this.field_146289_q.func_78256_a(StringUtils.translate("gui.pipecontroller.RoutingTableSize") + ":"), 110, 0x303030);
            s = StringUtils.getStringWithSpacesFromLong(this.pipe.server_routing_table_size);
            this.field_146289_q.func_78276_b(s, 130 - this.field_146289_q.func_78256_a(s) / 2, 110, 0x303030);
        } else if (this.current_Tab == 4) {
            LinkedList<ItemIdentifierStack> _allItems = new LinkedList<ItemIdentifierStack>();
            for (IOrderInfoProvider entry : this.pipe.getClientSideOrderManager()) {
                _allItems.add(entry.getAsDisplayItem());
            }
            this._itemDisplay_5.setItemList(_allItems);
            this._itemDisplay_5.renderItemArea(this.field_73735_i);
            this._itemDisplay_5.renderPageNumber(this.right - this.field_147003_i - 45, 28);
            int start = this._itemDisplay_5.getPage() * 3;
            int stringPos = 40;
            for (int i = start; i < start + 3 && i < this.pipe.getClientSideOrderManager().size(); ++i) {
                IOrderInfoProvider order = this.pipe.getClientSideOrderManager().get(i);
                ItemIdentifier target = order.getTargetType();
                String s = "";
                if (target != null) {
                    s = target.getFriendlyName();
                    this.field_146289_q.func_78276_b(s, 35, stringPos, 0x303030);
                }
                s = Integer.toString(i + 1);
                this.field_146289_q.func_78276_b(s, 3, stringPos += 6, 0x303030);
                stringPos += 4;
                LPPosition pos = order.getTargetPosition();
                if (pos != null) {
                    s = pos.toIntBasedString();
                    this.field_146289_q.func_78276_b(s, 40, stringPos, 0x303030);
                }
                stringPos += 10;
            }
        }
    }

    @Override
    protected void func_146977_a(Slot slot) {
        if (this.TAB_SLOTS_1_1.contains(slot) && this.current_Tab != 0) {
            return;
        }
        if (this.TAB_SLOTS_1_2.contains(slot) && (this.current_Tab != 0 || !this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade())) {
            return;
        }
        if (this.TAB_SLOTS_2.contains(slot) && this.current_Tab != 1) {
            return;
        }
        if (this.TAB_SLOTS_4.contains(slot) && this.current_Tab != 3) {
            return;
        }
        super.func_146977_a(slot);
    }

    @Override
    protected boolean func_146981_a(Slot slot, int par2, int par3) {
        if (!super.func_146981_a(slot, par2, par3)) {
            return false;
        }
        if (this.TAB_SLOTS_1_1.contains(slot) && this.current_Tab != 0) {
            return false;
        }
        if (this.TAB_SLOTS_1_2.contains(slot) && (this.current_Tab != 0 || !this.pipe.getOriginalUpgradeManager().hasCombinedSneakyUpgrade())) {
            return false;
        }
        if (this.TAB_SLOTS_2.contains(slot) && this.current_Tab != 1) {
            return false;
        }
        return !this.TAB_SLOTS_4.contains(slot) || this.current_Tab == 3;
    }

    @Override
    protected void checkButtons() {
        super.checkButtons();
        for (GuiButton button : this.field_146292_n) {
            if (this.TAB_BUTTON_4.contains(button)) {
                button.field_146125_m = this.current_Tab == 3;
                boolean bl = button.field_146124_l = this.pipe.container.logicController.diskInv.func_70301_a(0) != null;
            }
            if (!this.TAB_BUTTON_5.contains(button)) continue;
            button.field_146125_m = this.current_Tab == 4;
        }
    }
}

