/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import logisticspipes.network.abstractpackets.ListSyncPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import net.minecraft.entity.player.EntityPlayer;

public class SyncList<E>
implements List<E> {
    private final List<E> list;
    private ListSyncPacket<E> packetType;
    private PlayerCollectionList watcherList = null;
    private boolean dirty = false;
    private int dim;
    private int x;
    private int z;

    public SyncList() {
        this(null, new ArrayList());
    }

    public SyncList(ListSyncPacket<E> type) {
        this(type, new ArrayList());
    }

    public SyncList(ListSyncPacket<E> type, List<E> list) {
        this.packetType = type;
        this.list = list;
    }

    public void markDirty() {
        if (this.packetType == null) {
            return;
        }
        this.dirty = true;
    }

    public void sendUpdateToWaters() {
        if (this.packetType == null) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            if (this.watcherList != null) {
                MainProxy.sendToPlayerList(((ListSyncPacket)this.packetType.template()).setList(this.list), this.watcherList);
            } else {
                MainProxy.sendPacketToAllWatchingChunk(this.x, this.z, this.dim, ((ListSyncPacket)this.packetType.template()).setList(this.list));
            }
        }
    }

    public void setPacketType(ListSyncPacket<E> type, int dim, int x, int z) {
        this.packetType = type;
        this.dim = dim;
        this.x = x;
        this.z = z;
        if (this.watcherList != null) {
            MainProxy.sendToPlayerList(((ListSyncPacket)this.packetType.template()).setList(this.list), this.watcherList);
        } else {
            MainProxy.sendPacketToAllWatchingChunk(x, z, dim, ((ListSyncPacket)this.packetType.template()).setList(this.list));
        }
    }

    public void addWatcher(EntityPlayer player) {
        if (this.watcherList == null) {
            this.watcherList = new PlayerCollectionList();
        }
        if (this.packetType != null) {
            MainProxy.sendPacketToPlayer(((ListSyncPacket)this.packetType.template()).setList(this.list), player);
        }
        this.watcherList.add(player);
    }

    public boolean removeWatcher(EntityPlayer player) {
        if (this.watcherList == null) {
            this.watcherList = new PlayerCollectionList();
        }
        return this.watcherList.remove(player);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object paramObject) {
        return this.list.contains(paramObject);
    }

    @Override
    public Iterator<E> iterator() {
        return new SyncIter(this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] paramArrayOfT) {
        return this.list.toArray(paramArrayOfT);
    }

    @Override
    public boolean add(E paramE) {
        boolean flag = this.list.add(paramE);
        this.markDirty();
        return flag;
    }

    @Override
    public boolean remove(Object paramObject) {
        boolean flag = this.list.remove(paramObject);
        this.markDirty();
        return flag;
    }

    @Override
    public boolean containsAll(Collection<?> paramCollection) {
        return this.list.containsAll(paramCollection);
    }

    @Override
    public boolean addAll(Collection<? extends E> paramCollection) {
        boolean flag = this.list.addAll(paramCollection);
        this.markDirty();
        return flag;
    }

    @Override
    public boolean addAll(int paramInt, Collection<? extends E> paramCollection) {
        boolean flag = this.list.addAll(paramInt, paramCollection);
        this.markDirty();
        return flag;
    }

    @Override
    public boolean removeAll(Collection<?> paramCollection) {
        boolean flag = this.list.removeAll(paramCollection);
        this.markDirty();
        return flag;
    }

    @Override
    public boolean retainAll(Collection<?> paramCollection) {
        boolean flag = this.list.retainAll(paramCollection);
        this.markDirty();
        return flag;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.markDirty();
    }

    @Override
    public E get(int paramInt) {
        return this.list.get(paramInt);
    }

    @Override
    public E set(int paramInt, E paramE) {
        E object = this.list.set(paramInt, paramE);
        this.markDirty();
        return object;
    }

    @Override
    public void add(int paramInt, E paramE) {
        this.list.add(paramInt, paramE);
        this.markDirty();
    }

    @Override
    public E remove(int paramInt) {
        E object = this.list.remove(paramInt);
        this.markDirty();
        return object;
    }

    @Override
    public int indexOf(Object paramObject) {
        return this.list.indexOf(paramObject);
    }

    @Override
    public int lastIndexOf(Object paramObject) {
        int index = this.list.lastIndexOf(paramObject);
        this.markDirty();
        return index;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SyncListIter(this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int paramInt) {
        return new SyncListIter(this.list.listIterator(paramInt));
    }

    @Override
    public List<E> subList(int paramInt1, int paramInt2) {
        throw new UnsupportedOperationException();
    }

    private class SyncListIter
    extends SyncIter
    implements ListIterator<E> {
        private final ListIterator<E> iter;

        protected SyncListIter(ListIterator<E> iter) {
            super(iter);
            this.iter = iter;
        }

        @Override
        public void add(E paramE) {
            this.iter.add(paramE);
            SyncList.this.markDirty();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public E previous() {
            return this.iter.previous();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void set(E paramE) {
            this.iter.set(paramE);
            SyncList.this.markDirty();
        }
    }

    private class SyncIter
    implements Iterator<E> {
        private final Iterator<E> iter;

        protected SyncIter(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
            SyncList.this.markDirty();
        }
    }
}

