/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.DelayPacketException;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, ModernPacket> {
    public static List<ModernPacket> packetlist;
    public static Map<Class<? extends ModernPacket>, ModernPacket> packetmap;
    private static int packetDebugID;
    public static final Map<Integer, StackTraceElement[]> debugMap;
    protected static final AttributeKey<ThreadLocal<FMLProxyPacket>> INBOUNDPACKETTRACKER;

    public static <T extends ModernPacket> T getPacket(Class<T> clazz) {
        ModernPacket packet = packetmap.get(clazz).template();
        return (T)packet;
    }

    public static final void initialize() {
        ArrayList classes = new ArrayList(ClassPath.from((ClassLoader)PacketHandler.class.getClassLoader()).getTopLevelClassesRecursive("logisticspipes.network.packets"));
        Collections.sort(classes, new Comparator<ClassPath.ClassInfo>(){

            @Override
            public int compare(ClassPath.ClassInfo o1, ClassPath.ClassInfo o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        packetlist = new ArrayList<ModernPacket>(classes.size());
        packetmap = new HashMap<Class<? extends ModernPacket>, ModernPacket>(classes.size());
        int currentid = 0;
        for (ClassPath.ClassInfo c : classes) {
            Class cls = c.load();
            ModernPacket instance = (ModernPacket)cls.getConstructor(Integer.TYPE).newInstance(currentid);
            packetlist.add(instance);
            packetmap.put(cls, instance);
            ++currentid;
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public static FMLProxyPacket toFMLPacket(ModernPacket msg) throws Exception {
        return PacketHandler.toFMLPacket(msg, "LogisticsPipes");
    }

    private static FMLProxyPacket toFMLPacket(ModernPacket msg, String channel) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeShort(msg.getId());
        buffer.writeInt(msg.getDebugId());
        msg.writeData(new LPDataOutputStream(buffer));
        return new FMLProxyPacket(buffer.copy(), channel);
    }

    protected final void encode(ChannelHandlerContext ctx, ModernPacket msg, List<Object> out) throws Exception {
        FMLProxyPacket proxy = PacketHandler.toFMLPacket(msg, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        FMLProxyPacket old = (FMLProxyPacket)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        short packetID = payload.readShort();
        ModernPacket packet = packetlist.get(packetID).template();
        packet.setDebugId(payload.readInt());
        ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(msg);
        packet.readData(new LPDataInputStream(payload.slice()));
        out.add(new InboundModernPacketWrapper(packet, MainProxy.proxy.getEntityPlayerFromNetHandler(msg.handler())));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"LogisticsPipes PacketHandler exception caught", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }

    public static void onPacketData(LPDataInputStream data, EntityPlayer player) throws IOException {
        if (player == null) {
            return;
        }
        short packetID = data.readShort();
        ModernPacket packet = packetlist.get(packetID).template();
        packet.setDebugId(data.readInt());
        packet.readData(data);
        PacketHandler.onPacketData(packet, player);
    }

    private static void onPacketData(ModernPacket packet, EntityPlayer player) {
        try {
            packet.processPacket(player);
        }
        catch (DelayPacketException e) {
            if (packet.retry() && MainProxy.isClient(player.func_130014_f_())) {
                SimpleServiceLocator.clientBufferHandler.queueFailedPacket(packet, player);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        packetDebugID = 1;
        debugMap = new HashMap<Integer, StackTraceElement[]>();
        INBOUNDPACKETTRACKER = new AttributeKey("lp:inboundpacket");
    }

    static class InboundModernPacketWrapper {
        final ModernPacket packet;
        final EntityPlayer player;

        InboundModernPacketWrapper(ModernPacket p, EntityPlayer e) {
            this.packet = p;
            this.player = e;
        }
    }
}

