/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.FluidSupplierAmount;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidSupplierMk2
extends FluidRoutedPipe
implements IRequestFluid,
IRequireReliableFluidTransport {
    private boolean _lastRequestFailed = false;
    private final ItemIdentifierInventory dummyInventory = new ItemIdentifierInventory(1, "Fluid to keep stocked", 127, true);
    private int amount = 0;
    private final TObjectIntMap<FluidIdentifier> _requestedItems = new TObjectIntHashMap(8, 0.5f, -1);
    private boolean _requestPartials = false;
    private MinMode _bucketMinimum = MinMode.ONEBUCKET;

    public PipeFluidSupplierMk2(Item item) {
        super(item);
        this.throttleTime = 100;
    }

    @Override
    public void sendFailed(FluidIdentifier value1, Integer value2) {
        this.liquidLost(value1, value2);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_MK2_TEXTURE;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    protected void fillSide(FluidStack toFill, ForgeDirection tankLocation, IFluidHandler tile) {
        if (this.dummyInventory.func_70301_a(0) == null) {
            return;
        }
        int have = 0;
        FluidIdentifier fIdent = FluidIdentifier.get(this.dummyInventory.getIDStackInSlot(0).getItem());
        for (FluidTankInfo info : tile.getTankInfo(ForgeDirection.UNKNOWN)) {
            if (info.fluid == null || !fIdent.equals(FluidIdentifier.get(info.fluid))) continue;
            have += info.fluid.amount;
        }
        int vacant = this.amount - have;
        if (vacant <= 0) {
            return;
        }
        if (this._bucketMinimum.getAmount() != 0 && vacant < this._bucketMinimum.getAmount()) {
            return;
        }
        FluidStack filled = toFill.copy();
        filled.amount = Math.min(filled.amount, vacant);
        toFill.amount -= tile.fill(tankLocation.getOpposite(), filled, true);
    }

    @Override
    public void throttledUpdateEntity() {
        if (!this.isEnabled()) {
            return;
        }
        if (MainProxy.isClient(this.container.getWorld())) {
            return;
        }
        super.throttledUpdateEntity();
        if (this.dummyInventory.func_70301_a(0) == null) {
            return;
        }
        TObjectIntHashMap requestDiscount = new TObjectIntHashMap(this._requestedItems);
        FluidTank centerTank = ((PipeFluidTransportLogistics)this.transport).internalTank;
        if (centerTank != null && centerTank.getFluid() != null) {
            requestDiscount.adjustOrPutValue((Object)FluidIdentifier.get(centerTank.getFluid()), centerTank.getFluid().amount, centerTank.getFluid().amount);
        }
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            FluidTank sideTank;
            FluidTankInfo[] result;
            IFluidHandler container;
            if (!(tile.tile instanceof IFluidHandler) || SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile) || (container = (IFluidHandler)tile.tile).getTankInfo(ForgeDirection.UNKNOWN) == null || container.getTankInfo(ForgeDirection.UNKNOWN).length == 0) continue;
            TObjectIntHashMap wantFluids = new TObjectIntHashMap(8);
            FluidIdentifier fIdent = FluidIdentifier.get(this.dummyInventory.getIDStackInSlot(0).getItem());
            wantFluids.put((Object)fIdent, this.amount);
            for (FluidTankInfo slot : result = container.getTankInfo(ForgeDirection.UNKNOWN)) {
                if (slot == null || slot.fluid == null || slot.fluid.getFluidID() == 0) continue;
                wantFluids.adjustValue((Object)FluidIdentifier.get(slot.fluid), -slot.fluid.amount);
            }
            if (tile.orientation.ordinal() < ((PipeFluidTransportLogistics)this.transport).sideTanks.length && (sideTank = ((PipeFluidTransportLogistics)this.transport).sideTanks[tile.orientation.ordinal()]) != null && sideTank.getFluid() != null) {
                wantFluids.adjustValue((Object)FluidIdentifier.get(sideTank.getFluid()), -sideTank.getFluid().amount);
            }
            wantFluids.retainEntries((k, v) -> v >= 0);
            TObjectIntIterator iter = requestDiscount.iterator();
            while (iter.hasNext()) {
                iter.advance();
                wantFluids.adjustValue(iter.key(), -iter.value());
                iter.remove();
            }
            this.setRequestFailed(false);
            iter = wantFluids.iterator();
            while (iter.hasNext()) {
                iter.advance();
                FluidIdentifier need = (FluidIdentifier)iter.key();
                int countToRequest = iter.value();
                if (countToRequest == 0) continue;
                if (countToRequest < 0) {
                    requestDiscount.adjustOrPutValue((Object)need, -countToRequest, -countToRequest);
                    continue;
                }
                if (this._bucketMinimum.getAmount() != 0 && countToRequest < this._bucketMinimum.getAmount()) continue;
                if (!this.useEnergy(11)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    if ((countToRequest = RequestTree.requestFluidPartial(need, countToRequest, this, null)) > 0) {
                        success = true;
                    }
                } else {
                    success = RequestTree.requestFluid(need, countToRequest, this, null);
                }
                if (success) {
                    this._requestedItems.adjustOrPutValue((Object)need, countToRequest, countToRequest);
                    continue;
                }
                this.setRequestFailed(true);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
        this.amount = nbttagcompound.func_74762_e("amount");
        this._bucketMinimum = MinMode.values()[nbttagcompound.func_74771_c("_bucketMinimum")];
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
        nbttagcompound.func_74768_a("amount", this.amount);
        nbttagcompound.func_74774_a("_bucketMinimum", (byte)this._bucketMinimum.ordinal());
    }

    private void decreaseRequested(FluidIdentifier liquid, int remaining) {
        int count = this._requestedItems.get((Object)liquid);
        if (count <= 0) {
            return;
        }
        if (count <= remaining) {
            this._requestedItems.remove((Object)liquid);
        } else {
            this._requestedItems.put((Object)liquid, count - remaining);
        }
        if (remaining > count) {
            this.debug.log("liquid supplier got unexpected item " + liquid.toString());
        }
    }

    @Override
    public void liquidLost(FluidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
    }

    @Override
    public void liquidArrived(FluidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
        this.delayThrottle();
    }

    @Override
    public void liquidNotInserted(FluidIdentifier item, int amount) {
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    public MinMode getMinMode() {
        return this._bucketMinimum;
    }

    public void setMinMode(MinMode value) {
        this._bucketMinimum = value;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 18, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public IInventory getDummyInventory() {
        return this.dummyInventory;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        if (MainProxy.isClient(this.container.getWorld())) {
            this.amount = amount;
        }
    }

    public void changeFluidAmount(int change, EntityPlayer player) {
        this.amount += change;
        if (this.amount <= 0) {
            this.amount = 0;
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidSupplierAmount.class).setInteger(this.amount).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }

    public static enum MinMode {
        NONE(0),
        ONEBUCKET(1000),
        TWOBUCKET(2000),
        FIVEBUCKET(5000);

        private final int amount;

        private MinMode(int amount) {
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

