/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic.fluid;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.order.LogisticsFluidOrderManager;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class FluidRoutedPipe
extends CoreRoutedPipe {
    private WorldUtil worldUtil;
    private LogisticsFluidOrderManager _orderFluidManager;

    public FluidRoutedPipe(Item item) {
        super(new PipeFluidTransportLogistics(), item);
    }

    @Override
    public void setTile(TileEntity tile) {
        super.setTile(tile);
    }

    @Override
    public boolean logisitcsIsPipeConnected(TileEntity tile, ForgeDirection dir) {
        IFluidHandler liq;
        if (tile instanceof IFluidHandler && (liq = (IFluidHandler)tile).getTankInfo(dir.getOpposite()) != null && liq.getTankInfo(dir.getOpposite()).length > 0) {
            return true;
        }
        return tile instanceof LogisticsTileGenericPipe;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (this.isFluidSidedTexture(connection)) {
            return Textures.LOGISTICSPIPE_LIQUID_TEXTURE;
        }
        return super.getNonRoutedTexture(connection);
    }

    private boolean isFluidSidedTexture(ForgeDirection connection) {
        IFluidHandler liq;
        WorldUtil util = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        TileEntity tile = util.getAdjacentTileEntitie(connection);
        return tile instanceof IFluidHandler && (liq = (IFluidHandler)tile).getTankInfo(connection.getOpposite()) != null && liq.getTankInfo(connection.getOpposite()).length > 0;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public final List<Pair<TileEntity, ForgeDirection>> getAdjacentTanks(boolean flag) {
        if (this.worldUtil == null) {
            this.worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        }
        ArrayList<Pair<TileEntity, ForgeDirection>> tileList = new ArrayList<Pair<TileEntity, ForgeDirection>>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.worldUtil.getAdjacentTileEntitie(dir);
            if (!this.isConnectableTank(tile, dir, flag)) continue;
            tileList.add(new Pair<TileEntity, ForgeDirection>(tile, dir));
        }
        return tileList;
    }

    public final boolean isConnectableTank(TileEntity tile, ForgeDirection dir, boolean flag) {
        if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(tile)) {
            return true;
        }
        if (!(tile instanceof IFluidHandler)) {
            return false;
        }
        if (!this.canPipeConnect(tile, dir)) {
            return false;
        }
        if (tile instanceof LogisticsTileGenericPipe) {
            if (((LogisticsTileGenericPipe)tile).pipe instanceof FluidRoutedPipe) {
                return false;
            }
            if (!flag) {
                return false;
            }
            if (((LogisticsTileGenericPipe)tile).pipe == null || !(((LogisticsTileGenericPipe)tile).pipe.transport instanceof IFluidHandler)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.canInsertFromSideToTanks()) {
            int validDirections = 0;
            List<Pair<TileEntity, ForgeDirection>> list = this.getAdjacentTanks(true);
            for (Pair<TileEntity, ForgeDirection> pair : list) {
                FluidStack drain;
                int filled;
                if (pair.getValue1() instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)pair.getValue1()).pipe instanceof CoreRoutedPipe) continue;
                FluidTank tank = ((PipeFluidTransportLogistics)this.transport).sideTanks[pair.getValue2().ordinal()];
                ++validDirections;
                if (tank.getFluid() != null && (filled = ((IFluidHandler)pair.getValue1()).fill(pair.getValue2().getOpposite(), tank.getFluid().copy(), true)) != 0 && (drain = tank.drain(filled, true)) != null && filled == drain.amount) continue;
            }
            if (validDirections == 0) {
                return;
            }
            FluidTank tank = ((PipeFluidTransportLogistics)this.transport).internalTank;
            FluidStack stack = tank.getFluid();
            if (stack == null) {
                return;
            }
            for (Pair<TileEntity, ForgeDirection> pair : list) {
                FluidStack drain;
                int filled;
                if (pair.getValue1() instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)pair.getValue1()).pipe instanceof CoreRoutedPipe) continue;
                FluidTank tankSide = ((PipeFluidTransportLogistics)this.transport).sideTanks[pair.getValue2().ordinal()];
                stack = tank.getFluid();
                if (stack != null && (filled = tankSide.fill(stack = stack.copy(), true)) != 0 && (drain = tank.drain(filled, true)) != null && filled == drain.amount) continue;
            }
        }
    }

    public int countOnRoute(FluidIdentifier ident) {
        int amount = 0;
        for (ItemRoutingInformation next : this._inTransitToMe) {
            FluidStack liquid;
            ItemIdentifierStack item = next.getItem();
            if (!item.getItem().isFluidContainer() || !FluidIdentifier.get(liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(item)).equals(ident)) continue;
            amount += liquid.amount;
        }
        return amount;
    }

    public abstract boolean canInsertFromSideToTanks();

    public abstract boolean canInsertToTanks();

    public abstract boolean canReceiveFluid();

    public boolean endReached(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile) {
        if (this.canInsertToTanks() && MainProxy.isServer(this.getWorld())) {
            this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            if (arrivingItem.getItemIdentifierStack() == null || !arrivingItem.getItemIdentifierStack().getItem().isFluidContainer()) {
                return false;
            }
            if (this.getRouter().getSimpleID() != arrivingItem.getDestination()) {
                return false;
            }
            int filled = 0;
            FluidStack liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(arrivingItem.getItemIdentifierStack());
            if (this.isConnectableTank(tile, arrivingItem.output, false)) {
                List<Pair<TileEntity, ForgeDirection>> adjTanks = this.getAdjacentTanks(false);
                for (int i = 0; i < adjTanks.size(); ++i) {
                    Pair<TileEntity, ForgeDirection> pair = adjTanks.get(i);
                    IFluidHandler tank = (IFluidHandler)pair.getValue1();
                    ForgeDirection dir = pair.getValue2();
                    this.fillSide(liquid, dir, tank);
                    if (liquid.amount != 0) continue;
                    return true;
                }
                filled = ((PipeFluidTransportLogistics)this.transport).sideTanks[arrivingItem.output.ordinal()].fill(liquid, true);
                if (filled == liquid.amount) {
                    return true;
                }
                liquid.amount -= filled;
            }
            if ((filled = ((PipeFluidTransportLogistics)this.transport).internalTank.fill(liquid, true)) == liquid.amount) {
                return true;
            }
            liquid.amount -= filled;
            if (this instanceof IRequireReliableFluidTransport) {
                ((IRequireReliableFluidTransport)((Object)this)).liquidNotInserted(FluidIdentifier.get(liquid), liquid.amount);
            }
            LPTravelingItem.LPTravelingItemServer routedItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(SimpleServiceLocator.logisticsFluidManager.getFluidContainer(liquid));
            Pair<Integer, Integer> replies = SimpleServiceLocator.logisticsFluidManager.getBestReply(liquid, this.getRouter(), routedItem.getJamList());
            int dest = replies.getValue1();
            routedItem.setDestination(dest);
            routedItem.setTransportMode(IRoutedItem.TransportMode.Passive);
            this.queueRoutedItem(routedItem, arrivingItem.output.getOpposite());
            return true;
        }
        return false;
    }

    protected void fillSide(FluidStack toFill, ForgeDirection tankLocation, IFluidHandler tile) {
        toFill.amount -= tile.fill(tankLocation.getOpposite(), toFill.copy(), true);
    }

    @Override
    public boolean isFluidPipe() {
        return true;
    }

    @Override
    public boolean sharesInterestWith(CoreRoutedPipe other) {
        if (!(other instanceof FluidRoutedPipe)) {
            return false;
        }
        List<TileEntity> theirs = ((FluidRoutedPipe)other).getAllTankTiles();
        for (TileEntity tile : this.getAllTankTiles()) {
            if (!theirs.contains(tile)) continue;
            return true;
        }
        return false;
    }

    public List<TileEntity> getAllTankTiles() {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            list.addAll(SimpleServiceLocator.specialTankHandler.getBaseTileFor(pair.getValue1()));
        }
        return list;
    }

    public LogisticsFluidOrderManager getFluidOrderManager() {
        this._orderFluidManager = this._orderFluidManager != null ? this._orderFluidManager : new LogisticsFluidOrderManager(this);
        return this._orderFluidManager;
    }

    @Override
    public LogisticsOrderManager<?, ?> getOrderManager() {
        return this.getFluidOrderManager();
    }
}

