/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.reflection;

import com.google.common.base.Joiner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.timecore.api.reflection.UnlockedField;
import ru.timeconqueror.timecore.api.reflection.UnlockedMethod;

public class ReflectionHelper {
    private static final UnlockedField<Field> F_MODIFIERS = ReflectionHelper.findField(Field.class, "modifiers");

    public static boolean isFinal(Field f) {
        return Modifier.isFinal(f.getModifiers());
    }

    public static boolean isStatic(Field f) {
        return Modifier.isStatic(f.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static void unfinalize(Field f) throws IllegalAccessException {
        if (ReflectionHelper.isFinal(f)) {
            Field modifiersField = F_MODIFIERS.getField();
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        }
    }

    public static void setAccessible(Field f) {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
    }

    public static void setAccessible(Method m) {
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
    }

    public static void setAccessible(Constructor<?> c) {
        if (!c.isAccessible()) {
            c.setAccessible(true);
        }
    }

    @Nullable
    public static Class<?> createClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Optional<UnlockedField<T>> findFieldSoftly(Class<?> clazz, String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            return Optional.of(new UnlockedField(f));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static <T> UnlockedField<T> findField(Class<?> clazz, String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            return new UnlockedField(f);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't retrieve field " + fieldName + " from class " + clazz, e);
        }
    }

    public static <T> Optional<UnlockedMethod<T>> findMethodSoftly(Class<?> clazz, String methodName, Class<?> ... params) {
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(methodName) || !Arrays.equals(declaredMethod.getParameterTypes(), params)) continue;
            return Optional.of(new UnlockedMethod(declaredMethod));
        }
        return Optional.empty();
    }

    public static <T> UnlockedMethod<T> findMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, params);
            return new UnlockedMethod(method);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't retrieve method " + clazz.getName() + "#" + ReflectionHelper.getPrettySignature(methodName, params), e);
        }
    }

    public static void initClass(Class<?> clazz) {
        ReflectionHelper.initClass(clazz.getName());
    }

    public static void initClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LootGames.LOGGER.error("Can't load class" + className + ", because it isn't found");
            throw new RuntimeException();
        }
    }

    public static <E extends Enum<E>> E[] getEnumValues(Class<E> enumClass) {
        return (Enum[])enumClass.getEnumConstants();
    }

    public static String getPrettySignature(Class<?> owner, String methodName, Class<?> ... params) {
        return owner.getName() + "#" + ReflectionHelper.getPrettySignature(methodName, params);
    }

    public static String getPrettySignature(String methodName, Class<?> ... params) {
        return methodName + "(" + Joiner.on((String)",").join((Object[])params) + ")";
    }

    public static String getDescriptorForClass(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized primitive " + c);
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ('L' + c.getName() + ';').replace('.', '/');
    }

    public static String getMethodSignature(Method m) {
        return m.getName() + ReflectionHelper.getMethodDescriptor(m);
    }

    public static String getMethodDescriptor(Method m) {
        StringBuilder s = new StringBuilder("(");
        for (Class<?> c : m.getParameterTypes()) {
            s.append(ReflectionHelper.getDescriptorForClass(c));
        }
        s.append(')');
        return s + ReflectionHelper.getDescriptorForClass(m.getReturnType());
    }

    static {
        F_MODIFIERS.getField().setAccessible(true);
    }
}

