/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board.squares;

public final class File
extends Enum<File> {
    public static final /* enum */ File FILE_A = new File(0, "a");
    public static final /* enum */ File FILE_B = new File(1, "b");
    public static final /* enum */ File FILE_C = new File(2, "c");
    public static final /* enum */ File FILE_D = new File(3, "d");
    public static final /* enum */ File FILE_E = new File(4, "e");
    public static final /* enum */ File FILE_F = new File(5, "f");
    public static final /* enum */ File FILE_G = new File(6, "g");
    public static final /* enum */ File FILE_H = new File(7, "h");
    private static File[] files_arr;
    private int value;
    private String label;
    private static final /* synthetic */ File[] $VALUES;

    public static File[] values() {
        return (File[])$VALUES.clone();
    }

    public static File valueOf(String name) {
        return Enum.valueOf(File.class, name);
    }

    private File(int value, String label) {
        this.value = value;
        this.label = label;
    }

    public static File file(int value) {
        assert (value >= 0 && value <= 7);
        return files_arr[value];
    }

    public static File file(String value) {
        for (File f : File.values()) {
            if (!f.getLabel().equalsIgnoreCase(value)) continue;
            return f;
        }
        throw new IllegalArgumentException("File value not found: " + value);
    }

    public int getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public int distance(File f) {
        return Math.abs(f.getValue() - this.getValue());
    }

    public File flip() {
        return File.file(7 - this.value);
    }

    public boolean eastOf(File f) {
        return this.getValue() > f.getValue();
    }

    public boolean westOf(File f) {
        return this.getValue() < f.getValue();
    }

    public File east() {
        if (this.value == 7) {
            return null;
        }
        return File.file(this.value + 1);
    }

    public File west() {
        if (this.value == 0) {
            return null;
        }
        return File.file(this.value - 1);
    }

    static {
        $VALUES = new File[]{FILE_A, FILE_B, FILE_C, FILE_D, FILE_E, FILE_F, FILE_G, FILE_H};
        files_arr = new File[8];
        for (int i = 0; i < 8; ++i) {
            for (File f : File.values()) {
                if (f.getValue() != i) continue;
                File.files_arr[i] = f;
            }
        }
    }
}

