/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.api.LootGamesAPI;
import ru.timeconqueror.lootgames.api.block.GameBlock;
import ru.timeconqueror.lootgames.api.block.ILeftInteractible;
import ru.timeconqueror.lootgames.api.block.ISubordinateProvider;
import ru.timeconqueror.lootgames.api.block.tile.GameMasterTile;
import ru.timeconqueror.lootgames.client.IconLoader;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.util.WorldUtils;

public class SmartSubordinateBlock
extends GameBlock
implements ILeftInteractible,
ISubordinateProvider {
    public void func_149749_a(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        if (!worldIn.field_72995_K) {
            LootGamesAPI.getFieldManager().onFieldBlockBroken(worldIn, () -> SmartSubordinateBlock.getMasterPos(worldIn, BlockPos.of(x, y, z)));
        }
        super.func_149749_a(worldIn, x, y, z, blockBroken, meta);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        BlockPos pos = BlockPos.of(x, y, z);
        this.forMasterTile(player, worldIn, pos, (master, blockPos) -> master.onBlockRightClick(player, pos));
        return true;
    }

    @Override
    public boolean onLeftClick(World world, EntityPlayer player, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP && !player.func_70093_af()) {
            this.forMasterTile(player, world, pos, (master, masterPos) -> master.onBlockLeftClick(player, pos));
            return true;
        }
        return false;
    }

    private void forMasterTile(EntityPlayer player, World world, BlockPos pos, BiConsumer<GameMasterTile<?>, BlockPos> action) {
        BlockPos masterPos = SmartSubordinateBlock.getMasterPos(world, pos);
        WorldUtils.forTypedTileWithWarn(player, world, masterPos, GameMasterTile.class, master -> action.accept((GameMasterTile<?>)((Object)master), masterPos));
    }

    public static BlockPos getMasterPos(World world, BlockPos pos) {
        BlockPos.Mutable currentPos = pos.mutable();
        int limit = 128;
        while (currentPos.equals(pos) || WorldExt.getBlock(world, currentPos) instanceof ISubordinateProvider) {
            currentPos.move(-1, 0, 0);
            if (--limit != 0) continue;
        }
        currentPos.move(1, 0, 0);
        while (currentPos.equals(pos) || WorldExt.getBlock(world, currentPos) instanceof ISubordinateProvider) {
            currentPos.move(0, 0, -1);
            if (--limit != 0) continue;
        }
        currentPos.move(0, 0, 1);
        return currentPos.move(-1, 0, -1).immutable();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return IconLoader.shieldedDungeonFloor;
    }
}

