/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.io.PGNResult;
import com.jamesswafford.chess4j.io.PGNTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PGNGame {
    private List<PGNTag> tags = new ArrayList<PGNTag>();
    private List<Move> moves = new ArrayList<Move>();
    private PGNResult result;

    public PGNGame(List<PGNTag> tags, List<Move> moves, PGNResult result) {
        this.tags.addAll(tags);
        this.moves.addAll(moves);
        this.result = result;
    }

    public List<PGNTag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public List<Move> getMoves() {
        return Collections.unmodifiableList(this.moves);
    }

    public PGNResult getResult() {
        return this.result;
    }

    public int hashCode() {
        int hc = this.tags.hashCode();
        hc *= 31 * this.moves.hashCode();
        return hc *= 17 * this.result.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PGNGame)) {
            return false;
        }
        PGNGame that = (PGNGame)obj;
        if (!this.getTags().equals(that.getTags())) {
            return false;
        }
        if (!this.getMoves().equals(that.getMoves())) {
            return false;
        }
        return this.getResult().equals((Object)that.getResult());
    }
}

